/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.webapps.session.context;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Cookie;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.webapps.session.context.SessionContext;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.dom.DOMUtil;
import org.apache.excalibur.source.SourceParameters;
import org.apache.excalibur.xml.sax.SAXParser;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public final class RequestSessionContext
implements SessionContext {
    private static final String PARAMETERS_ELEMENT = "cinclude:parameters";
    private static final String PARAMETER_ELEMENT = "cinclude:parameter";
    private static final String NAME_ELEMENT = "cinclude:name";
    private static final String VALUE_ELEMENT = "cinclude:value";
    private String name;
    private transient Request request;
    private Document contextData;
    private XPathProcessor xpathProcessor;

    public void setup(String value, String loadResource, String saveResource) {
        this.name = value;
    }

    public void setup(Map objectModel, ServiceManager manager, XPathProcessor processor) throws ProcessingException {
        this.xpathProcessor = processor;
        this.request = ObjectModelHelper.getRequest((Map)objectModel);
        this.contextData = DOMUtil.createDocument();
        this.contextData.appendChild(this.contextData.createElementNS(null, "context"));
        Element root = this.contextData.getDocumentElement();
        SAXParser parser = null;
        try {
            parser = (SAXParser)manager.lookup(SAXParser.ROLE);
            this.buildParameterXML(root, parser);
        }
        catch (ServiceException ce) {
            throw new ProcessingException("Unable to lookup parser.", (Throwable)ce);
        }
        finally {
            manager.release((Object)parser);
        }
        this.buildAttributesXML(root);
        this.buildMiscXML(root);
        this.buildCookiesXML(root);
        this.buildHeadersXML(root);
    }

    public String getName() {
        return this.name;
    }

    public Request getRequest() {
        return this.request;
    }

    private String createPath(String path) {
        if (path == null) {
            path = "/";
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if ((path = "/context" + path).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private Node createTextNode(Document doc, String value) {
        return doc.createTextNode(value != null ? value : "");
    }

    private void buildMiscXML(Element root) {
        Document doc = root.getOwnerDocument();
        Element node = doc.createElementNS(null, "characterEncoding");
        node.appendChild(this.createTextNode(doc, this.request.getCharacterEncoding()));
        root.appendChild(node);
        node = doc.createElementNS(null, "contentLength");
        node.appendChild(this.createTextNode(doc, "" + this.request.getContentLength()));
        root.appendChild(node);
        node = doc.createElementNS(null, "contentType");
        node.appendChild(this.createTextNode(doc, this.request.getContentType()));
        root.appendChild(node);
        node = doc.createElementNS(null, "protocol");
        node.appendChild(this.createTextNode(doc, this.request.getProtocol()));
        root.appendChild(node);
        node = doc.createElementNS(null, "remoteAddress");
        node.appendChild(this.createTextNode(doc, this.request.getRemoteAddr()));
        root.appendChild(node);
        node = doc.createElementNS(null, "remoteHost");
        node.appendChild(this.createTextNode(doc, this.request.getRemoteHost()));
        root.appendChild(node);
        node = doc.createElementNS(null, "scheme");
        node.appendChild(this.createTextNode(doc, this.request.getScheme()));
        root.appendChild(node);
        node = doc.createElementNS(null, "serverName");
        node.appendChild(this.createTextNode(doc, this.request.getServerName()));
        root.appendChild(node);
        node = doc.createElementNS(null, "serverPort");
        node.appendChild(this.createTextNode(doc, "" + this.request.getServerPort()));
        root.appendChild(node);
        node = doc.createElementNS(null, "method");
        node.appendChild(this.createTextNode(doc, this.request.getMethod()));
        root.appendChild(node);
        node = doc.createElementNS(null, "contextPath");
        node.appendChild(this.createTextNode(doc, this.request.getContextPath()));
        root.appendChild(node);
        node = doc.createElementNS(null, "pathInfo");
        node.appendChild(this.createTextNode(doc, this.request.getPathInfo()));
        root.appendChild(node);
        node = doc.createElementNS(null, "pathTranslated");
        node.appendChild(this.createTextNode(doc, this.request.getPathTranslated()));
        root.appendChild(node);
        node = doc.createElementNS(null, "remoteUser");
        node.appendChild(this.createTextNode(doc, this.request.getRemoteUser()));
        root.appendChild(node);
        node = doc.createElementNS(null, "requestedSessionId");
        node.appendChild(this.createTextNode(doc, this.request.getRequestedSessionId()));
        root.appendChild(node);
        node = doc.createElementNS(null, "requestURI");
        node.appendChild(this.createTextNode(doc, this.request.getRequestURI()));
        root.appendChild(node);
        node = doc.createElementNS(null, "servletPath");
        node.appendChild(this.createTextNode(doc, this.request.getServletPath()));
        root.appendChild(node);
        node = doc.createElementNS(null, "isRequestedSessionIdFromCookie");
        node.appendChild(doc.createTextNode(this.request.isRequestedSessionIdFromCookie() ? "true" : "false"));
        root.appendChild(node);
        node = doc.createElementNS(null, "isRequestedSessionIdFromURL");
        node.appendChild(doc.createTextNode(this.request.isRequestedSessionIdFromURL() ? "true" : "false"));
        root.appendChild(node);
        node = doc.createElementNS(null, "isRequestedSessionIdValid");
        node.appendChild(doc.createTextNode(this.request.isRequestedSessionIdValid() ? "true" : "false"));
        root.appendChild(node);
    }

    private void buildAttributesXML(Element root) throws ProcessingException {
        Document doc = root.getOwnerDocument();
        Element attrElement = doc.createElementNS(null, "attributes");
        root.appendChild(attrElement);
        Enumeration all = this.request.getAttributeNames();
        while (all.hasMoreElements()) {
            String attrName = (String)all.nextElement();
            try {
                Element attr = doc.createElementNS(null, attrName);
                attrElement.appendChild(attr);
                DOMUtil.valueOf((Node)attr, (Object)this.request.getAttribute(attrName));
            }
            catch (DOMException de) {
                System.err.println("Cannot create XML element with name '" + attrName + "' : " + de.getMessage());
            }
        }
    }

    private void buildCookiesXML(Element root) {
        Document doc = root.getOwnerDocument();
        Element cookiesElement = doc.createElementNS(null, "cookies");
        root.appendChild(cookiesElement);
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie current = cookies[i];
                Element parent = doc.createElementNS(null, "cookie");
                parent.setAttributeNS(null, "name", current.getName());
                cookiesElement.appendChild(parent);
                Element node = doc.createElementNS(null, "comment");
                node.appendChild(this.createTextNode(doc, current.getComment()));
                parent.appendChild(node);
                node = doc.createElementNS(null, "domain");
                node.appendChild(this.createTextNode(doc, current.getDomain()));
                parent.appendChild(node);
                node = doc.createElementNS(null, "maxAge");
                node.appendChild(this.createTextNode(doc, "" + current.getMaxAge()));
                parent.appendChild(node);
                node = doc.createElementNS(null, "name");
                node.appendChild(this.createTextNode(doc, current.getName()));
                parent.appendChild(node);
                node = doc.createElementNS(null, "path");
                node.appendChild(this.createTextNode(doc, current.getPath()));
                parent.appendChild(node);
                node = doc.createElementNS(null, "secure");
                node.appendChild(doc.createTextNode(current.getSecure() ? "true" : "false"));
                parent.appendChild(node);
                node = doc.createElementNS(null, "value");
                node.appendChild(this.createTextNode(doc, current.getValue()));
                parent.appendChild(node);
                node = doc.createElementNS(null, "version");
                node.appendChild(this.createTextNode(doc, "" + current.getVersion()));
                parent.appendChild(node);
            }
        }
    }

    private void buildHeadersXML(Element root) {
        Document doc = root.getOwnerDocument();
        Element headersElement = doc.createElementNS(null, "headers");
        root.appendChild(headersElement);
        Enumeration all = this.request.getHeaderNames();
        while (all.hasMoreElements()) {
            String headerName = (String)all.nextElement();
            try {
                Element header = doc.createElementNS(null, headerName);
                headersElement.appendChild(header);
                header.appendChild(this.createTextNode(doc, this.request.getHeader(headerName)));
            }
            catch (Exception ignore) {}
        }
    }

    private void buildParameterXML(Element root, SAXParser parser) {
        Document doc = root.getOwnerDocument();
        Element parameterElement = doc.createElementNS(null, "parameter");
        Element parameterValuesElement = doc.createElementNS(null, "parametervalues");
        root.appendChild(parameterElement);
        root.appendChild(parameterValuesElement);
        String parameterName = null;
        Enumeration pars = this.request.getParameterNames();
        Element element = doc.createElementNS("http://apache.org/cocoon/include/1.0", PARAMETERS_ELEMENT);
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:cinclude", "http://apache.org/cocoon/include/1.0");
        parameterValuesElement.appendChild(element);
        parameterValuesElement = element;
        while (pars.hasMoreElements()) {
            parameterName = (String)pars.nextElement();
            String[] values = this.request.getParameterValues(parameterName);
            for (int i = 0; i < values.length; ++i) {
                Element parameter;
                Node valueNode;
                String parValue = values[i].trim();
                if (parValue.length() > 0 && parValue.charAt(0) == '<') {
                    try {
                        valueNode = DOMUtil.getDocumentFragment((SAXParser)parser, (Reader)new StringReader(parValue));
                        valueNode = doc.importNode(valueNode, true);
                    }
                    catch (Exception noXMLException) {
                        valueNode = doc.createTextNode(parValue);
                    }
                } else {
                    valueNode = doc.createTextNode(parValue);
                }
                if (i == 0) {
                    try {
                        parameter = doc.createElementNS(null, parameterName);
                        parameter.appendChild(valueNode);
                        parameterElement.appendChild(parameter);
                    }
                    catch (Exception local) {
                        // empty catch block
                    }
                }
                try {
                    element = doc.createElementNS("http://apache.org/cocoon/include/1.0", PARAMETER_ELEMENT);
                    parameterValuesElement.appendChild(element);
                    parameter = element;
                    element = doc.createElementNS("http://apache.org/cocoon/include/1.0", NAME_ELEMENT);
                    parameter.appendChild(element);
                    element.appendChild(doc.createTextNode(parameterName));
                    element = doc.createElementNS("http://apache.org/cocoon/include/1.0", VALUE_ELEMENT);
                    parameter.appendChild(element);
                    element.appendChild(valueNode.cloneNode(true));
                    continue;
                }
                catch (Exception local) {
                    // empty catch block
                }
            }
        }
        element = doc.createElementNS(null, "querystring");
        root.appendChild(element);
        String value = this.request.getQueryString();
        if (value != null) {
            element.appendChild(doc.createTextNode('?' + value));
        }
    }

    public DocumentFragment getXML(String path) throws ProcessingException {
        NodeList list;
        if (path == null || path.charAt(0) != '/') {
            throw new ProcessingException("Not a valid XPath: " + path);
        }
        path = this.createPath(path);
        DocumentFragment result = null;
        try {
            list = DOMUtil.selectNodeList((Node)this.contextData, (String)path, (XPathProcessor)this.xpathProcessor);
        }
        catch (TransformerException localException) {
            throw new ProcessingException("Exception: " + localException, (Throwable)localException);
        }
        if (list != null && list.getLength() > 0) {
            result = DOMUtil.getOwnerDocument((Node)this.contextData).createDocumentFragment();
            for (int i = 0; i < list.getLength(); ++i) {
                if (list.item(i).getNodeType() == 2) {
                    result.appendChild(DOMUtil.getOwnerDocument((Node)this.contextData).createTextNode(list.item(i).getNodeValue()));
                    continue;
                }
                NodeList childs = list.item(i).getChildNodes();
                if (childs == null) continue;
                for (int m = 0; m < childs.getLength(); ++m) {
                    result.appendChild(DOMUtil.getOwnerDocument((Node)this.contextData).importNode(childs.item(m), true));
                }
            }
        }
        return result;
    }

    public void setXML(String path, DocumentFragment fragment) throws ProcessingException {
        throw new ProcessingException("RequestSessionContext: Setting of xml not allowed");
    }

    public void setValueOfNode(String path, String value) throws ProcessingException {
        throw new ProcessingException("RequestSessionContext: Setting of xml not allowed");
    }

    public void appendXML(String path, DocumentFragment fragment) throws ProcessingException {
        throw new ProcessingException("RequestSessionContext: Appending of xml not allowed");
    }

    public void removeXML(String path) throws ProcessingException {
        throw new ProcessingException("RequestSessionContext: Removing of xml not allowed");
    }

    public void setAttribute(String key, Object value) throws ProcessingException {
        if (value == null) {
            this.request.removeAttribute(key);
        } else {
            this.request.setAttribute(key, value);
        }
    }

    public Object getAttribute(String key) throws ProcessingException {
        return this.request.getAttribute(key);
    }

    public Object getAttribute(String key, Object defaultObject) throws ProcessingException {
        Object obj = this.getAttribute(key);
        return obj != null ? obj : defaultObject;
    }

    public Node getSingleNode(String path) throws ProcessingException {
        path = this.createPath(path);
        Node node = null;
        try {
            node = DOMUtil.getSingleNode((Node)this.contextData, (String)path, (XPathProcessor)this.xpathProcessor);
        }
        catch (TransformerException localException) {
            throw new ProcessingException("Exception: " + localException, (Throwable)localException);
        }
        return node;
    }

    public NodeList getNodeList(String path) throws ProcessingException {
        path = this.createPath(path);
        NodeList list = null;
        try {
            list = DOMUtil.selectNodeList((Node)this.contextData, (String)path, (XPathProcessor)this.xpathProcessor);
        }
        catch (TransformerException localException) {
            throw new ProcessingException("Exception: " + localException, (Throwable)localException);
        }
        return list;
    }

    public void setNode(String path, Node node) throws ProcessingException {
        throw new ProcessingException("RequestSessionContext: Setting of XML not allowed");
    }

    public String getValueOfNode(String path) throws ProcessingException {
        String value = null;
        Node node = this.getSingleNode(path);
        if (node != null) {
            value = DOMUtil.getValueOfNode((Node)node);
        }
        return value;
    }

    public boolean streamXML(String path, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws SAXException, ProcessingException {
        NodeList list;
        boolean result = false;
        try {
            list = DOMUtil.selectNodeList((Node)this.contextData, (String)this.createPath(path), (XPathProcessor)this.xpathProcessor);
        }
        catch (TransformerException local) {
            throw new ProcessingException("TransformerException: " + local, (Throwable)local);
        }
        if (list != null && list.getLength() > 0) {
            result = true;
            for (int i = 0; i < list.getLength(); ++i) {
                if (list.item(i).getNodeType() == 2) {
                    String value = list.item(i).getNodeValue();
                    contentHandler.characters(value.toCharArray(), 0, value.length());
                    continue;
                }
                NodeList childs = list.item(i).getChildNodes();
                if (childs == null) continue;
                for (int m = 0; m < childs.getLength(); ++m) {
                    IncludeXMLConsumer.includeNode((Node)childs.item(m), (ContentHandler)contentHandler, (LexicalHandler)lexicalHandler);
                }
            }
        }
        return result;
    }

    public DocumentFragment getParameterAsXML(String parameterName) throws ProcessingException {
        return this.getXML("/parameter/" + parameterName);
    }

    public String getParameter(String parameterName) {
        return this.request.getParameter(parameterName);
    }

    public void loadXML(String path, SourceParameters parameters) throws SAXException, ProcessingException, IOException {
        throw new ProcessingException("The context " + this.name + " does not support loading.");
    }

    public void saveXML(String path, SourceParameters parameters) throws SAXException, ProcessingException, IOException {
        throw new ProcessingException("The context " + this.name + " does not support saving.");
    }
}

