/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.webapps.session.transformation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.configuration.SAXConfigurationHandler;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.ValidatorActionResult;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.webapps.session.transformation.SessionPreTransformer;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SessionPostTransformer
extends SessionPreTransformer {
    public static final String DELETECONTEXT_ELEMENT = "deletecontext";
    public static final String DELETECONTEXT_NAME_ATTRIBUTE = "name";
    public static final String SETXML_ELEMENT = "setxml";
    public static final String SETXML_CONTEXT_ATTRIBUTE = "context";
    public static final String SETXML_PATH_ATTRIBUTE = "path";
    public static final String APPENDXML_ELEMENT = "appendxml";
    public static final String APPENDXML_CONTEXT_ATTRIBUTE = "context";
    public static final String APPENDXML_PATH_ATTRIBUTE = "path";
    public static final String REMOVEXML_ELEMENT = "removexml";
    public static final String REMOVEXML_CONTEXT_ATTRIBUTE = "context";
    public static final String REMOVEXML_PATH_ATTRIBUTE = "path";
    public static final String MERGEXML_ELEMENT = "mergexml";
    public static final String MERGEXML_CONTEXT_ATTRIBUTE = "context";
    public static final String MERGEXML_PATH_ATTRIBUTE = "path";
    public static final String SAVECONTEXT_ELEMENT = "savexml";
    public static final String SAVECONTEXT_CONTEXT_ATTRIBUTE = "context";
    public static final String SAVECONTEXT_PATH_ATTRIBUTE = "path";
    public static final String INPUTXML_ELEMENT = "inputxml";
    public static final String INPUTXML_CONTEXT_ATTRIBUTE = "context";
    public static final String INPUTXML_PATH_ATTRIBUTE = "path";
    public static final String INPUTXML_NAME_ATTRIBUTE = "name";
    public static final String INPUTXML_TYPE_ATTRIBUTE = "type";
    public static final String INPUTXML_VALIDATIONRESULT_ATTRIBUTE = "valresult";
    public static final String FORM_ELEMENT = "form";
    public static final String FORM_ACTION_ELEMENT = "action";
    public static final String FORM_CONTENT_ELEMENT = "content";
    public static final String FORM_VALIDATION_ELEMENT = "validate";
    public static final String FORM_VALIDATION_SOURCE_ATTRIBUTE = "src";
    public static final String FORM_VALIDATESET_ELEMENT = "constraint-set";
    private static final int STATE_OUTSIDE = 0;
    private static final int STATE_FORM = 1;
    private int state;
    private String formName;
    private Map validationResultMap;

    public void setupTransforming() throws ProcessingException, SAXException, IOException {
        super.setupTransforming();
        this.state = 0;
        this.formName = null;
    }

    public void startTransformingElement(String uri, String name, String raw, Attributes attr) throws ProcessingException, IOException, SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN startTransformingElement uri=" + uri + ", name=" + name + ", raw=" + raw + ", attr=" + attr);
        }
        if (name.equals(DELETECONTEXT_ELEMENT)) {
            this.getContextManager().deleteContext(attr.getValue("name"));
        } else if (name.equals(SETXML_ELEMENT)) {
            this.startRecording();
            this.stack.push(attr.getValue("context"));
            this.stack.push(attr.getValue("path"));
        } else if (name.equals(MERGEXML_ELEMENT)) {
            this.startRecording();
            this.stack.push(attr.getValue("context"));
            this.stack.push(attr.getValue("path"));
        } else if (name.equals(APPENDXML_ELEMENT)) {
            this.startRecording();
            this.stack.push(attr.getValue("context"));
            this.stack.push(attr.getValue("path"));
        } else if (name.equals(REMOVEXML_ELEMENT)) {
            this.startTextRecording();
            this.stack.push(attr.getValue("context"));
            this.stack.push(attr.getValue("path"));
        } else if (name.equals(SAVECONTEXT_ELEMENT)) {
            this.startParametersRecording();
            this.stack.push(attr.getValue("context"));
            if (attr.getValue("path") != null) {
                this.stack.push(attr.getValue("path"));
            } else {
                this.stack.push("/");
            }
        } else if (name.equals(INPUTXML_ELEMENT)) {
            this.stack.push(attr.getValue("context"));
            String fieldname = attr.getValue("name");
            this.stack.push(fieldname);
            this.stack.push(attr.getValue("path"));
            AttributesImpl newattr = new AttributesImpl();
            newattr.addAttribute("", "name", "name", "CDATA", fieldname);
            if (attr.getValue(INPUTXML_TYPE_ATTRIBUTE) != null) {
                newattr.addAttribute("", INPUTXML_TYPE_ATTRIBUTE, INPUTXML_TYPE_ATTRIBUTE, "CDATA", attr.getValue(INPUTXML_TYPE_ATTRIBUTE));
            }
            ValidatorActionResult validationResult = null;
            if (this.validationResultMap != null && this.validationResultMap.get(fieldname) != null) {
                validationResult = (ValidatorActionResult)this.validationResultMap.get(fieldname);
                newattr.addAttribute("", INPUTXML_VALIDATIONRESULT_ATTRIBUTE, INPUTXML_VALIDATIONRESULT_ATTRIBUTE, "CDATA", validationResult.toString());
            }
            super.startTransformingElement("", name, name, newattr);
            this.startRecording();
        } else if (name.equals(FORM_ELEMENT) && this.state == 0) {
            String formName = attr.getValue("name");
            if (formName == null) {
                throw new ProcessingException("The name attribute of the form element is required.");
            }
            this.stack.push(new Integer(this.state));
            this.state = 1;
            this.stack.push(new AttributesImpl(attr));
        } else if (name.equals(FORM_ACTION_ELEMENT) && this.state == 1) {
            this.startTextRecording();
        } else if (name.equals(FORM_CONTENT_ELEMENT) && this.state == 1) {
            this.validationResultMap = (Map)this.getSessionManager().getSession(true).getAttribute(this.formName + "validation-result");
        } else if (name.equals(FORM_VALIDATION_ELEMENT) && this.state == 1) {
            this.startRecording();
            if (attr.getValue(FORM_VALIDATION_SOURCE_ATTRIBUTE) != null) {
                this.stack.push(attr.getValue(FORM_VALIDATION_SOURCE_ATTRIBUTE));
            } else {
                this.stack.push("EMPTY");
            }
        } else {
            super.startTransformingElement(uri, name, raw, attr);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END startTransformingElement");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void endTransformingElement(String uri, String name, String raw) throws ProcessingException, IOException, SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN endTransformingElement uri=" + uri + ", name=" + name + ", raw=" + raw);
        }
        if (!name.equals("deletecontext")) {
            if (name.equals("setxml")) {
                path = (String)this.stack.pop();
                contextName = (String)this.stack.pop();
                this.getSessionManager().setContextFragment(contextName, path, this.endRecording());
            } else if (name.equals("mergexml")) {
                path = (String)this.stack.pop();
                contextName = (String)this.stack.pop();
                this.getSessionManager().mergeContextFragment(contextName, path, this.endRecording());
            } else if (name.equals("appendxml")) {
                path = (String)this.stack.pop();
                contextName = (String)this.stack.pop();
                this.getSessionManager().appendContextFragment(contextName, path, this.endRecording());
            } else if (name.equals("removexml")) {
                path = (String)this.stack.pop();
                contextName = (String)this.stack.pop();
                this.endTextRecording();
                this.getSessionManager().removeContextFragment(contextName, path);
            } else if (name.equals("savexml")) {
                path = (String)this.stack.pop();
                contextName = (String)this.stack.pop();
                pars = this.endParametersRecording(null);
                pars.setSingleParameterValue("contextname", contextName);
                pars.setSingleParameterValue("path", path);
                this.getContextManager().getContext(contextName).saveXML(path, pars);
            } else if (name.equals("inputxml")) {
                path = (String)this.stack.pop();
                fieldname = (String)this.stack.pop();
                contextname = (String)this.stack.pop();
                defaultFragment = this.endRecording();
                if (this.formName == null) {
                    throw new ProcessingException("The inputxml must be contained inside a form.");
                }
                value = this.getFormManager().registerInputField(contextname, path, fieldname, this.formName);
                if (value == null) {
                    value = defaultFragment;
                }
                this.sendEvents(value);
                super.endTransformingElement("", name, name);
            } else if (name.equals("form") && this.state == 1) {
                this.state = (Integer)this.stack.pop();
                this.sendEndElementEvent("form");
                this.formName = null;
            } else if (name.equals("action") && this.state == 1) {
                action = this.endTextRecording();
                a = (AttributesImpl)this.stack.pop();
                this.formName = a.getValue("name");
                hasPars = action.indexOf("?") != -1;
                action = this.response.encodeURL(action + (hasPars != false ? '&' : '?') + "sessionform" + '=' + this.formName);
                a.addAttribute("", "action", "action", "CDATA", action);
                if (a.getValue("method") == null) {
                    a.addAttribute("", "method", "method", "CDATA", "POST");
                }
                this.sendStartElementEvent("form", a);
            } else if (!name.equals("content") || this.state != 1) {
                if (name.equals("validate") && this.state == 1) {
                    if (this.formName == null) {
                        throw new ProcessingException("The validate element must be contained inside a form.");
                    }
                    validationDoc = this.endRecording();
                    source = (String)this.stack.pop();
                    if (!source.equals("EMPTY")) {
                        try {
                            resource = this.resolver.resolveURI(source);
                            saxBuilder = new SAXConfigurationHandler();
                            SourceUtil.parse((ServiceManager)this.manager, (Source)resource, (ContentHandler)saxBuilder);
                            conf = saxBuilder.getConfiguration();
                            session = this.getSessionManager().getSession(true);
                            session.setAttribute(this.formName, (Object)conf);
                            if (validationDoc == null) ** GOTO lbl116
                            validationDoc.normalize();
                            validationNode = validationDoc.getFirstChild();
                            while (validationNode.getNodeType() != 1 && (validationNode = validationNode.getNextSibling()) != null) {
                            }
                            if (validationNode == null || validationNode.getNodeType() != 1 || !validationNode.getNodeName().equals("constraint-set")) ** GOTO lbl116
                            props = XMLUtils.createPropertiesForXML((boolean)false);
                            props.put("encoding", "ISO-8859-1");
                            validationXML = XMLUtils.serializeNode((Node)validationNode, (Properties)props);
                            builder = new DefaultConfigurationBuilder();
                            conf = builder.build((InputStream)new ByteArrayInputStream(validationXML.getBytes()));
                            session.setAttribute(this.formName + "constraint-set", (Object)conf);
                        }
                        catch (SourceException se) {
                            throw new ProcessingException("Cannot resolve" + source, (Throwable)se);
                        }
                        catch (ConfigurationException ce) {
                            throw new ProcessingException("Error building Configuration out of constraint-set element", (Throwable)ce);
                        }
                    } else if (validationDoc != null) {
                        try {
                            validationDoc.normalize();
                            validationNode = validationDoc.getFirstChild();
                            while (validationNode.getNodeType() != 1 && (validationNode = validationNode.getNextSibling()) != null) {
                            }
                            if (validationNode == null || validationNode.getNodeType() != 1 || !validationNode.getNodeName().equals("root")) ** GOTO lbl116
                            props = XMLUtils.createPropertiesForXML((boolean)false);
                            props.put("encoding", "ISO-8859-1");
                            validationXML = XMLUtils.serializeNode((Node)validationNode, (Properties)props);
                            builder = new DefaultConfigurationBuilder();
                            conf = builder.build((InputStream)new ByteArrayInputStream(validationXML.getBytes()));
                            session = this.getSessionManager().getSession(true);
                            session.setAttribute(this.formName, (Object)conf);
                            session.setAttribute(this.formName + "constraint-set", (Object)conf.getChildren("constraint-set")[0]);
                        }
                        catch (ConfigurationException ce) {
                            throw new ProcessingException("Error building Configuration out of validation XML", (Throwable)ce);
                        }
                    }
                } else {
                    super.endTransformingElement(uri, name, raw);
                }
            }
        }
lbl116:
        // 19 sources

        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END endTransformingElement");
        }
    }
}

