/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.net.MalformedURLException;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.FopImageFactory;
import org.apache.fop.image.ImageArea;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.MarginInlineProps;
import org.apache.fop.layout.RelativePositionProps;

public class ExternalGraphic
extends FObj {
    int breakAfter;
    int breakBefore;
    int align;
    int startIndent;
    int endIndent;
    int spaceBefore;
    int spaceAfter;
    String src;
    int height;
    int width;
    String id;
    ImageArea imageArea;

    public static FObj.Maker maker() {
        return new Maker();
    }

    public ExternalGraphic(FObj parent, PropertyList propertyList, String systemId, int line, int column) {
        super(parent, propertyList, systemId, line, column);
    }

    public String getName() {
        return "fo:external-graphic";
    }

    public int layout(Area area) throws FOPException {
        if (this.marker == -1000) {
            AccessibilityProps mAccProps = this.propMgr.getAccessibilityProps();
            AuralProps mAurProps = this.propMgr.getAuralProps();
            BorderAndPadding bap = this.propMgr.getBorderAndPadding();
            BackgroundProps bProps = this.propMgr.getBackgroundProps();
            MarginInlineProps mProps = this.propMgr.getMarginInlineProps();
            RelativePositionProps mRelProps = this.propMgr.getRelativePositionProps();
            this.align = this.properties.get("text-align").getEnum();
            this.startIndent = this.properties.get("start-indent").getLength().mvalue();
            this.endIndent = this.properties.get("end-indent").getLength().mvalue();
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.src = this.properties.get("src").getString();
            this.width = this.properties.get("width").getLength().mvalue();
            this.height = this.properties.get("height").getLength().mvalue();
            this.id = this.properties.get("id").getString();
            try {
                area.getIDReferences().createID(this.id);
            }
            catch (FOPException e) {
                if (!e.isLocationSet()) {
                    e.setLocation(this.systemId, this.line, this.column);
                }
                throw e;
            }
            this.marker = 0;
        }
        try {
            FopImage img = FopImageFactory.Make(this.src);
            if (this.width == 0 || this.height == 0) {
                double imgWidth = img.getWidth();
                double imgHeight = img.getHeight();
                if (this.width == 0 && this.height == 0) {
                    this.width = (int)(imgWidth * 1000.0);
                    this.height = (int)(imgHeight * 1000.0);
                } else if (this.height == 0) {
                    this.height = (int)(imgHeight * (double)this.width / imgWidth);
                } else if (this.width == 0) {
                    this.width = (int)(imgWidth * (double)this.height / imgHeight);
                }
            }
            double ratio = (double)this.width / (double)this.height;
            int areaWidth = area.getAllocationWidth() - this.startIndent - this.endIndent;
            int pageHeight = area.getPage().getBody().getMaxHeight() - this.spaceBefore;
            if (this.height > pageHeight) {
                this.height = pageHeight;
                this.width = (int)(ratio * (double)this.height);
            }
            if (this.width > areaWidth) {
                this.width = areaWidth;
                this.height = (int)((double)this.width / ratio);
            }
            if (area.spaceLeft() < this.height + this.spaceBefore) {
                return 2;
            }
            this.imageArea = new ImageArea(this.propMgr.getFontState(area.getFontInfo()), img, area.getAllocationWidth(), this.width, this.height, this.startIndent, this.endIndent, this.align);
            if (this.spaceBefore != 0 && this.marker == 0) {
                area.addDisplaySpace(this.spaceBefore);
            }
            if (this.marker == 0) {
                area.getIDReferences().configureID(this.id, area);
            }
            this.imageArea.start();
            this.imageArea.end();
            if (this.spaceAfter != 0) {
                area.addDisplaySpace(this.spaceAfter);
            }
            if (this.breakBefore == 83 || this.spaceBefore + this.imageArea.getHeight() > area.spaceLeft()) {
                return 4;
            }
            if (this.breakBefore == 80) {
                return 6;
            }
            if (this.breakBefore == 35) {
                return 5;
            }
            if (area instanceof BlockArea) {
                BlockArea ba = (BlockArea)area;
                LineArea la = ba.getCurrentLineArea();
                if (la == null) {
                    return 2;
                }
                la.addPending();
                if (this.imageArea.getContentWidth() > la.getRemainingWidth() && (la = ba.createNextLineArea()) == null) {
                    return 2;
                }
                la.addInlineArea(this.imageArea, this.getLinkSet());
            } else {
                area.addChild(this.imageArea);
                area.increaseHeight(this.imageArea.getContentHeight());
            }
            this.imageArea.setPage(area.getPage());
            if (this.breakAfter == 83) {
                this.marker = -1001;
                return 4;
            }
            if (this.breakAfter == 80) {
                this.marker = -1001;
                return 6;
            }
            if (this.breakAfter == 35) {
                this.marker = -1001;
                return 5;
            }
        }
        catch (MalformedURLException urlex) {
            this.log.error("Error while creating area : " + urlex.getMessage());
        }
        catch (FopImageException imgex) {
            this.log.error("Error while creating area : " + imgex.getMessage());
        }
        return 1;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new ExternalGraphic(parent, propertyList, systemId, line, column);
        }
    }
}

