/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.converter;

import java.util.HashMap;
import java.util.Map;
import org.jfor.jfor.converter.ValueConversionException;

class FoUnitsConverter {
    private static final FoUnitsConverter m_instance = new FoUnitsConverter();
    public static final float POINT_TO_TWIPS = 20.0f;
    public static final float IN_TO_TWIPS = 1440.0f;
    public static final float MM_TO_TWIPS = 56.692913f;
    public static final float CM_TO_TWIPS = 566.92914f;
    private static final Map m_twipFactors = new HashMap();

    private FoUnitsConverter() {
    }

    static FoUnitsConverter getInstance() {
        return m_instance;
    }

    float convertToTwips(String string) throws ValueConversionException {
        string = string.trim();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!Character.isDigit(c) && c != '.') {
                stringBuffer2.append(string.substring(n).trim());
                break;
            }
            stringBuffer.append(c);
            ++n;
        }
        return this.numberToTwips(stringBuffer.toString(), stringBuffer2.toString());
    }

    private float numberToTwips(String string, String string2) throws ValueConversionException {
        float f = 0.0f;
        try {
            if (string != null && string.trim().length() > 0) {
                f = Float.valueOf(string).floatValue();
            }
        }
        catch (Exception exception) {
            throw new ValueConversionException("number format error: cannot convert '" + string + "' to float value");
        }
        if (string2 != null && string2.trim().length() > 0) {
            Float f2 = (Float)m_twipFactors.get(string2.toLowerCase());
            if (f2 == null) {
                throw new ValueConversionException("conversion factor not found for '" + string2 + "' units");
            }
            f *= f2.floatValue();
        }
        return f;
    }

    int convertFontSize(String string) throws ValueConversionException {
        if (!(string = string.trim()).endsWith("pt")) {
            throw new ValueConversionException("Invalid font size '" + string + "', must end with '" + "pt" + "'");
        }
        float f = 0.0f;
        string = string.substring(0, string.length() - "pt".length());
        try {
            f = Float.valueOf(string).floatValue();
        }
        catch (Exception exception) {
            throw new ValueConversionException("Invalid font size value '" + string + "'");
        }
        return (int)((double)f * 2.0);
    }

    static {
        m_twipFactors.put("mm", new Float(56.692913f));
        m_twipFactors.put("cm", new Float(566.92914f));
        m_twipFactors.put("pt", new Float(20.0f));
        m_twipFactors.put("in", new Float(1440.0f));
    }
}

