/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.ComposedJXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBuilderBase;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;

public class ContextJXPathBinding
extends ComposedJXPathBindingBase {
    private final String xpath;

    public ContextJXPathBinding(JXPathBindingBuilderBase.CommonAttributes commonAtts, String contextPath, JXPathBindingBase[] childBindings) {
        super(commonAtts, childBindings);
        this.xpath = contextPath;
    }

    public void doLoad(Widget frmModel, JXPathContext jxpc) throws BindingException {
        Pointer ptr = jxpc.getPointer(this.xpath);
        if (ptr.getNode() != null) {
            JXPathContext subContext = jxpc.getRelativeContext(ptr);
            super.doLoad(frmModel, subContext);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("done loading " + this.toString());
            }
        } else if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("non-existent path: skipping " + this.toString());
        }
    }

    public void doSave(Widget frmModel, JXPathContext jxpc) throws BindingException {
        Pointer ptr = jxpc.getPointer(this.xpath);
        if (ptr.getNode() == null) {
            jxpc.createPath(this.xpath);
            ptr = jxpc.getPointer(this.xpath);
        }
        JXPathContext subContext = jxpc.getRelativeContext(ptr);
        super.doSave(frmModel, subContext);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("done saving " + this.toString());
        }
    }

    protected String getXPath() {
        return this.xpath;
    }

    public String toString() {
        return "ContextJXPathBinding [xpath=" + this.xpath + "]";
    }
}

