/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.forms.binding.Binding;
import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.JXPathBindingBuilderBase;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.util.jxpath.DOMFactory;
import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;

public abstract class JXPathBindingBase
implements Binding,
LogEnabled {
    private Logger logger;
    private final JXPathBindingBuilderBase.CommonAttributes commonAtts;
    protected Binding parent;
    protected Map classes;

    private JXPathBindingBase() {
        this(JXPathBindingBuilderBase.CommonAttributes.DEFAULT);
    }

    protected JXPathBindingBase(JXPathBindingBuilderBase.CommonAttributes commonAtts) {
        this.commonAtts = commonAtts;
    }

    public String getLocation() {
        return this.commonAtts.location;
    }

    public void setParent(Binding binding) {
        this.parent = binding;
    }

    public String getId() {
        return null;
    }

    public Binding getClass(String id) {
        Binding classBinding = null;
        if (this.classes != null) {
            classBinding = (Binding)this.classes.get(id);
        }
        if (classBinding == null) {
            if (this.parent != null) {
                classBinding = this.parent.getClass(id);
                if (this.classes == null) {
                    this.classes = new HashMap();
                }
                this.classes.put(id, classBinding);
            } else {
                throw new RuntimeException("Class \"" + id + "\" not found (" + this.getLocation() + ")");
            }
        }
        return classBinding;
    }

    protected Widget selectWidget(Widget parent, String id) {
        if (id == null) {
            return parent;
        }
        Widget childWidget = null;
        childWidget = parent.lookupWidget(id);
        if (childWidget == null) {
            String containerId = parent.getRequestParameterName();
            containerId = containerId == null || "".equals(containerId) ? "top-level form-widget" : "container \"" + containerId + "\"";
            throw new RuntimeException(this.getClass().getName() + " (" + this.getLocation() + "): Widget \"" + id + "\" does not exist in the " + containerId + " (" + parent.getLocation() + ").");
        }
        return childWidget;
    }

    public abstract void doLoad(Widget var1, JXPathContext var2) throws BindingException;

    public final void loadFormFromModel(Widget frmModel, JXPathContext jxpc) throws BindingException {
        boolean inheritedLeniency = jxpc.isLenient();
        this.applyLeniency(jxpc);
        this.applyNSDeclarations(jxpc);
        if (this.commonAtts.loadEnabled) {
            this.doLoad(frmModel, jxpc);
        }
        jxpc.setLenient(inheritedLeniency);
    }

    public final void loadFormFromModel(Widget frmModel, Object objModel) throws BindingException {
        if (objModel == null) {
            throw new NullPointerException("null object passed to loadFormFromModel() method");
        }
        JXPathContext jxpc = this.makeJXPathContext(objModel);
        this.loadFormFromModel(frmModel, jxpc);
    }

    public abstract void doSave(Widget var1, JXPathContext var2) throws BindingException;

    public final void saveFormToModel(Widget frmModel, JXPathContext jxpc) throws BindingException {
        boolean inheritedLeniency = jxpc.isLenient();
        this.applyLeniency(jxpc);
        this.applyNSDeclarations(jxpc);
        if (this.commonAtts.saveEnabled) {
            this.doSave(frmModel, jxpc);
        }
        jxpc.setLenient(inheritedLeniency);
    }

    public void saveFormToModel(Widget frmModel, Object objModel) throws BindingException {
        if (objModel == null) {
            throw new NullPointerException("null object passed to saveFormToModel() method");
        }
        JXPathContext jxpc = this.makeJXPathContext(objModel);
        this.saveFormToModel(frmModel, jxpc);
    }

    private void applyLeniency(JXPathContext jxpc) {
        if (this.commonAtts.leniency != null) {
            jxpc.setLenient(this.commonAtts.leniency.booleanValue());
        }
    }

    private void applyNSDeclarations(JXPathContext jxpc) {
        if (this.commonAtts.nsDeclarations != null) {
            Iterator keysIter = this.commonAtts.nsDeclarations.keySet().iterator();
            while (keysIter.hasNext()) {
                String nsuri = (String)keysIter.next();
                String pfx = (String)this.commonAtts.nsDeclarations.get(nsuri);
                jxpc.registerNamespace(pfx, nsuri);
            }
        }
    }

    private JXPathContext makeJXPathContext(Object objModel) {
        JXPathContext jxpc;
        if (!(objModel instanceof JXPathContext)) {
            jxpc = JXPathContext.newContext((Object)objModel);
            jxpc.setLenient(true);
            jxpc.setFactory((AbstractFactory)new BindingJXPathFactory());
        } else {
            jxpc = (JXPathContext)objModel;
        }
        return jxpc;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    private static class BindingJXPathFactory
    extends DOMFactory {
        private BindingJXPathFactory() {
        }

        public boolean createObject(JXPathContext context, Pointer pointer, Object parent, String name, int index) {
            if (this.createCollectionItem(context, pointer, parent, name, index)) {
                return true;
            }
            return super.createObject(context, pointer, parent, name, index);
        }

        private boolean createCollectionItem(JXPathContext context, Pointer pointer, Object parent, String name, int index) {
            Object o = context.getValue(name);
            if (o == null) {
                return false;
            }
            if (!(o instanceof Collection)) {
                if (o.getClass().isArray()) {
                    return false;
                }
                return false;
            }
            ((Collection)o).add(null);
            return true;
        }
    }
}

