/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import java.util.Map;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.JXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingManager;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.commons.lang.BooleanUtils;
import org.w3c.dom.Element;

public abstract class JXPathBindingBuilderBase
implements LogEnabled {
    private Logger logger;

    public void enableLogging(Logger logger) {
        this.logger = logger;
        if (logger.isDebugEnabled()) {
            logger.debug("JXPathBindingBuilderBase got logger...");
        }
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public abstract JXPathBindingBase buildBinding(Element var1, JXPathBindingManager.Assistant var2) throws BindingException;

    protected static CommonAttributes getCommonAttributes(Element bindingElm) throws BindingException {
        try {
            String location = DomHelper.getLocation(bindingElm);
            if (DomHelper.getAttributeAsBoolean(bindingElm, "readonly", false)) {
                throw new BindingException("Error in binding file " + location + "\nThe usage of the attribute @readonly has been deprecated in favour of @direction.");
            }
            if (DomHelper.getAttributeAsBoolean(bindingElm, "read-only", false)) {
                throw new BindingException("Error in binding file " + location + "\nThe usage of the attribute @read-only has been deprecated in favour of @direction.");
            }
            String direction = DomHelper.getAttribute(bindingElm, "direction", "both");
            String leniency = DomHelper.getAttribute(bindingElm, "lenient", null);
            Map nsDeclarationMap = DomHelper.getInheritedNSDeclarations(bindingElm);
            if (nsDeclarationMap != null && nsDeclarationMap.values().contains(null)) {
                throw new BindingException("Error in binding file " + location + "\nBinding doesn't support having namespace-declarations without explicit prefixes.");
            }
            return new CommonAttributes(location, direction, leniency, nsDeclarationMap);
        }
        catch (BindingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BindingException("Error building binding defined at " + DomHelper.getLocation(bindingElm), e);
        }
    }

    protected static class CommonAttributes {
        final String location;
        final boolean loadEnabled;
        final boolean saveEnabled;
        final Boolean leniency;
        final Map nsDeclarations;
        static final CommonAttributes DEFAULT = new CommonAttributes("location unknown", true, true, null, null);

        CommonAttributes(String location, String direction, String leniency, Map nsDeclarations) {
            this(location, CommonAttributes.isLoadEnabled(direction), CommonAttributes.isSaveEnabled(direction), CommonAttributes.decideLeniency(leniency), nsDeclarations);
        }

        CommonAttributes(String location, boolean loadEnabled, boolean saveEnabled, Boolean leniency, Map nsDeclarations) {
            this.location = location;
            this.loadEnabled = loadEnabled;
            this.saveEnabled = saveEnabled;
            this.leniency = leniency;
            this.nsDeclarations = nsDeclarations;
        }

        private static boolean isLoadEnabled(String direction) {
            return "both".equals(direction) || "load".equals(direction);
        }

        private static boolean isSaveEnabled(String direction) {
            return "both".equals(direction) || "save".equals(direction);
        }

        private static Boolean decideLeniency(String leniency) {
            return BooleanUtils.toBooleanObject((String)leniency);
        }
    }
}

