/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.context.Context;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.components.flow.javascript.ScriptableMap;
import org.apache.cocoon.forms.binding.Binding;
import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.JXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBuilderBase;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.util.JavaScriptHelper;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public class JavaScriptJXPathBinding
extends JXPathBindingBase {
    private final Context avalonContext;
    private final String id;
    private final String path;
    private final Function loadScript;
    private final Function saveScript;
    private final Scriptable childBindings;
    static final String[] LOAD_PARAMS = new String[]{"widget", "jxpathPointer", "jxpathContext", "childBindings"};
    static final String[] SAVE_PARAMS = new String[]{"widget", "jxpathPointer", "jxpathContext", "childBindings"};

    public JavaScriptJXPathBinding(Context context, JXPathBindingBuilderBase.CommonAttributes commonAtts, String id, String path, Function loadScript, Function saveScript, Map childBindings) {
        super(commonAtts);
        this.id = id;
        this.path = path;
        this.loadScript = loadScript;
        this.saveScript = saveScript;
        this.avalonContext = context;
        Iterator iter = childBindings.values().iterator();
        while (iter.hasNext()) {
            ((Binding)iter.next()).setParent(this);
        }
        this.childBindings = new ScriptableMap(childBindings);
    }

    public void doLoad(Widget frmModel, JXPathContext jctx) {
        if (this.loadScript != null) {
            Widget widget = this.selectWidget(frmModel, this.id);
            Pointer pointer = jctx.getPointer(this.path);
            Map objectModel = ContextHelper.getObjectModel((Context)this.avalonContext);
            try {
                JXPathContext newCtx = pointer.getNode() == null ? null : jctx.getRelativeContext(pointer);
                JavaScriptHelper.callFunction(this.loadScript, frmModel, new Object[]{widget, pointer, newCtx, this.childBindings}, objectModel);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new CascadingRuntimeException("Error invoking JavaScript event handler", (Throwable)e);
            }
        } else if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("[Javascript Binding] - loadForm: No javascript code avaliable. Widget id=" + this.getId());
        }
    }

    public void doSave(Widget frmModel, JXPathContext jctx) throws BindingException {
        if (this.saveScript != null) {
            Widget widget = this.selectWidget(frmModel, this.id);
            Pointer pointer = jctx.createPath(this.path);
            JXPathContext widgetCtx = jctx.getRelativeContext(pointer);
            try {
                Map objectModel = ContextHelper.getObjectModel((Context)this.avalonContext);
                JavaScriptHelper.callFunction(this.saveScript, frmModel, new Object[]{widget, pointer, widgetCtx, this.childBindings}, objectModel);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new CascadingRuntimeException("Error invoking JavaScript event handler", (Throwable)e);
            }
        } else if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("[Javascript Binding] - saveForm: No code avaliable on the javascript binding with id \"" + this.getId() + "\"");
        }
    }
}

