/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import java.util.Collections;
import java.util.HashMap;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.ComposedJXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBuilderBase;
import org.apache.cocoon.forms.binding.JXPathBindingManager;
import org.apache.cocoon.forms.binding.JavaScriptJXPathBinding;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.cocoon.forms.util.JavaScriptHelper;
import org.mozilla.javascript.Function;
import org.w3c.dom.Element;

public class JavaScriptJXPathBindingBuilder
extends JXPathBindingBuilderBase
implements Contextualizable {
    private Context avalonContext;

    public void contextualize(Context context) throws ContextException {
        this.avalonContext = context;
    }

    public JXPathBindingBase buildBinding(Element element, JXPathBindingManager.Assistant assistant) throws BindingException {
        try {
            HashMap<String, ComposedJXPathBindingBase> childBindings;
            Element[] children;
            JXPathBindingBuilderBase.CommonAttributes commonAtts = JXPathBindingBuilderBase.getCommonAttributes(element);
            String id = DomHelper.getAttribute(element, "id");
            String path = DomHelper.getAttribute(element, "path");
            Function loadScript = null;
            if (commonAtts.loadEnabled) {
                Element loadElem = DomHelper.getChildElement(element, "http://apache.org/cocoon/forms/1.0#binding", "load-form");
                if (loadElem == null) {
                    throw new BindingException("Element \"load-form\" is missing (" + DomHelper.getLocation(element) + ")");
                }
                loadScript = JavaScriptHelper.buildFunction(loadElem, "loadForm", JavaScriptJXPathBinding.LOAD_PARAMS);
            }
            Function saveScript = null;
            if (commonAtts.saveEnabled) {
                Element saveElem = DomHelper.getChildElement(element, "http://apache.org/cocoon/forms/1.0#binding", "save-form");
                if (saveElem == null) {
                    throw new BindingException("Element \"save-form\" is missing (" + DomHelper.getLocation(element) + ")");
                }
                saveScript = JavaScriptHelper.buildFunction(saveElem, "saveForm", JavaScriptJXPathBinding.SAVE_PARAMS);
            }
            if ((children = DomHelper.getChildElements(element, "http://apache.org/cocoon/forms/1.0#binding", "child-binding")).length == 0) {
                childBindings = Collections.EMPTY_MAP;
            } else {
                childBindings = new HashMap<String, ComposedJXPathBindingBase>();
                for (int i = 0; i < children.length; ++i) {
                    Element child = children[i];
                    String name = DomHelper.getAttribute(child, "name");
                    if (childBindings.containsKey(name)) {
                        throw new BindingException("Duplicate name '" + name + "' at " + DomHelper.getLocation(child));
                    }
                    JXPathBindingBase[] bindings = assistant.makeChildBindings(child);
                    if (bindings == null) {
                        bindings = new JXPathBindingBase[]{};
                    }
                    ComposedJXPathBindingBase composedBinding = new ComposedJXPathBindingBase(commonAtts, bindings);
                    composedBinding.enableLogging(this.getLogger());
                    childBindings.put(name, composedBinding);
                }
            }
            JavaScriptJXPathBinding result = new JavaScriptJXPathBinding(this.avalonContext, commonAtts, id, path, loadScript, saveScript, Collections.unmodifiableMap(childBindings));
            result.enableLogging(this.getLogger());
            return result;
        }
        catch (BindingException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BindingException("Cannot build binding at " + DomHelper.getLocation(element), e);
        }
    }
}

