/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.forms.datatype.Datatype;
import org.apache.cocoon.forms.datatype.JavaSelectionList;
import org.apache.cocoon.forms.datatype.convertor.Convertor;
import org.apache.cocoon.forms.datatype.convertor.DefaultFormatCache;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.excalibur.xml.sax.XMLizable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractJavaSelectionList
implements JavaSelectionList,
Serviceable {
    protected Datatype datatype;
    protected ServiceManager manager;
    private HashMap attributes;
    private List items = new ArrayList();
    private boolean nullable;
    private boolean rebuild = true;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public String getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return (String)this.attributes.get(name);
    }

    public void removeAttribute(String name) {
        if (this.attributes != null) {
            this.attributes.remove(name);
        }
    }

    public void setAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(name, value);
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setDatatype(Datatype datatype) {
        this.datatype = datatype;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public void markForRebuild() {
        this.rebuild = true;
    }

    public void generateSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        if (this.rebuild) {
            try {
                this.items.clear();
                this.rebuild = this.build();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        DefaultFormatCache formatCache = new DefaultFormatCache();
        contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", "selection-list", "fi:selection-list", (Attributes)XMLUtils.EMPTY_ATTRIBUTES);
        if (this.nullable) {
            AttributesImpl voidAttrs = new AttributesImpl();
            voidAttrs.addCDATAAttribute("value", "");
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", "item", "fi:item", (Attributes)voidAttrs);
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", "item", "fi:item");
        }
        Iterator itemIt = this.items.iterator();
        while (itemIt.hasNext()) {
            SelectionListItem item = (SelectionListItem)itemIt.next();
            item.generateSaxFragment(contentHandler, locale, formatCache);
        }
        contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", "selection-list", "fi:selection-list");
    }

    protected abstract boolean build() throws Exception;

    protected void addItem(Object value, String label) {
        this.items.add(new SelectionListItem(value, label));
    }

    protected void addItem(Object value, XMLizable label) {
        this.items.add(new SelectionListItem(value, label));
    }

    protected List getItems() {
        return this.items;
    }

    private final class SelectionListItem {
        private final Object value;
        private final Object label;

        public SelectionListItem(Object value, String label) {
            this.value = value;
            this.label = label;
        }

        public SelectionListItem(Object value, XMLizable label) {
            this.value = value;
            this.label = label;
        }

        public Object getValue() {
            return this.value;
        }

        public void generateSaxFragment(ContentHandler contentHandler, Locale locale, Convertor.FormatCache formatCache) throws SAXException {
            String stringValue = this.value == null ? "" : AbstractJavaSelectionList.this.datatype.getConvertor().convertToString(this.value, locale, formatCache);
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("value", stringValue);
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", "item", "fi:item", (Attributes)attrs);
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", "label", "fi:label", (Attributes)XMLUtils.EMPTY_ATTRIBUTES);
            if (this.label == null) {
                contentHandler.characters(stringValue.toCharArray(), 0, stringValue.length());
            } else if (this.label instanceof XMLizable) {
                ((XMLizable)this.label).toSAX(contentHandler);
            } else {
                String stringLabel = (String)this.label;
                contentHandler.characters(stringLabel.toCharArray(), 0, stringLabel.length());
            }
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", "label", "fi:label");
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", "item", "fi:item");
        }
    }
}

