/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype;

import java.io.IOException;
import java.util.Locale;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.forms.datatype.Datatype;
import org.apache.cocoon.forms.datatype.SelectionList;
import org.apache.cocoon.forms.datatype.convertor.ConversionResult;
import org.apache.cocoon.forms.datatype.convertor.Convertor;
import org.apache.cocoon.forms.datatype.convertor.DefaultFormatCache;
import org.apache.cocoon.xml.AbstractXMLPipe;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.dom.DOMBuilder;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class DynamicSelectionList
implements SelectionList {
    private String src;
    private Datatype datatype;
    private ServiceManager serviceManager;

    public DynamicSelectionList(Datatype datatype, String src, ServiceManager serviceManager) {
        this.datatype = datatype;
        this.src = src;
        this.serviceManager = serviceManager;
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    void generateSaxFragment(ContentHandler contentHandler, Locale locale, Source source) throws ProcessingException, SAXException, IOException {
        SelectionListHandler handler = new SelectionListHandler(locale);
        handler.setContentHandler(contentHandler);
        SourceUtil.toSAX((ServiceManager)this.serviceManager, (Source)source, null, (ContentHandler)((Object)handler));
    }

    /*
     * Loose catch block
     */
    public void generateSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        block9: {
            Source source;
            SourceResolver sourceResolver;
            block10: {
                sourceResolver = null;
                source = null;
                sourceResolver = (SourceResolver)this.serviceManager.lookup(SourceResolver.ROLE);
                source = sourceResolver.resolveURI(this.src);
                this.generateSaxFragment(contentHandler, locale, source);
                Object var7_5 = null;
                if (sourceResolver == null) break block9;
                if (source == null) break block10;
                try {
                    sourceResolver.release(source);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.serviceManager.release((Object)sourceResolver);
            {
                break block9;
                catch (Exception e) {
                    throw new SAXException("Error while generating selection list: " + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (sourceResolver != null) {
                    if (source != null) {
                        try {
                            sourceResolver.release(source);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    this.serviceManager.release((Object)sourceResolver);
                }
                throw throwable;
            }
        }
    }

    public class SelectionListHandler
    extends AbstractXMLPipe {
        private Object currentValue;
        private String currentValueAsString;
        private boolean hasLabel;
        private Locale locale;
        private Convertor convertor;
        private DOMBuilder convertorConfigDOMBuilder;
        private int convertorConfigNestingLevel = 0;
        private Convertor.FormatCache fromFormatCache = new DefaultFormatCache();
        private Convertor.FormatCache toFormatCache = new DefaultFormatCache();
        private static final String LABEL_EL = "label";

        public SelectionListHandler(Locale locale) {
            this.locale = locale;
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void endDTD() throws SAXException {
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.convertorConfigNestingLevel > 0) {
                ++this.convertorConfigNestingLevel;
                this.convertorConfigDOMBuilder.startElement(namespaceURI, localName, qName, attributes);
            } else if (namespaceURI.equals("http://apache.org/cocoon/forms/1.0#definition")) {
                if (localName.equals("item")) {
                    if (this.convertor == null) {
                        this.convertor = DynamicSelectionList.this.datatype.getConvertor();
                    }
                    this.hasLabel = false;
                    String unparsedValue = attributes.getValue("value");
                    if (unparsedValue == null || "".equals(unparsedValue)) {
                        this.currentValueAsString = "";
                    } else {
                        ConversionResult conversionResult = this.convertor.convertFromString(unparsedValue, this.locale, this.fromFormatCache);
                        if (!conversionResult.isSuccessful()) {
                            throw new SAXException("Could not interpret the following value: \"" + unparsedValue + "\".");
                        }
                        this.currentValue = conversionResult.getResult();
                        this.currentValueAsString = DynamicSelectionList.this.datatype.getConvertor().convertToString(this.currentValue, this.locale, this.toFormatCache);
                    }
                    AttributesImpl attrs = new AttributesImpl();
                    attrs.addCDATAAttribute("value", this.currentValueAsString);
                    super.startElement("http://apache.org/cocoon/forms/1.0#instance", localName, "fi:" + localName, (Attributes)attrs);
                } else if (localName.equals(LABEL_EL)) {
                    this.hasLabel = true;
                    super.startElement("http://apache.org/cocoon/forms/1.0#instance", localName, "fi:" + localName, attributes);
                } else if (localName.equals("selection-list")) {
                    super.startElement("http://apache.org/cocoon/forms/1.0#instance", localName, "fi:" + localName, attributes);
                } else if (this.convertor == null && localName.equals("convertor")) {
                    this.convertorConfigDOMBuilder = new DOMBuilder();
                    this.convertorConfigDOMBuilder.startElement(namespaceURI, localName, qName, attributes);
                    ++this.convertorConfigNestingLevel;
                } else {
                    super.startElement(namespaceURI, localName, qName, attributes);
                }
            } else {
                super.startElement(namespaceURI, localName, qName, attributes);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this.convertorConfigNestingLevel > 0) {
                --this.convertorConfigNestingLevel;
                this.convertorConfigDOMBuilder.endElement(namespaceURI, localName, qName);
                if (this.convertorConfigNestingLevel == 0) {
                    Element convertorElement = this.convertorConfigDOMBuilder.getDocument().getDocumentElement();
                    try {
                        this.convertor = DynamicSelectionList.this.datatype.getBuilder().buildConvertor(convertorElement);
                    }
                    catch (Exception e) {
                        throw new SAXException("Error building convertor from convertor configuration embedded in selection list XML.", e);
                    }
                }
            } else if (namespaceURI.equals("http://apache.org/cocoon/forms/1.0#definition")) {
                if (localName.equals("item")) {
                    if (!this.hasLabel) {
                        super.startElement("http://apache.org/cocoon/forms/1.0#instance", LABEL_EL, "fi:label", (Attributes)new AttributesImpl());
                        super.characters(this.currentValueAsString.toCharArray(), 0, this.currentValueAsString.length());
                        super.endElement("http://apache.org/cocoon/forms/1.0#instance", LABEL_EL, "fi:label");
                    }
                    super.endElement("http://apache.org/cocoon/forms/1.0#instance", localName, "fi:" + localName);
                } else if (localName.equals(LABEL_EL)) {
                    super.endElement("http://apache.org/cocoon/forms/1.0#instance", localName, "fi:" + localName);
                } else if (localName.equals("selection-list")) {
                    super.endElement("http://apache.org/cocoon/forms/1.0#instance", localName, "fi:" + localName);
                } else {
                    super.endElement(namespaceURI, localName, qName);
                }
            } else {
                super.endElement(namespaceURI, localName, qName);
            }
        }

        public void comment(char[] ch, int start, int len) throws SAXException {
            if (this.convertorConfigNestingLevel > 0) {
                this.convertorConfigDOMBuilder.comment(ch, start, len);
            } else {
                super.comment(ch, start, len);
            }
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (this.convertorConfigNestingLevel > 0) {
                this.convertorConfigDOMBuilder.startPrefixMapping(prefix, uri);
            } else {
                super.startPrefixMapping(prefix, uri);
            }
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            if (this.convertorConfigNestingLevel > 0) {
                this.convertorConfigDOMBuilder.endPrefixMapping(prefix);
            } else {
                super.endPrefixMapping(prefix);
            }
        }

        public void characters(char[] c, int start, int len) throws SAXException {
            if (this.convertorConfigNestingLevel > 0) {
                this.convertorConfigDOMBuilder.characters(c, start, len);
            } else {
                super.characters(c, start, len);
            }
        }

        public void ignorableWhitespace(char[] c, int start, int len) throws SAXException {
            if (this.convertorConfigNestingLevel > 0) {
                this.convertorConfigDOMBuilder.ignorableWhitespace(c, start, len);
            } else {
                super.ignorableWhitespace(c, start, len);
            }
        }

        public void processingInstruction(String target, String data) throws SAXException {
            if (this.convertorConfigNestingLevel > 0) {
                this.convertorConfigDOMBuilder.processingInstruction(target, data);
            } else {
                super.processingInstruction(target, data);
            }
        }

        public void skippedEntity(String name) throws SAXException {
            if (this.convertorConfigNestingLevel > 0) {
                this.convertorConfigDOMBuilder.skippedEntity(name);
            } else {
                super.skippedEntity(name);
            }
        }

        public void startEntity(String name) throws SAXException {
            if (this.convertorConfigNestingLevel > 0) {
                this.convertorConfigDOMBuilder.startEntity(name);
            } else {
                super.startEntity(name);
            }
        }

        public void endEntity(String name) throws SAXException {
            if (this.convertorConfigNestingLevel > 0) {
                this.convertorConfigDOMBuilder.endEntity(name);
            } else {
                super.endEntity(name);
            }
        }

        public void startCDATA() throws SAXException {
            if (this.convertorConfigNestingLevel > 0) {
                this.convertorConfigDOMBuilder.startCDATA();
            } else {
                super.startCDATA();
            }
        }

        public void endCDATA() throws SAXException {
            if (this.convertorConfigNestingLevel > 0) {
                this.convertorConfigDOMBuilder.endCDATA();
            } else {
                super.endCDATA();
            }
        }
    }
}

