/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Locale;
import org.apache.cocoon.forms.datatype.Datatype;
import org.apache.cocoon.forms.datatype.SelectionList;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class EnumSelectionList
implements SelectionList {
    public static final String I18N_NS = "http://apache.org/cocoon/i18n/2.1";
    public static final String I18N_PREFIX_COLON = "i18n:";
    public static final String TEXT_EL = "text";
    private Datatype datatype;
    private Class clazz;
    private boolean nullable;

    public EnumSelectionList(String className, Datatype datatype, boolean nullable) throws ClassNotFoundException {
        this.datatype = datatype;
        this.nullable = nullable;
        this.clazz = Class.forName(className);
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public void generateSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        try {
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", "selection-list", "fi:selection-list", (Attributes)XMLUtils.EMPTY_ATTRIBUTES);
            Field[] fields = this.clazz.getDeclaredFields();
            if (this.nullable) {
                AttributesImpl voidAttrs = new AttributesImpl();
                voidAttrs.addCDATAAttribute("value", "");
                contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", "item", "fi:item", (Attributes)voidAttrs);
                contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", "item", "fi:item");
            }
            for (int i = 0; i < fields.length; ++i) {
                int mods = fields[i].getModifiers();
                if (!Modifier.isPublic(mods) || !Modifier.isStatic(mods) || !Modifier.isFinal(mods) || !fields[i].get(null).getClass().equals(this.clazz)) continue;
                String stringValue = this.clazz.getName() + "." + fields[i].getName();
                AttributesImpl itemAttrs = new AttributesImpl();
                itemAttrs.addCDATAAttribute("value", stringValue);
                contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", "item", "fi:item", (Attributes)itemAttrs);
                contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", "label", "fi:label", (Attributes)XMLUtils.EMPTY_ATTRIBUTES);
                contentHandler.startElement(I18N_NS, TEXT_EL, "i18n:text", (Attributes)XMLUtils.EMPTY_ATTRIBUTES);
                contentHandler.characters(stringValue.toCharArray(), 0, stringValue.length());
                contentHandler.endElement(I18N_NS, TEXT_EL, "i18n:text");
                contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", "label", "fi:label");
                contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", "item", "fi:item");
            }
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", "selection-list", "fi:selection-list");
        }
        catch (Exception e) {
            throw new SAXException("Got exception trying to get enum's values", e);
        }
    }
}

