/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype;

import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.LifecycleHelper;
import org.apache.cocoon.forms.datatype.Datatype;
import org.apache.cocoon.forms.datatype.JavaSelectionList;
import org.apache.cocoon.forms.datatype.SelectionList;
import org.apache.cocoon.forms.datatype.SelectionListBuilder;
import org.apache.cocoon.forms.datatype.StaticSelectionList;
import org.apache.cocoon.forms.util.DomHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class JavaSelectionListBuilder
extends AbstractLogEnabled
implements SelectionListBuilder,
Contextualizable,
Serviceable,
ThreadSafe,
Component {
    private Context context;
    private ServiceManager manager;

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public SelectionList build(Element selectionListElement, Datatype datatype) throws Exception {
        String className = DomHelper.getAttribute(selectionListElement, "class");
        boolean nullable = DomHelper.getAttributeAsBoolean(selectionListElement, "nullable", true);
        try {
            Class<?> clasz = Class.forName(className);
            if (JavaSelectionList.class.isAssignableFrom(clasz)) {
                JavaSelectionList list = (JavaSelectionList)clasz.newInstance();
                LifecycleHelper.setupComponent((Object)list, (Logger)this.getLogger(), (Context)this.context, (ServiceManager)this.manager, null, (boolean)true);
                list.setDatatype(datatype);
                list.setNullable(nullable);
                NamedNodeMap attrs = selectionListElement.getAttributes();
                int size = attrs.getLength();
                for (int i = 0; i < size; ++i) {
                    Node attr = attrs.item(i);
                    String name = attr.getNodeName();
                    list.setAttribute(name, attr.getNodeValue());
                }
                return list;
            }
            this.getLogger().warn("Class " + className + " does not implement JavaSelectionList, returning empty selection list.");
            return new StaticSelectionList(datatype);
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Got exception in build, re-throwing", (Throwable)e);
            }
            throw e;
        }
    }
}

