/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.flow.javascript;

import org.apache.cocoon.forms.formmodel.AggregateField;
import org.apache.cocoon.forms.formmodel.BooleanField;
import org.apache.cocoon.forms.formmodel.Field;
import org.apache.cocoon.forms.formmodel.MultiValueField;
import org.apache.cocoon.forms.formmodel.Output;
import org.apache.cocoon.forms.formmodel.Repeater;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.formmodel.WidgetState;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class ScriptableWidget
extends ScriptableObject {
    Widget delegate;

    public String getClassName() {
        return "Widget";
    }

    public ScriptableWidget() {
    }

    public ScriptableWidget(Object widget) {
        this.delegate = (Widget)this.unwrap(widget);
    }

    private Object unwrap(Object obj) {
        if (obj == Undefined.instance) {
            return null;
        }
        if (obj instanceof Wrapper) {
            return ((Wrapper)obj).unwrap();
        }
        return obj;
    }

    private ScriptableWidget wrap(Widget w) {
        ScriptableWidget result = new ScriptableWidget(w);
        result.setPrototype(ScriptableWidget.getClassPrototype((Scriptable)this, (String)"Widget"));
        result.setParentScope(this.getParentScope());
        return result;
    }

    public boolean has(String id, Scriptable start) {
        Widget sub;
        if (this.delegate instanceof Repeater ? id.equals("length") : (this.delegate instanceof MultiValueField ? id.equals("length") : this.delegate != null && (sub = this.delegate.lookupWidget(id)) != null)) {
            return true;
        }
        return super.has(id, start);
    }

    public boolean has(int index, Scriptable start) {
        if (this.delegate instanceof Repeater) {
            Repeater repeater = (Repeater)this.delegate;
            return index >= 0 && index < repeater.getSize();
        }
        if (this.delegate instanceof MultiValueField) {
            Object[] values = (Object[])this.delegate.getValue();
            return index >= 0 && index < values.length;
        }
        return super.has(index, start);
    }

    public Object get(String id, Scriptable start) {
        Widget sub;
        if (this.delegate instanceof Repeater) {
            if (id.equals("length")) {
                Repeater repeater = (Repeater)this.delegate;
                return new Integer(repeater.getSize());
            }
        } else if (this.delegate instanceof MultiValueField) {
            if (id.equals("length")) {
                Object[] values = (Object[])this.delegate.getValue();
                return new Integer(values.length);
            }
        } else if (this.delegate != null && (sub = this.delegate.lookupWidget(id)) != null) {
            if (sub instanceof Field || sub instanceof BooleanField || sub instanceof AggregateField || sub instanceof Output) {
                return sub.getValue();
            }
            return this.wrap(sub);
        }
        return super.get(id, start);
    }

    public Object get(int index, Scriptable start) {
        if (this.delegate instanceof Repeater) {
            Repeater repeater = (Repeater)this.delegate;
            if (index >= 0) {
                while (index >= repeater.getSize()) {
                    repeater.addRow();
                }
                return this.wrap(repeater.getRow(index));
            }
        }
        if (this.delegate instanceof MultiValueField) {
            Object[] values = (Object[])this.delegate.getValue();
            if (index >= 0 && index < values.length) {
                return values[index];
            }
            return NOT_FOUND;
        }
        return super.get(index, start);
    }

    public void delete(String id) {
        super.delete(id);
    }

    public void delete(int index) {
        if (this.delegate instanceof Repeater) {
            Repeater repeater = (Repeater)this.delegate;
            if (index >= 0 && index < repeater.getSize()) {
                repeater.removeRow(index);
                return;
            }
        } else if (this.delegate instanceof MultiValueField) {
            MultiValueField field = (MultiValueField)this.delegate;
            Object[] values = (Object[])field.getValue();
            if (values != null && values.length > index) {
                int i;
                Object[] newValues = new Object[values.length - 1];
                for (i = 0; i < index; ++i) {
                    newValues[i] = values[i];
                }
                ++i;
                while (i < values.length) {
                    newValues[i - 1] = values[i];
                    ++i;
                }
                field.setValues(newValues);
            }
            return;
        }
        super.delete(index);
    }

    public void put(String id, Scriptable start, Object value) {
        if (this.delegate instanceof Repeater) {
            if (id.equals("length")) {
                int len = (int)Context.toNumber((Object)value);
                Repeater repeater = (Repeater)this.delegate;
                int size = repeater.getSize();
                if (size > len) {
                    while (repeater.getSize() > len) {
                        repeater.removeRow(repeater.getSize() - 1);
                    }
                } else {
                    for (int i = size; i < len; ++i) {
                        repeater.addRow();
                    }
                }
            }
        } else if (this.delegate != null) {
            Widget sub = this.delegate.lookupWidget(id);
            if (sub instanceof Field) {
                Field field = (Field)sub;
                if ((value = this.unwrap(value)) instanceof Double) {
                    Class typeClass = field.getFieldDefinition().getDatatype().getTypeClass();
                    if (typeClass == Long.TYPE || typeClass == Long.class) {
                        value = new Long(((Number)value).longValue());
                    } else if (typeClass == Integer.TYPE || typeClass == Integer.class) {
                        value = new Integer(((Number)value).intValue());
                    } else if (typeClass == Float.TYPE || typeClass == Float.class) {
                        value = new Float(((Number)value).floatValue());
                    } else if (typeClass == Short.TYPE || typeClass == Short.class) {
                        value = new Short(((Number)value).shortValue());
                    }
                }
                field.setValue(value);
                return;
            }
            if (sub instanceof BooleanField) {
                BooleanField field = (BooleanField)sub;
                value = this.unwrap(value);
                field.setValue(value);
            } else if (sub instanceof Output) {
                Output field = (Output)sub;
                value = this.unwrap(value);
                field.setValue(value);
            } else if (sub instanceof Repeater) {
                Repeater repeater = (Repeater)sub;
                if (value instanceof NativeArray) {
                    int i;
                    NativeArray arr = (NativeArray)value;
                    Object length = ScriptableWidget.getProperty((Scriptable)arr, (String)"length");
                    int len = ((Number)length).intValue();
                    for (i = repeater.getSize(); i >= len; --i) {
                        repeater.removeRow(i);
                    }
                    for (i = 0; i < len; ++i) {
                        Object elemValue = ScriptableWidget.getProperty((Scriptable)arr, (int)i);
                        if (!(elemValue instanceof Scriptable)) continue;
                        Scriptable s = (Scriptable)elemValue;
                        Object[] ids = s.getIds();
                        ScriptableWidget wid = this.wrap(repeater.getRow(i));
                        for (int j = 0; j < ids.length; ++j) {
                            String idStr = ids[j].toString();
                            wid.put(idStr, (Scriptable)wid, ScriptableWidget.getProperty((Scriptable)s, (String)idStr));
                        }
                    }
                    return;
                }
            } else if (sub instanceof MultiValueField) {
                MultiValueField field = (MultiValueField)sub;
                Object[] values = null;
                if (value instanceof NativeArray) {
                    NativeArray arr = (NativeArray)value;
                    Object length = ScriptableWidget.getProperty((Scriptable)arr, (String)"length");
                    int len = ((Number)length).intValue();
                    values = new Object[len];
                    for (int i = 0; i < len; ++i) {
                        Object elemValue = ScriptableWidget.getProperty((Scriptable)arr, (int)i);
                        values[i] = this.unwrap(elemValue);
                    }
                } else if (value instanceof Object[]) {
                    values = (Object[])value;
                }
                field.setValues(values);
            } else if (value instanceof Scriptable) {
                Scriptable s = (Scriptable)value;
                Object[] ids = s.getIds();
                ScriptableWidget wid = this.wrap(sub);
                for (int j = 0; j < ids.length; ++j) {
                    String idStr = ids[j].toString();
                    wid.put(idStr, (Scriptable)wid, ScriptableWidget.getProperty((Scriptable)s, (String)idStr));
                }
                return;
            }
        }
        super.put(id, start, value);
    }

    public String jsGet_id() {
        return this.delegate.getId();
    }

    public WidgetState jsGet_state() {
        return this.delegate.getState();
    }

    public void jsSet_state(Object stateObj) {
        Object obj = this.unwrap(stateObj);
        WidgetState state = null;
        if (obj instanceof String) {
            state = WidgetState.stateForName((String)obj);
        } else if (obj instanceof WidgetState) {
            state = (WidgetState)((Object)obj);
        }
        if (state == null) {
            throw new IllegalArgumentException("Invalid value for widgetState " + stateObj);
        }
        this.delegate.setState(state);
    }

    public Object jsGet_parent() {
        if (this.delegate != null) {
            return this.wrap(this.delegate.getParent());
        }
        return Undefined.instance;
    }

    public boolean jsFunction_equals(Object other) {
        if (other instanceof ScriptableWidget) {
            ScriptableWidget otherWidget = (ScriptableWidget)((Object)other);
            return this.delegate.equals(otherWidget.delegate);
        }
        return false;
    }

    public void jsFunction_remove(int index) {
        this.delete(index);
    }
}

