/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.flow.javascript.v3;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.cocoon.forms.datatype.Datatype;
import org.apache.cocoon.forms.datatype.SelectionList;
import org.apache.cocoon.forms.event.ActionEvent;
import org.apache.cocoon.forms.event.ActionListener;
import org.apache.cocoon.forms.event.ActionListenerEnabled;
import org.apache.cocoon.forms.event.ValueChangedEvent;
import org.apache.cocoon.forms.event.ValueChangedListener;
import org.apache.cocoon.forms.event.ValueChangedListenerEnabled;
import org.apache.cocoon.forms.formmodel.AbstractWidget;
import org.apache.cocoon.forms.formmodel.Action;
import org.apache.cocoon.forms.formmodel.AggregateField;
import org.apache.cocoon.forms.formmodel.BooleanField;
import org.apache.cocoon.forms.formmodel.ContainerWidget;
import org.apache.cocoon.forms.formmodel.DataWidget;
import org.apache.cocoon.forms.formmodel.Field;
import org.apache.cocoon.forms.formmodel.Form;
import org.apache.cocoon.forms.formmodel.MultiValueField;
import org.apache.cocoon.forms.formmodel.Output;
import org.apache.cocoon.forms.formmodel.Repeater;
import org.apache.cocoon.forms.formmodel.SelectableWidget;
import org.apache.cocoon.forms.formmodel.Submit;
import org.apache.cocoon.forms.formmodel.Upload;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.formmodel.WidgetState;
import org.apache.cocoon.forms.validation.ValidationError;
import org.apache.cocoon.forms.validation.ValidationErrorAware;
import org.apache.cocoon.forms.validation.WidgetValidator;
import org.apache.commons.lang.BooleanUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class ScriptableWidget
extends ScriptableObject
implements ValueChangedListener,
ActionListener,
WidgetValidator {
    static final String WIDGETS_PROPERTY = "__widgets__";
    Widget delegate;
    ScriptableWidget formWidget;
    private Function onChange;
    private Function onActivate;
    private Function validator;
    static final Object[] WIDGET_CLASS_MAP = new Object[]{Form.class, "Form", Field.class, "Field", Action.class, "Action", Repeater.class, "Repeater", Repeater.RepeaterRow.class, "RepeaterRow", AggregateField.class, "AggregateField", BooleanField.class, "BooleanField", MultiValueField.class, "MultiValueField", Output.class, "Output", Submit.class, "Submit", Upload.class, "Upload"};

    public String getClassName() {
        return "Widget";
    }

    public ScriptableWidget() {
    }

    public ScriptableWidget(Object widget) {
        this.delegate = (Widget)ScriptableWidget.unwrap(widget);
        if (this.delegate instanceof Form) {
            this.formWidget = this;
            HashMap<Widget, ScriptableWidget> widgetMap = new HashMap<Widget, ScriptableWidget>();
            widgetMap.put(this.delegate, this);
            this.defineProperty(WIDGETS_PROPERTY, widgetMap, 6);
        }
    }

    private static Object unwrap(Object obj) {
        if (obj == Undefined.instance) {
            return null;
        }
        if (obj instanceof Wrapper) {
            return ((Wrapper)obj).unwrap();
        }
        return obj;
    }

    private void deleteWrapper(Widget w) {
        if (this.delegate instanceof Form) {
            Map widgetMap = (Map)super.get(WIDGETS_PROPERTY, (Scriptable)this);
            widgetMap.remove(w);
        }
    }

    private ScriptableWidget wrap(Widget w) {
        if (w == null) {
            return null;
        }
        if (this.delegate instanceof Form) {
            Map widgetMap = (Map)super.get(WIDGETS_PROPERTY, (Scriptable)this);
            ScriptableWidget result = null;
            result = (ScriptableWidget)widgetMap.get(w);
            if (result == null) {
                result = new ScriptableWidget(w);
                result.formWidget = this;
                result.setPrototype(ScriptableWidget.getClassPrototype((Scriptable)this, (String)this.getClassName()));
                result.setParentScope(this.getParentScope());
                widgetMap.put(w, result);
            }
            return result;
        }
        return this.formWidget.wrap(w);
    }

    public boolean has(String id, Scriptable start) {
        Widget sub;
        if (this.delegate != null && this.delegate instanceof ContainerWidget && (sub = ((ContainerWidget)this.delegate).getChild(id)) != null) {
            return true;
        }
        return super.has(id, start);
    }

    public boolean has(int index, Scriptable start) {
        if (super.has(index, start)) {
            return true;
        }
        if (this.delegate instanceof Repeater) {
            Repeater repeater = (Repeater)this.delegate;
            return index >= 0 && index < repeater.getSize();
        }
        if (this.delegate instanceof MultiValueField) {
            Object[] values = (Object[])this.delegate.getValue();
            return index >= 0 && index < values.length;
        }
        return false;
    }

    public Object get(String id, Scriptable start) {
        Widget sub;
        Object result = super.get(id, start);
        if (result != NOT_FOUND) {
            return result;
        }
        if (this.delegate != null && this.delegate instanceof ContainerWidget && (sub = ((ContainerWidget)this.delegate).getChild(id)) != null) {
            return this.wrap(sub);
        }
        return NOT_FOUND;
    }

    public Object get(int index, Scriptable start) {
        Object result = super.get(index, start);
        if (result != NOT_FOUND) {
            return result;
        }
        if (this.delegate instanceof Repeater) {
            Repeater repeater = (Repeater)this.delegate;
            if (index >= 0) {
                int count = index + 1 - repeater.getSize();
                if (count > 0) {
                    int i;
                    ScriptableWidget[] rows = new ScriptableWidget[count];
                    for (i = 0; i < count; ++i) {
                        rows[i] = this.wrap(repeater.addRow());
                    }
                    for (i = 0; i < count; ++i) {
                        rows[i].notifyAddRow();
                    }
                }
                return this.wrap(repeater.getRow(index));
            }
        } else if (this.delegate instanceof MultiValueField) {
            Object[] values = (Object[])this.delegate.getValue();
            if (index >= 0 && index < values.length) {
                return values[index];
            }
        }
        return NOT_FOUND;
    }

    public Object[] getAllIds() {
        Object[] result = super.getAllIds();
        return this.addWidgetIds(result);
    }

    public Object[] getIds() {
        Object[] result = super.getIds();
        return this.addWidgetIds(result);
    }

    private Object[] addWidgetIds(Object[] result) {
        if (this.delegate instanceof ContainerWidget) {
            Iterator iter = ((ContainerWidget)this.delegate).getChildren();
            LinkedList<Object> list = new LinkedList<Object>();
            for (int i = 0; i < result.length; ++i) {
                list.add(result[i]);
            }
            while (iter.hasNext()) {
                Widget widget = (Widget)iter.next();
                list.add(widget.getId());
            }
            result = list.toArray();
        }
        return result;
    }

    private void deleteRow(Repeater repeater, int index) {
        Repeater.RepeaterRow row = repeater.getRow(index);
        ScriptableWidget s = this.wrap(row);
        s.notifyRemoveRow();
        this.formWidget.deleteWrapper(row);
        repeater.removeRow(index);
    }

    private void notifyAddRow() {
        ScriptableWidget repeater = this.wrap(this.delegate.getParent());
        Object prop = ScriptableWidget.getProperty((Scriptable)repeater, (String)"onAddRow");
        if (prop instanceof Function) {
            try {
                Scriptable scope;
                Function fun = (Function)prop;
                Object[] args = new Object[1];
                Scriptable thisObj = scope = ScriptableWidget.getTopLevelScope((Scriptable)this);
                Context cx = Context.getCurrentContext();
                args[0] = this;
                fun.call(cx, scope, thisObj, args);
            }
            catch (Exception exc) {
                throw Context.reportRuntimeError((String)exc.getMessage());
            }
        }
    }

    private void notifyRemoveRow() {
        ScriptableWidget repeater = this.wrap(this.delegate.getParent());
        Object prop = ScriptableWidget.getProperty((Scriptable)repeater, (String)"onRemoveRow");
        if (prop instanceof Function) {
            try {
                Scriptable scope;
                Function fun = (Function)prop;
                Object[] args = new Object[1];
                Scriptable thisObj = scope = ScriptableWidget.getTopLevelScope((Scriptable)this);
                Context cx = Context.getCurrentContext();
                args[0] = this;
                fun.call(cx, scope, thisObj, args);
            }
            catch (Exception exc) {
                throw Context.reportRuntimeError((String)exc.getMessage());
            }
        }
    }

    public void delete(int index) {
        if (this.delegate instanceof Repeater) {
            Repeater repeater = (Repeater)this.delegate;
            if (index >= 0 && index < repeater.getSize()) {
                this.deleteRow(repeater, index);
                return;
            }
        } else if (this.delegate instanceof MultiValueField) {
            MultiValueField field = (MultiValueField)this.delegate;
            Object[] values = (Object[])field.getValue();
            if (values != null && values.length > index) {
                int i;
                Object[] newValues = new Object[values.length - 1];
                for (i = 0; i < index; ++i) {
                    newValues[i] = values[i];
                }
                ++i;
                while (i < values.length) {
                    newValues[i - 1] = values[i];
                    ++i;
                }
                field.setValues(newValues);
            }
            return;
        }
        super.delete(index);
    }

    public Object jsGet_value() {
        return this.delegate.getValue();
    }

    public Object jsFunction_getValue() {
        return this.jsGet_value();
    }

    public void jsFunction_setValue(Object value) throws JavaScriptException {
        this.jsSet_value(value);
    }

    public void jsSet_length(int len) {
        block4: {
            if (!(this.delegate instanceof Repeater)) break block4;
            Repeater repeater = (Repeater)this.delegate;
            int size = repeater.getSize();
            if (size > len) {
                while (repeater.getSize() > len) {
                    this.deleteRow(repeater, repeater.getSize() - 1);
                }
            } else {
                for (int i = size; i < len; ++i) {
                    this.wrap(repeater.addRow()).notifyAddRow();
                }
            }
        }
    }

    public Object jsGet_length() {
        if (this.delegate instanceof Repeater) {
            Repeater repeater = (Repeater)this.delegate;
            return new Integer(repeater.getSize());
        }
        return Undefined.instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void jsSet_value(Object value) throws JavaScriptException {
        AbstractWidget field;
        if (this.delegate instanceof AggregateField) {
            AggregateField aggregateField = (AggregateField)this.delegate;
            if (value instanceof Scriptable) {
                Scriptable obj = (Scriptable)value;
                Object[] ids = obj.getIds();
                for (int i = 0; i < ids.length; ++i) {
                    String id = String.valueOf(ids[i]);
                    Object val = ScriptableWidget.getProperty((Scriptable)obj, (String)id);
                    ScriptableWidget wid = this.wrap(aggregateField.getChild(id));
                    if (wid == null) {
                        throw new JavaScriptException((Object)("No field \"" + id + "\" in widget \"" + aggregateField.getId() + "\""));
                    }
                    if (wid.delegate instanceof Field || wid.delegate instanceof BooleanField || wid.delegate instanceof Output) {
                        Scriptable s;
                        if (!(val instanceof Scriptable) || !(s = (Scriptable)val).has("value", s)) continue;
                        wid.jsSet_value(s.get("value", s));
                        continue;
                    }
                    wid.jsSet_value(val);
                }
                aggregateField.combineFields();
                return;
            }
        }
        if (this.delegate instanceof DataWidget) {
            if ((value = ScriptableWidget.unwrap(value)) != null) {
                Datatype datatype = ((DataWidget)this.delegate).getDatatype();
                Class typeClass = datatype.getTypeClass();
                if (typeClass == String.class) {
                    value = Context.toString((Object)value);
                } else if (typeClass == Boolean.TYPE || typeClass == Boolean.class) {
                    value = Context.toBoolean((Object)value) ? Boolean.TRUE : Boolean.FALSE;
                } else if (value instanceof Double) {
                    if (typeClass == Long.TYPE || typeClass == Long.class) {
                        value = new Long(((Number)value).longValue());
                    } else if (typeClass == Integer.TYPE || typeClass == Integer.class) {
                        value = new Integer(((Number)value).intValue());
                    } else if (typeClass == Float.TYPE || typeClass == Float.class) {
                        value = new Float(((Number)value).floatValue());
                    } else if (typeClass == Short.TYPE || typeClass == Short.class) {
                        value = new Short(((Number)value).shortValue());
                    } else if (typeClass == BigDecimal.class) {
                        value = new BigDecimal(((Number)value).doubleValue());
                    }
                }
            }
            this.delegate.setValue(value);
            return;
        } else if (this.delegate instanceof BooleanField) {
            field = (BooleanField)this.delegate;
            ((BooleanField)field).setValue(BooleanUtils.toBooleanObject((boolean)Context.toBoolean((Object)value)));
            return;
        } else if (this.delegate instanceof Repeater) {
            int i;
            Repeater repeater = (Repeater)this.delegate;
            if (!(value instanceof NativeArray)) return;
            NativeArray arr = (NativeArray)value;
            Object length = ScriptableWidget.getProperty((Scriptable)arr, (String)"length");
            int len = ((Number)length).intValue();
            for (i = repeater.getSize(); i >= len; --i) {
                this.deleteRow(repeater, i);
            }
            for (i = 0; i < len; ++i) {
                Object elemValue = ScriptableWidget.getProperty((Scriptable)arr, (int)i);
                ScriptableWidget wid = this.wrap(repeater.getRow(i));
                wid.jsSet_value(elemValue);
            }
            return;
        } else if (this.delegate instanceof Repeater.RepeaterRow) {
            Repeater.RepeaterRow row = (Repeater.RepeaterRow)this.delegate;
            if (!(value instanceof Scriptable)) throw new JavaScriptException((Object)("Expected an object instead of: " + Context.toString((Object)value)));
            Scriptable obj = (Scriptable)value;
            Object[] ids = obj.getIds();
            for (int i = 0; i < ids.length; ++i) {
                String id = String.valueOf(ids[i]);
                Object val = ScriptableWidget.getProperty((Scriptable)obj, (String)id);
                ScriptableWidget wid = this.wrap(row.getChild(id));
                if (wid == null) {
                    throw new JavaScriptException((Object)("No field \"" + id + "\" in row " + i + " of repeater \"" + row.getParent().getId() + "\""));
                }
                if (wid.delegate instanceof Field || wid.delegate instanceof BooleanField || wid.delegate instanceof Output) {
                    Scriptable s;
                    if (!(val instanceof Scriptable) || !(s = (Scriptable)val).has("value", s)) continue;
                    wid.jsSet_value(s.get("value", s));
                    continue;
                }
                wid.jsSet_value(val);
            }
            return;
        } else if (this.delegate instanceof MultiValueField) {
            field = (MultiValueField)this.delegate;
            Object[] values = null;
            if (value instanceof NativeArray) {
                NativeArray arr = (NativeArray)value;
                Object length = ScriptableWidget.getProperty((Scriptable)arr, (String)"length");
                int len = ((Number)length).intValue();
                values = new Object[len];
                for (int i = 0; i < len; ++i) {
                    Object elemValue = ScriptableWidget.getProperty((Scriptable)arr, (int)i);
                    values[i] = ScriptableWidget.unwrap(elemValue);
                }
            } else if (value instanceof Object[]) {
                values = (Object[])value;
            }
            ((MultiValueField)field).setValues(values);
            return;
        } else {
            this.delegate.setValue(value);
        }
    }

    public String jsFunction_getId() {
        return this.delegate.getId();
    }

    public WidgetState jsGet_state() {
        return this.delegate.getState();
    }

    public void jsSet_state(Object stateObj) {
        Object obj = ScriptableWidget.unwrap(stateObj);
        WidgetState state = null;
        if (obj instanceof String) {
            state = WidgetState.stateForName((String)obj);
        } else if (obj instanceof WidgetState) {
            state = (WidgetState)((Object)obj);
        }
        if (state == null) {
            throw new IllegalArgumentException("Invalid value for widgetState " + stateObj);
        }
        this.delegate.setState(state);
    }

    public ScriptableWidget jsFunction_getSubmitWidget() {
        return this.wrap(this.delegate.getForm().getSubmitWidget());
    }

    public String jsFunction_getRequestParameterName() {
        return this.delegate.getRequestParameterName();
    }

    public Object jsFunction_getParent() {
        if (this.delegate != null) {
            return this.wrap(this.delegate.getParent());
        }
        return Undefined.instance;
    }

    public boolean jsFunction_isRequired() {
        return this.delegate.isRequired();
    }

    public ScriptableWidget jsFunction_getForm() {
        return this.formWidget;
    }

    public boolean jsFunction_equals(Object other) {
        if (other instanceof ScriptableWidget) {
            ScriptableWidget otherWidget = (ScriptableWidget)other;
            return this.delegate.equals(otherWidget.delegate);
        }
        return false;
    }

    public ScriptableWidget jsFunction_lookupWidget(String id) {
        Widget sub = null;
        sub = this.delegate.lookupWidget(id);
        return this.wrap(sub);
    }

    public void jsFunction_setValidationError(Object message, Object parameters) {
        if (this.delegate instanceof ValidationErrorAware) {
            String[] parms = null;
            if (parameters != null && parameters != Undefined.instance) {
                Scriptable obj = Context.toObject((Object)parameters, (Scriptable)this);
                int len = (int)Context.toNumber((Object)ScriptableWidget.getProperty((Scriptable)obj, (String)"length"));
                parms = new String[len];
                for (int i = 0; i < len; ++i) {
                    parms[i] = Context.toString((Object)ScriptableWidget.getProperty((Scriptable)obj, (int)i));
                }
            }
            ValidationError validationError = null;
            if (message != null) {
                validationError = parms != null && parms.length > 0 ? new ValidationError(Context.toString((Object)message), parms) : new ValidationError(Context.toString((Object)message), parms != null);
            }
            ((ValidationErrorAware)((Object)this.delegate)).setValidationError(validationError);
        }
    }

    public void jsFunction_setAttribute(String name, Object value) {
        this.delegate.setAttribute(name, value);
    }

    public Object jsFunction_getAttribute(String jsname) {
        return this.delegate.getAttribute(jsname);
    }

    public void jsFunction_removeAttribute(String name) {
        this.delegate.removeAttribute(name);
    }

    public Widget jsFunction_unwrap() {
        return this.delegate;
    }

    public ScriptableWidget jsFunction_addRow() {
        ScriptableWidget result = null;
        if (this.delegate instanceof Repeater) {
            result = this.wrap(((Repeater)this.delegate).addRow());
            result.notifyAddRow();
        }
        return result;
    }

    public ScriptableObject jsFunction_getRow(int index) {
        if (this.delegate instanceof Repeater) {
            return this.wrap(((Repeater)this.delegate).getRow(index));
        }
        return null;
    }

    public void jsFunction_removeRow(Object obj) throws JavaScriptException {
        if (this.delegate instanceof Repeater) {
            Repeater repeater = (Repeater)this.delegate;
            if (obj instanceof Function) {
                int i;
                Scriptable scope;
                Function fun = (Function)obj;
                int len = repeater.getSize();
                boolean[] index = new boolean[len];
                Object[] args = new Object[1];
                Scriptable thisObj = scope = ScriptableWidget.getTopLevelScope((Scriptable)this);
                Context cx = Context.getCurrentContext();
                for (i = 0; i < len; ++i) {
                    ScriptableWidget row = this.wrap(repeater.getRow(i));
                    args[0] = row;
                    Object result = fun.call(cx, scope, thisObj, args);
                    index[i] = Context.toBoolean((Object)result);
                }
                for (i = len - 1; i >= 0; --i) {
                    if (!index[i]) continue;
                    this.deleteRow(repeater, i);
                }
            } else {
                int index = (int)Context.toNumber((Object)obj);
                if (index >= 0 && index < repeater.getSize()) {
                    this.deleteRow(repeater, index);
                }
            }
        }
    }

    public Object jsGet_onChange() {
        if (this.onChange != null) {
            return this.onChange;
        }
        return Undefined.instance;
    }

    public Object jsGet_onActivate() {
        if (this.onActivate != null) {
            return this.onActivate;
        }
        return Undefined.instance;
    }

    public void jsSet_onChange(Object value) {
        if ((value = ScriptableWidget.unwrap(value)) == null) {
            this.onChange = null;
            if (this.delegate instanceof ValueChangedListenerEnabled) {
                ((ValueChangedListenerEnabled)((Object)this.delegate)).removeValueChangedListener(this);
            }
            return;
        }
        if (value instanceof Function && this.delegate instanceof ValueChangedListenerEnabled) {
            if (this.onChange == null) {
                ((ValueChangedListenerEnabled)((Object)this.delegate)).addValueChangedListener(this);
            }
            this.onChange = (Function)value;
        }
    }

    public void jsSet_onActivate(Object value) {
        if ((value = ScriptableWidget.unwrap(value)) == null) {
            this.onActivate = null;
            if (this.delegate instanceof ActionListenerEnabled) {
                ((ActionListenerEnabled)((Object)this.delegate)).removeActionListener(this);
            }
            return;
        }
        if (value instanceof Function && this.delegate instanceof ActionListenerEnabled) {
            if (this.onActivate == null) {
                ((ActionListenerEnabled)((Object)this.delegate)).addActionListener(this);
            }
            this.onActivate = (Function)value;
        }
    }

    public void valueChanged(ValueChangedEvent event) {
        if (this.onChange != null) {
            try {
                Scriptable scope;
                Object[] args = new Object[2];
                Scriptable thisObj = scope = ScriptableWidget.getTopLevelScope((Scriptable)this);
                Context cx = Context.getCurrentContext();
                args[0] = event.getOldValue();
                args[1] = event.getNewValue();
                this.onChange.call(cx, scope, thisObj, args);
            }
            catch (Exception exc) {
                throw Context.reportRuntimeError((String)exc.getMessage());
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (this.onActivate != null) {
            try {
                Scriptable scope;
                Object[] args = new Object[1];
                Scriptable thisObj = scope = ScriptableWidget.getTopLevelScope((Scriptable)this);
                Context cx = Context.getCurrentContext();
                args[0] = event.getActionCommand();
                this.onActivate.call(cx, scope, thisObj, args);
            }
            catch (Exception exc) {
                throw Context.reportRuntimeError((String)exc.getMessage());
            }
        }
    }

    public Object jsGet_validator() {
        if (this.validator != null) {
            return this.validator;
        }
        return Undefined.instance;
    }

    public void jsSet_validator(Object value) {
        if ((value = ScriptableWidget.unwrap(value)) == null) {
            this.validator = null;
            this.delegate.removeValidator(this);
            return;
        }
        if (value instanceof Function) {
            if (this.validator == null) {
                this.delegate.addValidator(this);
            }
            this.validator = (Function)value;
        }
    }

    public boolean validate(Widget widget) {
        try {
            Scriptable scope;
            Object[] args = new Object[1];
            Scriptable thisObj = scope = ScriptableWidget.getTopLevelScope((Scriptable)this);
            Context cx = Context.getCurrentContext();
            args[0] = this;
            Object result = this.validator.call(cx, scope, thisObj, args);
            return Context.toBoolean((Object)result);
        }
        catch (Exception exc) {
            throw Context.reportRuntimeError((String)exc.getMessage());
        }
    }

    public void jsFunction_setSelectionList(Object arg, Object valuePathArg, Object labelPathArg) throws Exception {
        if (this.delegate instanceof SelectableWidget) {
            arg = ScriptableWidget.unwrap(arg);
            if (valuePathArg != Undefined.instance && labelPathArg != Undefined.instance) {
                String valuePath = Context.toString((Object)valuePathArg);
                String labelPath = Context.toString((Object)labelPathArg);
                ((SelectableWidget)this.delegate).setSelectionList(arg, valuePath, labelPath);
            } else if (arg instanceof SelectionList) {
                SelectionList selectionList = (SelectionList)arg;
                ((SelectableWidget)this.delegate).setSelectionList(selectionList);
            } else {
                String str = Context.toString((Object)arg);
                ((SelectableWidget)this.delegate).setSelectionList(str);
            }
        }
    }

    public String jsFunction_getWidgetClass() {
        for (int i = 0; i < WIDGET_CLASS_MAP.length; i += 2) {
            Class c = (Class)WIDGET_CLASS_MAP[i];
            if (!c.isAssignableFrom(this.delegate.getClass())) continue;
            return (String)WIDGET_CLASS_MAP[i + 1];
        }
        return "<unknown>";
    }

    public String jsFunction_toString() {
        return "[object Widget (" + this.jsFunction_getWidgetClass() + ")]";
    }
}

