/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.Iterator;
import java.util.Locale;
import org.apache.cocoon.forms.FormContext;
import org.apache.cocoon.forms.formmodel.AbstractContainerDefinition;
import org.apache.cocoon.forms.formmodel.AbstractWidget;
import org.apache.cocoon.forms.formmodel.ContainerWidget;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.formmodel.WidgetList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractContainerWidget
extends AbstractWidget
implements ContainerWidget {
    protected WidgetList widgets = new WidgetList();

    public AbstractContainerWidget(AbstractContainerDefinition definition) {
        super(definition);
    }

    public void initialize() {
        Iterator it = this.getChildren();
        while (it.hasNext()) {
            ((Widget)it.next()).initialize();
        }
        super.initialize();
    }

    public void addChild(Widget widget) {
        this.widgets.addWidget(widget);
        widget.setParent(this);
    }

    public boolean hasChild(String id) {
        return this.widgets.hasWidget(id);
    }

    public Widget getChild(String id) {
        return this.widgets.getWidget(id);
    }

    public Iterator getChildren() {
        return this.widgets.iterator();
    }

    public void readFromRequest(FormContext formContext) {
        if (this.getCombinedState().isAcceptingInputs()) {
            this.widgets.readFromRequest(formContext);
        }
    }

    public boolean validate() {
        if (!this.getCombinedState().isValidatingValues()) {
            return true;
        }
        boolean valid = this.widgets.validate();
        return super.validate() && valid;
    }

    public void generateItemSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        if (this.getCombinedState().isDisplayingValues()) {
            this.widgets.generateSaxFragment(contentHandler, locale);
        }
    }
}

