/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import org.apache.cocoon.environment.Request;
import org.apache.cocoon.forms.FormContext;
import org.apache.cocoon.forms.event.ActionEvent;
import org.apache.cocoon.forms.event.ActionListener;
import org.apache.cocoon.forms.event.ActionListenerEnabled;
import org.apache.cocoon.forms.event.WidgetEvent;
import org.apache.cocoon.forms.event.WidgetEventMulticaster;
import org.apache.cocoon.forms.formmodel.AbstractWidget;
import org.apache.cocoon.forms.formmodel.ActionDefinition;
import org.apache.cocoon.forms.formmodel.Form;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;

public class Action
extends AbstractWidget
implements ActionListenerEnabled {
    private final ActionDefinition definition;
    private ActionListener listener;
    private static final String ACTION_EL = "action";

    public Action(ActionDefinition definition) {
        super(definition);
        this.definition = definition;
    }

    public WidgetDefinition getDefinition() {
        return this.definition;
    }

    public void readFromRequest(FormContext formContext) {
        if (!this.getCombinedState().isAcceptingInputs()) {
            return;
        }
        Form form = this.getForm();
        String fullId = this.getRequestParameterName();
        Request request = formContext.getRequest();
        String value = request.getParameter(fullId);
        if (value != null && value.length() > 0) {
            form.setSubmitWidget(this);
        } else {
            value = request.getParameter(fullId + ".x");
            if (value != null && value.length() > 0) {
                form.setSubmitWidget(this);
            }
        }
        if (form.getSubmitWidget() == this) {
            form.addWidgetEvent(new ActionEvent(this, this.definition.getActionCommand()));
            this.handleActivate();
        }
    }

    protected void handleActivate() {
        this.getForm().endProcessing(true);
    }

    public boolean validate() {
        return true;
    }

    public String getXMLElementName() {
        return ACTION_EL;
    }

    public void addActionListener(ActionListener listener) {
        this.listener = WidgetEventMulticaster.add(this.listener, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listener = WidgetEventMulticaster.remove(this.listener, listener);
    }

    private void fireActionEvent(ActionEvent event) {
        if (this.listener != null) {
            this.listener.actionPerformed(event);
        }
    }

    public void broadcastEvent(WidgetEvent event) {
        if (event instanceof ActionEvent) {
            this.definition.fireActionEvent((ActionEvent)event);
            this.fireActionEvent((ActionEvent)event);
        } else {
            super.broadcastEvent(event);
        }
    }
}

