/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.cocoon.forms.FormContext;
import org.apache.cocoon.forms.event.FormHandler;
import org.apache.cocoon.forms.event.ProcessingPhase;
import org.apache.cocoon.forms.event.ProcessingPhaseEvent;
import org.apache.cocoon.forms.event.ProcessingPhaseListener;
import org.apache.cocoon.forms.event.WidgetEvent;
import org.apache.cocoon.forms.event.WidgetEventMulticaster;
import org.apache.cocoon.forms.formmodel.AbstractContainerWidget;
import org.apache.cocoon.forms.formmodel.Action;
import org.apache.cocoon.forms.formmodel.FormDefinition;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.commons.collections.list.CursorableLinkedList;
import org.apache.commons.lang.BooleanUtils;

public class Form
extends AbstractContainerWidget {
    private final FormDefinition definition;
    private Boolean endProcessing;
    private Locale locale = Locale.getDefault();
    private FormHandler formHandler;
    private Widget submitWidget;
    private ProcessingPhase phase = ProcessingPhase.LOAD_MODEL;
    private boolean isValid = false;
    private ProcessingPhaseListener listener;
    private boolean bufferEvents = false;
    private CursorableLinkedList events;
    private static final String FORM_EL = "form";

    public Form(FormDefinition definition) {
        super(definition);
        this.definition = definition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        try {
            this.bufferEvents = true;
            super.initialize();
            this.fireEvents();
        }
        finally {
            this.bufferEvents = false;
        }
    }

    public WidgetDefinition getDefinition() {
        return this.definition;
    }

    public void addWidgetEvent(WidgetEvent event) {
        if (this.bufferEvents) {
            if (this.events == null) {
                this.events = new CursorableLinkedList();
            }
            this.events.add((Object)event);
        } else {
            event.getSourceWidget().broadcastEvent(event);
        }
    }

    private void fireEvents() {
        if (this.events != null) {
            CursorableLinkedList.Cursor cursor = this.events.cursor();
            while (cursor.hasNext()) {
                WidgetEvent event = (WidgetEvent)cursor.next();
                event.getSourceWidget().broadcastEvent(event);
                if (this.formHandler == null) continue;
                this.formHandler.handleEvent(event);
            }
            cursor.close();
            this.events.clear();
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Widget getSubmitWidget() {
        return this.submitWidget;
    }

    public void setSubmitWidget(Widget widget) {
        if (this.submitWidget != null && this.submitWidget != widget) {
            throw new IllegalStateException("SubmitWidget can only be set once.");
        }
        if (!(widget instanceof Action)) {
            this.endProcessing(true);
        }
        this.submitWidget = widget;
    }

    public void setFormHandler(FormHandler formHandler) {
        this.formHandler = formHandler;
    }

    public void addProcessingPhaseListener(ProcessingPhaseListener listener) {
        this.listener = WidgetEventMulticaster.add(this.listener, listener);
    }

    public void removeProcessingPhaseListener(ProcessingPhaseListener listener) {
        this.listener = WidgetEventMulticaster.remove(this.listener, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(FormContext formContext) {
        this.fireEvents();
        this.submitWidget = null;
        this.locale = formContext.getLocale();
        this.endProcessing = null;
        this.isValid = false;
        if (this.listener != null) {
            this.listener.phaseEnded(new ProcessingPhaseEvent(this, this.phase));
        }
        this.phase = ProcessingPhase.READ_FROM_REQUEST;
        this.submitWidget = null;
        String submitId = formContext.getRequest().getParameter("forms_submit_id");
        if (submitId != null && submitId.length() > 0) {
            if (this.getId() != null && !"".equals(this.getId())) {
                submitId = submitId.substring(submitId.indexOf(46) + 1);
            }
            StringTokenizer stok = new StringTokenizer(submitId, ".");
            Widget submit = this;
            while (stok.hasMoreTokens()) {
                if ((submit = submit.lookupWidget(stok.nextToken())) != null) continue;
                throw new IllegalArgumentException("Invalid submit id (no such widget): " + submitId);
            }
            this.setSubmitWidget(submit);
        }
        try {
            this.bufferEvents = true;
            this.doReadFromRequest(formContext);
            this.fireEvents();
        }
        finally {
            this.bufferEvents = false;
        }
        if (this.listener != null) {
            this.listener.phaseEnded(new ProcessingPhaseEvent(this, this.phase));
        }
        if (this.endProcessing != null) {
            return this.endProcessing;
        }
        return this.validate();
    }

    public void endProcessing(boolean redisplayForm) {
        this.endProcessing = BooleanUtils.toBooleanObject((!redisplayForm ? 1 : 0) != 0);
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void readFromRequest(FormContext formContext) {
        throw new UnsupportedOperationException("Please use Form.process()");
    }

    private void doReadFromRequest(FormContext formContext) {
        super.readFromRequest(formContext);
    }

    public boolean validate() {
        this.phase = ProcessingPhase.VALIDATE;
        this.isValid = super.validate();
        if (this.endProcessing != null) {
            return this.endProcessing;
        }
        if (this.listener != null) {
            this.listener.phaseEnded(new ProcessingPhaseEvent(this, this.phase));
        }
        if (this.endProcessing != null) {
            this.isValid = false;
            return this.endProcessing;
        }
        return this.isValid;
    }

    public String getXMLElementName() {
        return FORM_EL;
    }
}

