/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.cocoon.forms.FormContext;
import org.apache.cocoon.forms.event.WidgetEvent;
import org.apache.cocoon.forms.formmodel.AbstractContainerWidget;
import org.apache.cocoon.forms.formmodel.AbstractWidget;
import org.apache.cocoon.forms.formmodel.Form;
import org.apache.cocoon.forms.formmodel.RepeaterDefinition;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Repeater
extends AbstractWidget {
    private final RepeaterDefinition definition;
    private final List rows = new ArrayList();
    private static final String REPEATER_EL = "repeater";
    private static final String HEADINGS_EL = "headings";
    private static final String HEADING_EL = "heading";
    private static final String LABEL_EL = "label";
    private static final String REPEATER_SIZE_EL = "repeater-size";

    public Repeater(RepeaterDefinition repeaterDefinition) {
        super(repeaterDefinition);
        this.definition = repeaterDefinition;
        for (int i = 0; i < this.definition.getInitialSize(); ++i) {
            this.rows.add(new RepeaterRow(this.definition));
        }
    }

    public WidgetDefinition getDefinition() {
        return this.definition;
    }

    public void initialize() {
        for (int i = 0; i < this.rows.size(); ++i) {
            ((RepeaterRow)this.rows.get(i)).initialize();
        }
        super.initialize();
    }

    public int getSize() {
        return this.rows.size();
    }

    public RepeaterRow addRow() {
        RepeaterRow repeaterRow = new RepeaterRow(this.definition);
        this.rows.add(repeaterRow);
        repeaterRow.initialize();
        return repeaterRow;
    }

    public RepeaterRow addRow(int index) {
        RepeaterRow repeaterRow = new RepeaterRow(this.definition);
        if (index >= this.rows.size()) {
            this.rows.add(repeaterRow);
        } else {
            this.rows.add(index, repeaterRow);
        }
        repeaterRow.initialize();
        return repeaterRow;
    }

    public RepeaterRow getRow(int index) {
        return (RepeaterRow)this.rows.get(index);
    }

    public Widget getChild(String id) {
        int rowIndex = -1;
        try {
            rowIndex = Integer.parseInt(id);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (rowIndex < 0 || rowIndex >= this.getSize()) {
            return null;
        }
        return this.getRow(rowIndex);
    }

    public static RepeaterRow getParentRow(Widget widget) {
        Widget result;
        for (result = widget; result != null && !(result instanceof RepeaterRow); result = result.getParent()) {
        }
        if (result == null) {
            throw new RuntimeException("Could not find a parent row for widget " + widget);
        }
        return (RepeaterRow)result;
    }

    public int indexOf(RepeaterRow row) {
        return this.rows.indexOf(row);
    }

    public void removeRow(int index) {
        this.rows.remove(index);
    }

    public void moveRowLeft(int index) {
        if (index != 0 && index < this.rows.size()) {
            Object temp = this.rows.get(index - 1);
            this.rows.set(index - 1, this.rows.get(index));
            this.rows.set(index, temp);
        }
    }

    public void moveRowRight(int index) {
        if (index >= 0 && index < this.rows.size() - 1) {
            Object temp = this.rows.get(index + 1);
            this.rows.set(index + 1, this.rows.get(index));
            this.rows.set(index, temp);
        }
    }

    public void removeRows() {
        this.clear();
    }

    public void clear() {
        this.rows.clear();
        for (int i = 0; i < this.definition.getInitialSize(); ++i) {
            this.addRow();
        }
    }

    public Widget getWidget(int rowIndex, String id) {
        RepeaterRow row = (RepeaterRow)this.rows.get(rowIndex);
        return row.getChild(id);
    }

    public void readFromRequest(FormContext formContext) {
        if (!this.getCombinedState().isAcceptingInputs()) {
            return;
        }
        String sizeParameter = formContext.getRequest().getParameter(this.getRequestParameterName() + ".size");
        if (sizeParameter != null) {
            int i;
            int size = 0;
            try {
                size = Integer.parseInt(sizeParameter);
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
            if (size > 500) {
                throw new RuntimeException("Client is not allowed to specify a repeater size larger than 500.");
            }
            int currentSize = this.getSize();
            if (currentSize < size) {
                for (i = currentSize; i < size; ++i) {
                    this.addRow();
                }
            } else if (currentSize > size) {
                for (i = currentSize - 1; i >= size; --i) {
                    this.removeRow(i);
                }
            }
        }
        Iterator rowIt = this.rows.iterator();
        while (rowIt.hasNext()) {
            RepeaterRow row = (RepeaterRow)rowIt.next();
            row.readFromRequest(formContext);
        }
    }

    public boolean validate() {
        if (!this.getCombinedState().isValidatingValues()) {
            return true;
        }
        boolean valid = true;
        Iterator rowIt = this.rows.iterator();
        while (rowIt.hasNext()) {
            RepeaterRow row = (RepeaterRow)rowIt.next();
            valid &= row.validate();
        }
        return valid ? super.validate() : false;
    }

    public String getXMLElementName() {
        return REPEATER_EL;
    }

    public AttributesImpl getXMLElementAttributes() {
        AttributesImpl attrs = super.getXMLElementAttributes();
        attrs.addCDATAAttribute("size", String.valueOf(this.getSize()));
        return attrs;
    }

    public void generateDisplayData(ContentHandler contentHandler) throws SAXException {
        contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", LABEL_EL, "fi:label", (Attributes)XMLUtils.EMPTY_ATTRIBUTES);
        this.generateLabel(contentHandler);
        contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", LABEL_EL, "fi:label");
        contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", HEADINGS_EL, "fi:headings", (Attributes)XMLUtils.EMPTY_ATTRIBUTES);
        Iterator widgetDefinitionIt = this.definition.getWidgetDefinitions().iterator();
        while (widgetDefinitionIt.hasNext()) {
            WidgetDefinition widgetDefinition = (WidgetDefinition)widgetDefinitionIt.next();
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", HEADING_EL, "fi:heading", (Attributes)XMLUtils.EMPTY_ATTRIBUTES);
            widgetDefinition.generateLabel(contentHandler);
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", HEADING_EL, "fi:heading");
        }
        contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", HEADINGS_EL, "fi:headings");
    }

    public void generateItemSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        Iterator rowIt = this.rows.iterator();
        while (rowIt.hasNext()) {
            RepeaterRow row = (RepeaterRow)rowIt.next();
            row.generateSaxFragment(contentHandler, locale);
        }
    }

    public void generateWidgetLabel(String widgetId, ContentHandler contentHandler) throws SAXException {
        WidgetDefinition widgetDefinition = this.definition.getWidgetDefinition(widgetId);
        if (widgetDefinition == null) {
            throw new SAXException("Repeater \"" + this.getRequestParameterName() + "\" at " + this.getLocation() + " contains no widget with id \"" + widgetId + "\".");
        }
        widgetDefinition.generateLabel(contentHandler);
    }

    public void generateSize(ContentHandler contentHandler) throws SAXException {
        AttributesImpl attrs = this.getXMLElementAttributes();
        contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", REPEATER_SIZE_EL, "fi:repeater-size", (Attributes)attrs);
        contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", REPEATER_SIZE_EL, "fi:repeater-size");
    }

    public class RepeaterRow
    extends AbstractContainerWidget {
        private static final String ROW_EL = "repeater-row";

        public RepeaterRow(RepeaterDefinition definition) {
            super(definition);
            this.setParent(Repeater.this);
            definition.createWidgets(this);
        }

        public WidgetDefinition getDefinition() {
            return Repeater.this.definition;
        }

        public String getId() {
            return String.valueOf(Repeater.this.rows.indexOf(this));
        }

        public Form getForm() {
            return Repeater.this.getForm();
        }

        public void initialize() {
            Iterator it = this.getChildren();
            while (it.hasNext()) {
                ((Widget)it.next()).initialize();
            }
        }

        public boolean validate() {
            return this.widgets.validate();
        }

        public String getXMLElementName() {
            return ROW_EL;
        }

        public void generateLabel(ContentHandler contentHandler) throws SAXException {
        }

        public void generateDisplayData(ContentHandler contentHandler) throws SAXException {
        }

        public void broadcastEvent(WidgetEvent event) {
            throw new UnsupportedOperationException("Widget " + this.getRequestParameterName() + " doesn't handle events.");
        }
    }
}

