/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.SaxBuffer;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.apache.commons.lang.BooleanUtils;
import org.apache.excalibur.xml.EntityResolver;
import org.apache.excalibur.xml.sax.XMLizable;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom3.UserDataHandler;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;

public class DomHelper {
    public static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";

    public static String getLocation(Element element) {
        String location = null;
        if (element instanceof NodeImpl) {
            location = (String)((NodeImpl)element).getUserData("location");
        }
        if (location != null) {
            return location;
        }
        return "(location unknown)";
    }

    public static String getSystemIdLocation(Element element) {
        int start;
        int end;
        String loc = DomHelper.getLocation(element);
        if (loc.charAt(0) != '(' && (end = loc.lastIndexOf(58)) > 0 && (start = loc.lastIndexOf(58, end - 1)) >= 0) {
            return loc.substring(0, start);
        }
        return null;
    }

    public static int getLineLocation(Element element) {
        int start;
        int end;
        String loc = DomHelper.getLocation(element);
        if (loc.charAt(0) != '(' && (end = loc.lastIndexOf(58)) > 0 && (start = loc.lastIndexOf(58, end - 1)) >= 0) {
            return Integer.parseInt(loc.substring(start + 1, end));
        }
        return -1;
    }

    public static int getColumnLocation(Element element) {
        int end;
        String loc = DomHelper.getLocation(element);
        if (loc.charAt(0) != '(' && (end = loc.lastIndexOf(58)) > 0) {
            return Integer.parseInt(loc.substring(end));
        }
        return -1;
    }

    public static Element[] getChildElements(Element element, String namespace) {
        ArrayList<Node> elements = new ArrayList<Node>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !namespace.equals(node.getNamespaceURI())) continue;
            elements.add(node);
        }
        return elements.toArray(new Element[elements.size()]);
    }

    public static Element[] getChildElements(Element element, String namespace, String localName) {
        ArrayList<Node> elements = new ArrayList<Node>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !namespace.equals(node.getNamespaceURI()) || !localName.equals(node.getLocalName())) continue;
            elements.add(node);
        }
        return elements.toArray(new Element[elements.size()]);
    }

    public static Element getChildElement(Element element, String namespace, String localName) {
        Element node = null;
        try {
            node = DomHelper.getChildElement(element, namespace, localName, false);
        }
        catch (Exception e) {
            node = null;
        }
        return node;
    }

    public static Element getChildElement(Element element, String namespace, String localName, boolean required) throws Exception {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !namespace.equals(node.getNamespaceURI()) || !localName.equals(node.getLocalName())) continue;
            return (Element)node;
        }
        if (required) {
            throw new Exception("Missing element \"" + localName + "\" as child of element \"" + element.getTagName() + "\" at " + DomHelper.getLocation(element));
        }
        return null;
    }

    public static String getAttribute(Element element, String attributeName) throws Exception {
        String attrValue = element.getAttribute(attributeName);
        if (attrValue.equals("")) {
            throw new Exception("Missing attribute \"" + attributeName + "\" on element \"" + element.getTagName() + "\" at " + DomHelper.getLocation(element));
        }
        return attrValue;
    }

    public static String getAttribute(Element element, String attributeName, String defaultValue) throws Exception {
        String attrValue = element.getAttribute(attributeName);
        if (attrValue.equals("")) {
            return defaultValue;
        }
        return attrValue;
    }

    public static int getAttributeAsInteger(Element element, String attributeName) throws Exception {
        String attrValue = DomHelper.getAttribute(element, attributeName);
        try {
            return Integer.parseInt(attrValue);
        }
        catch (NumberFormatException e) {
            throw new Exception("Cannot parse the value \"" + attrValue + "\" as an integer in the attribute \"" + attributeName + "\" on the element \"" + element.getTagName() + "\" at " + DomHelper.getLocation(element));
        }
    }

    public static int getAttributeAsInteger(Element element, String attributeName, int defaultValue) throws Exception {
        String attrValue = element.getAttribute(attributeName);
        if (attrValue.equals("")) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(attrValue);
        }
        catch (NumberFormatException e) {
            throw new Exception("Cannot parse the value \"" + attrValue + "\" as an integer in the attribute \"" + attributeName + "\" on the element \"" + element.getTagName() + "\" at " + DomHelper.getLocation(element));
        }
    }

    public static boolean getAttributeAsBoolean(Element element, String attributeName, boolean defaultValue) {
        Boolean result;
        String attrValue = element.getAttribute(attributeName);
        try {
            result = BooleanUtils.toBooleanObject((String)attrValue, (String)"true", (String)"false", null);
        }
        catch (IllegalArgumentException iae) {
            result = null;
        }
        if (result != null) {
            return result;
        }
        try {
            result = BooleanUtils.toBooleanObject((String)attrValue, (String)"yes", (String)"no", null);
        }
        catch (IllegalArgumentException iae) {
            result = null;
        }
        if (result != null) {
            return result;
        }
        return defaultValue;
    }

    public static String getElementText(Element element) {
        StringBuffer value = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Text) && !(node instanceof CDATASection)) continue;
            value.append(node.getNodeValue());
        }
        return value.toString();
    }

    public static XMLizable compileElementContent(Element element) {
        SaxBuffer saxBuffer = new SaxBuffer();
        DOMStreamer domStreamer = new DOMStreamer();
        domStreamer.setContentHandler((ContentHandler)saxBuffer);
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            try {
                domStreamer.stream(childNodes.item(i));
                continue;
            }
            catch (SAXException e) {
                throw new RuntimeException("Error in DomHelper.compileElementContent: " + e.toString());
            }
        }
        return saxBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parse(InputSource inputSource, ServiceManager manager) throws SAXException, SAXNotSupportedException, IOException, ServiceException {
        LocationTrackingDOMParser domParser = new LocationTrackingDOMParser();
        domParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        domParser.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", false);
        EntityResolver resolver = null;
        if (manager.hasService(EntityResolver.ROLE)) {
            resolver = (EntityResolver)manager.lookup(EntityResolver.ROLE);
            domParser.setEntityResolver((org.xml.sax.EntityResolver)resolver);
        }
        try {
            domParser.parse(inputSource);
            Document document = domParser.getDocument();
            return document;
        }
        finally {
            manager.release((Object)resolver);
        }
    }

    public static Map getLocalNSDeclarations(Element elm) {
        return DomHelper.addLocalNSDeclarations(elm, null);
    }

    private static Map addLocalNSDeclarations(Element elm, Map nsDeclarations) {
        NamedNodeMap atts = elm.getAttributes();
        int attsSize = atts.getLength();
        for (int i = 0; i < attsSize; ++i) {
            Attr attr = (Attr)atts.item(i);
            if (!XMLNS_URI.equals(attr.getNamespaceURI())) continue;
            String nsUri = attr.getValue();
            String pfx = attr.getLocalName();
            if (nsDeclarations == null) {
                nsDeclarations = new HashMap<String, String>();
            }
            nsDeclarations.put(nsUri, pfx);
        }
        return nsDeclarations;
    }

    public static Map getInheritedNSDeclarations(Element elm) {
        LinkedList<Element> ancestorsAndSelf = new LinkedList<Element>();
        Element current = elm;
        while (current != null) {
            ancestorsAndSelf.add(current);
            Node parent = current.getParentNode();
            if (parent.getNodeType() == 1) {
                current = (Element)parent;
                continue;
            }
            current = null;
        }
        Map nsDeclarations = null;
        ListIterator iter = ancestorsAndSelf.listIterator(ancestorsAndSelf.size());
        while (iter.hasPrevious()) {
            Element element = (Element)iter.previous();
            nsDeclarations = DomHelper.addLocalNSDeclarations(element, nsDeclarations);
        }
        return nsDeclarations;
    }

    public static class LocationTrackingDOMParser
    extends DOMParser {
        XMLLocator locator;

        public void startDocument(XMLLocator xmlLocator, String s, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
            super.startDocument(xmlLocator, s, namespaceContext, augmentations);
            this.locator = xmlLocator;
            this.setLocation();
        }

        public void startElement(QName qName, XMLAttributes xmlAttributes, Augmentations augmentations) throws XNIException {
            super.startElement(qName, xmlAttributes, augmentations);
            this.setLocation();
        }

        private final void setLocation() {
            if (this.locator == null) {
                throw new RuntimeException("Error: locator is null. Check that you have the correct version of Xerces (such as the one that comes with Cocoon) in your endorsed library path.");
            }
            NodeImpl node = null;
            try {
                node = (NodeImpl)this.getProperty("http://apache.org/xml/properties/dom/current-element-node");
            }
            catch (SAXException ex) {
                System.err.println("except" + ex);
            }
            if (node != null) {
                String location = this.locator.getLiteralSystemId() + ":" + this.locator.getLineNumber() + ":" + this.locator.getColumnNumber();
                node.setUserData("location", (Object)location, (UserDataHandler)null);
            }
        }
    }
}

