/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.bean.query;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Vector;
import org.apache.cocoon.bean.query.SimpleLuceneCriterion;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class SimpleLuceneCriterionBean
implements SimpleLuceneCriterion,
Cloneable,
Serializable {
    protected Long id;
    protected String field;
    protected String match;
    protected String term;

    public SimpleLuceneCriterionBean() {
    }

    public SimpleLuceneCriterionBean(String field, String match, String term) {
        this.field = field;
        this.match = match;
        this.term = term;
    }

    public Object clone() throws CloneNotSupportedException {
        SimpleLuceneCriterionBean criterion = (SimpleLuceneCriterionBean)super.clone();
        return criterion;
    }

    public Query getQuery(Analyzer analyzer) {
        String f = this.field;
        BooleanQuery query = null;
        if ("any".equals(this.field)) {
            f = "body";
        }
        TokenStream tokens = analyzer.tokenStream(f, (Reader)new StringReader(this.term));
        Vector<String> words = new Vector<String>();
        while (true) {
            Token token;
            try {
                token = tokens.next();
            }
            catch (IOException e) {
                token = null;
            }
            if (token == null) break;
            words.addElement(token.termText());
        }
        try {
            tokens.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if ("any".equals(this.match)) {
            if (words.size() > 1) {
                query = new BooleanQuery();
                for (int i = 0; i < words.size(); ++i) {
                    query.add((Query)new TermQuery(new Term(f, (String)words.elementAt(i))), false, false);
                }
            } else if (words.size() == 1) {
                query = new TermQuery(new Term(f, (String)words.elementAt(0)));
            }
        }
        if ("all".equals(this.match)) {
            if (words.size() > 1) {
                query = new BooleanQuery();
                for (int i = 0; i < words.size(); ++i) {
                    query.add((Query)new TermQuery(new Term(f, (String)words.elementAt(i))), true, false);
                }
            } else if (words.size() == 1) {
                query = new TermQuery(new Term(f, (String)words.elementAt(0)));
            }
        }
        if ("not".equals(this.match)) {
            if (words.size() > 1) {
                query = new BooleanQuery();
                for (int i = 0; i < words.size(); ++i) {
                    query.add((Query)new TermQuery(new Term(f, (String)words.elementAt(i))), true, true);
                }
            } else if (words.size() == 1) {
                query = new TermQuery(new Term(f, (String)words.elementAt(0)));
            }
        }
        if ("like".equals(this.match)) {
            if (words.size() > 1) {
                query = new BooleanQuery();
                for (int i = 0; i < words.size(); ++i) {
                    query.add((Query)new FuzzyQuery(new Term(f, (String)words.elementAt(i))), false, false);
                }
            } else if (words.size() == 1) {
                query = new FuzzyQuery(new Term(f, (String)words.elementAt(0)));
            }
        }
        if ("phrase".equals(this.match)) {
            if (words.size() > 1) {
                query = new PhraseQuery();
                ((PhraseQuery)query).setSlop(0);
                for (int i = 0; i < words.size(); ++i) {
                    ((PhraseQuery)query).add(new Term(f, (String)words.elementAt(i)));
                }
            } else if (words.size() == 1) {
                query = new TermQuery(new Term(f, (String)words.elementAt(0)));
            }
        }
        return query;
    }

    public boolean isProhibited() {
        return "not".equals(this.match);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getMatch() {
        return this.match;
    }

    public void setMatch(String match) {
        this.match = match;
    }

    public String getTerm() {
        return this.term;
    }

    public void setTerm(String term) {
        this.term = term;
    }
}

