/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.bean.query;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.bean.query.SimpleLuceneCriterion;
import org.apache.cocoon.bean.query.SimpleLuceneCriterionBean;
import org.apache.cocoon.bean.query.SimpleLuceneQuery;
import org.apache.cocoon.components.search.LuceneCocoonSearcher;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Query;

public class SimpleLuceneQueryBean
implements SimpleLuceneQuery,
Cloneable,
Serializable {
    public static Long DEFAULT_PAGE_SIZE = new Long(20L);
    public static Long DEFAULT_PAGE = new Long(0L);
    public static String SCORE_FIELD = "_lucene-score_";
    public static String INDEX_FIELD = "_lucene-index_";
    private Date date;
    private List criteria;
    private Long id;
    private Long page;
    private Long size;
    private Long total;
    private String bool;
    private String name;
    private String type;
    private String user;

    public SimpleLuceneQueryBean() {
    }

    public SimpleLuceneQueryBean(String type, String bool, String match, String field, String query) {
        this.name = "My Query";
        this.type = type;
        this.bool = bool;
        this.size = DEFAULT_PAGE_SIZE;
        this.page = DEFAULT_PAGE;
        this.total = null;
        this.user = null;
        this.id = null;
        this.addCriterion(new SimpleLuceneCriterionBean(field, match, query));
    }

    public Object clone() throws CloneNotSupportedException {
        SimpleLuceneQueryBean query = (SimpleLuceneQueryBean)super.clone();
        query.setCriteria(new ArrayList(this.criteria.size()));
        Iterator it = this.getCriteria().iterator();
        while (it.hasNext()) {
            query.addCriterion((SimpleLuceneCriterionBean)((SimpleLuceneCriterionBean)it.next()).clone());
        }
        return query;
    }

    public List search(LuceneCocoonSearcher searcher) throws IOException, ProcessingException {
        BooleanQuery query = new BooleanQuery();
        Iterator it = this.criteria.iterator();
        boolean required = false;
        if ("and".equals(this.bool)) {
            required = true;
        }
        while (it.hasNext()) {
            SimpleLuceneCriterion criterion = (SimpleLuceneCriterion)it.next();
            Query subquery = criterion.getQuery(searcher.getAnalyzer());
            query.add(subquery, required, criterion.isProhibited());
        }
        Hits hits = searcher.search((Query)query);
        this.total = new Long(hits.length());
        this.date = new Date();
        return this.page(hits);
    }

    private List page(Hits hits) throws IOException {
        int end;
        ArrayList results = new ArrayList();
        int start = this.getPage().intValue() * this.getSize().intValue();
        if (start > this.total.intValue()) {
            start = this.total.intValue();
        }
        if ((end = start + this.getSize().intValue()) > this.total.intValue()) {
            end = this.total.intValue();
        }
        for (int i = start; i < end; ++i) {
            HashMap<String, Object> hit = new HashMap<String, Object>();
            hit.put(SCORE_FIELD, new Float(hits.score(i)));
            hit.put(INDEX_FIELD, new Long(i));
            Document doc = hits.doc(i);
            Enumeration e = doc.fields();
            while (e.hasMoreElements()) {
                Field field = (Field)e.nextElement();
                if (field.name().equals(SCORE_FIELD) || field.name().equals(INDEX_FIELD)) continue;
                hit.put(field.name(), field.stringValue());
            }
            results.add(hit);
        }
        return results;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getBool() {
        return this.bool;
    }

    public void setBool(String bool) {
        this.bool = bool;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Long getSize() {
        if (this.size == null) {
            return DEFAULT_PAGE_SIZE;
        }
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public Long getPage() {
        if (this.page == null) {
            return DEFAULT_PAGE;
        }
        return this.page;
    }

    public void setPage(Long page) {
        this.page = page;
    }

    public Long getTotal() {
        return this.total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public List getCriteria() {
        return this.criteria;
    }

    public void setCriteria(List criteria) {
        this.criteria = criteria;
    }

    public void addCriterion(SimpleLuceneCriterionBean criterion) {
        if (this.criteria == null) {
            this.criteria = new ArrayList();
        }
        this.criteria.add(criterion);
    }

    public void removeCriterion(SimpleLuceneCriterionBean criterion) {
        if (this.criteria != null) {
            this.criteria.remove(criterion);
        }
    }
}

