/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.AbstractDatabaseAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang.StringUtils;

public class DatabaseAddAction
extends AbstractDatabaseAction
implements ThreadSafe {
    protected static final Map addStatements = new HashMap();
    private static final Map selectStatements = new HashMap();

    /*
     * Loose catch block
     */
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters param) throws Exception {
        HashMap results;
        block17: {
            Connection conn;
            DataSourceComponent datasource;
            block16: {
                datasource = null;
                conn = null;
                results = new HashMap();
                boolean reloadable = true;
                if (this.settings.containsKey((Object)"reloadable")) {
                    reloadable = Boolean.valueOf((String)this.settings.get((Object)"reloadable"));
                }
                Configuration conf = this.getConfiguration(param.getParameter("descriptor", (String)this.settings.get((Object)"descriptor")), resolver, param.getParameterAsBoolean("reloadable", reloadable));
                datasource = this.getDataSource(conf);
                conn = datasource.getConnection();
                Request request = ObjectModelHelper.getRequest((Map)objectModel);
                if (conn.getAutoCommit()) {
                    conn.setAutoCommit(false);
                }
                Configuration[] tables = conf.getChildren("table");
                for (int i = 0; i < tables.length; ++i) {
                    Configuration table = tables[i];
                    this.processTable(table, conn, request, results);
                }
                conn.commit();
                Object var16_17 = null;
                if (conn == null) break block16;
                try {
                    conn.close();
                }
                catch (SQLException sqe) {
                    this.getLogger().warn("There was an error closing the datasource", (Throwable)sqe);
                }
            }
            if (datasource != null) {
                this.dbselector.release((Object)datasource);
            }
            break block17;
            {
                catch (Exception e) {
                    if (conn != null) {
                        try {
                            conn.rollback();
                        }
                        catch (SQLException se) {
                            this.getLogger().debug("There was an error rolling back the transaction", (Throwable)se);
                        }
                    }
                    throw new ProcessingException("Could not add record", (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var16_18 = null;
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException sqe) {
                        this.getLogger().warn("There was an error closing the datasource", (Throwable)sqe);
                    }
                }
                if (datasource != null) {
                    this.dbselector.release(datasource);
                }
                throw throwable;
            }
        }
        return Collections.unmodifiableMap(results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processTable(Configuration table, Connection conn, Request request, Map results) throws SQLException, ConfigurationException, Exception {
        Statement statement = null;
        try {
            int i;
            String query = this.getAddQuery(table);
            this.getLogger().debug("Add query: " + query);
            statement = conn.prepareStatement(query);
            Configuration[] keys = table.getChild("keys").getChildren("key");
            Configuration[] values = table.getChild("values").getChildren("value");
            int currentIndex = 1;
            boolean manyrows = false;
            int wildcardIndex = -1;
            String wildcardParam = null;
            for (i = 0; i < keys.length; ++i) {
                wildcardParam = keys[i].getAttribute("param");
                wildcardIndex = wildcardParam.indexOf(42);
                if (wildcardIndex == -1) continue;
                manyrows = true;
                break;
            }
            if (manyrows) {
                String prefix = wildcardParam.substring(0, wildcardIndex);
                String suffix = StringUtils.substring((String)wildcardParam, (int)(wildcardIndex + 1));
                Enumeration names = request.getParameterNames();
                TreeSet<String> matchset = new TreeSet<String>();
                int prefixLength = prefix.length();
                int length = prefixLength + suffix.length();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    if (!name.startsWith(prefix) || !name.endsWith(suffix)) continue;
                    String wildcard = StringUtils.mid((String)name, (int)prefixLength, (int)(name.length() - length));
                    matchset.add(wildcard);
                }
                int rowIndex = 1;
                Iterator iterator = matchset.iterator();
                while (iterator.hasNext()) {
                    String myparam;
                    int j;
                    String wildcard = (String)iterator.next();
                    currentIndex = 1;
                    for (j = 0; j < keys.length; ++j) {
                        myparam = this.getActualParam(keys[j].getAttribute("param"), wildcard);
                        currentIndex += this.setKey(table, keys[j], conn, (PreparedStatement)statement, currentIndex, request, myparam, results);
                    }
                    for (j = 0; j < values.length; ++j) {
                        myparam = this.getActualParam(values[j].getAttribute("param"), wildcard);
                        this.setColumn((PreparedStatement)statement, currentIndex, request, values[j], myparam, request.getParameter(myparam), rowIndex);
                        ++currentIndex;
                    }
                    statement.execute();
                    ++rowIndex;
                }
            } else {
                for (i = 0; i < keys.length; ++i) {
                    currentIndex += this.setKey(table, keys[i], conn, (PreparedStatement)statement, currentIndex, request, keys[i].getAttribute("param", ""), results);
                }
                i = 0;
                while (i < values.length) {
                    this.setColumn((PreparedStatement)statement, currentIndex, request, values[i]);
                    ++i;
                    ++currentIndex;
                }
                statement.execute();
            }
            Object var25_26 = null;
        }
        catch (Throwable throwable) {
            Object var25_27 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {}
    }

    int setKey(Configuration table, Configuration key, Connection conn, PreparedStatement statement, int currentIndex, Request request, String param, Map results) throws ConfigurationException, SQLException, Exception {
        String mode = key.getAttribute("mode", "automatic");
        String keyname = "key:" + table.getAttribute("name") + ':' + key.getAttribute("dbcol");
        if ("manual".equals(mode)) {
            String selectQuery = this.getSelectQuery(key);
            PreparedStatement select_statement = conn.prepareStatement(selectQuery);
            ResultSet set = select_statement.executeQuery();
            set.next();
            int value = set.getInt("maxid") + 1;
            statement.setInt(currentIndex, value);
            this.getLogger().debug("Manually setting key to " + value);
            this.setRequestAttribute(request, keyname, new Integer(value));
            results.put(key.getAttribute("dbcol"), String.valueOf(value));
            set.close();
            select_statement.close();
        } else if ("form".equals(mode)) {
            this.getLogger().debug("Setting key from form");
            this.setColumn(statement, currentIndex, request, key, param);
        } else if ("request-attribute".equals(mode)) {
            Integer value = (Integer)this.getRequestAttribute(request, key.getAttribute("request-attribute-name"));
            this.getLogger().debug("Setting key from request attribute " + value);
            statement.setInt(currentIndex, value);
        } else {
            this.getLogger().debug("Automatically setting key");
            return 0;
        }
        return 1;
    }

    String getActualParam(String param, String wildcard) {
        int index = param.indexOf(42);
        if (index != -1) {
            return param.substring(0, index) + wildcard + param.substring(index + 1);
        }
        return param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getAddQuery(Configuration table) throws ConfigurationException {
        String query = null;
        Map map = addStatements;
        synchronized (map) {
            query = (String)addStatements.get(table);
            if (query == null) {
                Configuration[] values = table.getChild("values").getChildren("value");
                Configuration[] keys = table.getChild("keys").getChildren("key");
                StringBuffer queryBuffer = new StringBuffer("INSERT INTO ");
                queryBuffer.append(table.getAttribute("name"));
                queryBuffer.append(" (");
                int numParams = 0;
                for (int i = 0; i < keys.length; ++i) {
                    String mode = keys[i].getAttribute("mode", "automatic");
                    if (!"manual".equals(mode) && !"form".equals(mode) && !"request-attribute".equals(mode)) continue;
                    if (numParams > 0) {
                        queryBuffer.append(", ");
                    }
                    queryBuffer.append(keys[i].getAttribute("dbcol"));
                    this.setSelectQuery(table.getAttribute("name"), keys[i]);
                    ++numParams;
                }
                queryBuffer.append(this.buildList(values, numParams));
                queryBuffer.append(") VALUES (");
                if ((numParams += values.length) > 0) {
                    queryBuffer.append("?");
                    queryBuffer.append(StringUtils.repeat((String)", ?", (int)(numParams - 1)));
                }
                queryBuffer.append(")");
                query = queryBuffer.toString();
                addStatements.put(table, query);
            }
        }
        return query;
    }

    protected final synchronized void setSelectQuery(String tableName, Configuration entry) throws ConfigurationException {
        StringBuffer queryBuffer = new StringBuffer("SELECT max(");
        queryBuffer.append(entry.getAttribute("dbcol"));
        queryBuffer.append(") AS maxid FROM ");
        queryBuffer.append(tableName);
        selectStatements.put(entry, queryBuffer.toString());
    }

    protected final synchronized String getSelectQuery(Configuration entry) throws ConfigurationException {
        return (String)selectStatements.get(entry);
    }
}

