/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.jdbc.OracleResultSet;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.DatabaseAddAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.util.ImageProperties;
import org.apache.cocoon.util.ImageUtils;

public class OraAddAction
extends DatabaseAddAction {
    private static final Map selectLOBStatements = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters param) throws Exception {
        block37: {
            int currentIndex;
            Connection conn;
            DataSourceComponent datasource;
            block36: {
                String parameter;
                int i;
                datasource = null;
                conn = null;
                currentIndex = 0;
                Configuration conf = this.getConfiguration(param.getParameter("descriptor", null));
                String query = this.getAddQuery(conf);
                datasource = this.getDataSource(conf);
                conn = datasource.getConnection();
                Request request = ObjectModelHelper.getRequest((Map)objectModel);
                if (conn.getAutoCommit()) {
                    conn.setAutoCommit(false);
                }
                PreparedStatement statement = conn.prepareStatement(query);
                this.getLogger().info(query);
                Configuration[] keys = conf.getChild("table").getChild("keys").getChildren("key");
                Configuration[] values = conf.getChild("table").getChild("values").getChildren("value");
                currentIndex = 1;
                for (i = 0; i < keys.length; ++i) {
                    String mode = keys[i].getAttribute("mode", "automatic");
                    if ("manual".equals(mode)) {
                        String selectQuery = this.getSelectQuery(keys[i]);
                        Statement stmt = null;
                        ResultSet set = null;
                        try {
                            stmt = conn.createStatement();
                            set = stmt.executeQuery(selectQuery);
                            set.next();
                            int value = set.getInt("maxid") + 1;
                            statement.setInt(currentIndex, value);
                            request.setAttribute(keys[i].getAttribute("param"), (Object)String.valueOf(value));
                            continue;
                        }
                        catch (SQLException sqle) {
                            this.getLogger().warn("There was an error retrieving the next key while inserting on the database", (Throwable)sqle);
                            throw sqle;
                        }
                        finally {
                            set.close();
                            stmt.close();
                            ++currentIndex;
                        }
                    }
                    if (!"form".equals(mode)) continue;
                    parameter = keys[i].getAttribute("param");
                    request.setAttribute(parameter, (Object)request.getParameter(parameter));
                    this.setColumn(statement, currentIndex, request, keys[i]);
                    ++currentIndex;
                }
                for (i = 0; i < values.length; ++i) {
                    String type = values[i].getAttribute("type");
                    parameter = values[i].getAttribute("param");
                    if (type.equals("image")) {
                        File binaryFile = (File)request.get(parameter);
                        Parameters iparam = new Parameters();
                        iparam.setParameter("image-size", String.valueOf(binaryFile.length()));
                        ImageProperties prop = ImageUtils.getImageProperties((File)binaryFile);
                        iparam.setParameter("image-width", Integer.toString(prop.width));
                        iparam.setParameter("image-height", Integer.toString(prop.height));
                        Map map = this.files;
                        synchronized (map) {
                            this.files.put(binaryFile, param);
                        }
                    }
                    if (this.isLargeObject(type)) continue;
                    this.setColumn(statement, currentIndex, request, values[i]);
                    ++currentIndex;
                }
                statement.execute();
                statement.close();
                query = this.getSelectLOBQuery(conf);
                if (query != null) {
                    OracleResultSet set;
                    PreparedStatement LOBstatement = conn.prepareStatement(query);
                    this.getLogger().info(query);
                    if (keys.length > 0) {
                        currentIndex = 1;
                        for (int i2 = 0; i2 < keys.length; ++i2) {
                            this.setColumn(LOBstatement, currentIndex, request, keys[i2]);
                            ++currentIndex;
                        }
                    }
                    if ((set = (OracleResultSet)LOBstatement.executeQuery()).next()) {
                        int index = 0;
                        for (int i3 = 0; i3 < values.length; ++i3) {
                            String type = values[i3].getAttribute("type", "");
                            if (!this.isLargeObject(type)) continue;
                            Object attr = request.get(values[i3].getAttribute("param"));
                            int length = -1;
                            BufferedInputStream stream = null;
                            BufferedOutputStream output = null;
                            int bufSize = 1024;
                            ++index;
                            if (type.equals("ascii")) {
                                CLOB ascii = set.getCLOB(index);
                                if (attr instanceof File) {
                                    File asciiFile = (File)attr;
                                    stream = new BufferedInputStream(new FileInputStream(asciiFile));
                                } else {
                                    String asciiText = (String)attr;
                                    stream = new BufferedInputStream(new ByteArrayInputStream(asciiText.getBytes()));
                                }
                                output = new BufferedOutputStream(ascii.getAsciiOutputStream());
                                bufSize = ascii.getBufferSize();
                            } else {
                                BLOB binary = set.getBLOB(index);
                                File binaryFile = (File)attr;
                                stream = new BufferedInputStream(new FileInputStream(binaryFile));
                                length = (int)binaryFile.length();
                                output = new BufferedOutputStream(binary.getBinaryOutputStream());
                                bufSize = binary.getBufferSize();
                            }
                            byte[] buffer = new byte[bufSize];
                            while ((length = ((InputStream)stream).read(buffer)) != -1) {
                                ((OutputStream)output).write(buffer, 0, length);
                            }
                            ((InputStream)stream).close();
                            ((OutputStream)output).close();
                        }
                    }
                    set.close();
                    set.getStatement().close();
                }
                conn.commit();
                Object var28_40 = null;
                if (conn == null) break block36;
                try {
                    conn.close();
                }
                catch (SQLException sqe) {
                    this.getLogger().warn("There was an error closing the datasource", (Throwable)sqe);
                }
            }
            if (datasource != null) {
                this.dbselector.release((Object)datasource);
            }
            break block37;
            {
                catch (Exception e) {
                    if (conn != null) {
                        try {
                            conn.rollback();
                        }
                        catch (SQLException se) {
                            this.getLogger().debug("There was an error rolling back the transaction", (Throwable)se);
                        }
                    }
                    throw new ProcessingException("Could not add record :position = " + (currentIndex - 1), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var28_41 = null;
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException sqe) {
                        this.getLogger().warn("There was an error closing the datasource", (Throwable)sqe);
                    }
                }
                if (datasource != null) {
                    this.dbselector.release(datasource);
                }
                throw throwable;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String getAddQuery(Configuration conf) throws ConfigurationException {
        String query = null;
        Map map = DatabaseAddAction.addStatements;
        synchronized (map) {
            query = (String)DatabaseAddAction.addStatements.get(conf);
            if (query == null) {
                int i;
                int i2;
                Configuration table = conf.getChild("table");
                Configuration[] values = table.getChild("values").getChildren("value");
                Configuration[] keys = table.getChild("keys").getChildren("key");
                StringBuffer queryBuffer = new StringBuffer("INSERT INTO ");
                queryBuffer.append(table.getAttribute("name"));
                queryBuffer.append(" (");
                int numKeys = 0;
                for (i2 = 0; i2 < keys.length; ++i2) {
                    String mode = keys[i2].getAttribute("mode", "automatic");
                    if (numKeys > 0) {
                        queryBuffer.append(", ");
                    }
                    queryBuffer.append(keys[i2].getAttribute("dbcol"));
                    if ("manual".equals(mode)) {
                        this.setSelectQuery(table.getAttribute("name"), keys[i2]);
                    }
                    ++numKeys;
                }
                for (i2 = 0; i2 < values.length; ++i2) {
                    if (numKeys + i2 > 0) {
                        queryBuffer.append(", ");
                    }
                    queryBuffer.append(values[i2].getAttribute("dbcol"));
                }
                queryBuffer.append(") VALUES (");
                numKeys = 0;
                ArrayList<String> sequences = new ArrayList<String>();
                for (i = 0; i < keys.length; ++i) {
                    if (numKeys > 0) {
                        queryBuffer.append(", ");
                    }
                    if ("automatic".equals(keys[i].getAttribute("mode", "automatic"))) {
                        String sequence = keys[i].getAttribute("sequence", "");
                        queryBuffer.append(sequence);
                        if (sequences.contains(sequence)) {
                            queryBuffer.append(".CURRVAL");
                        } else {
                            sequences.add(sequence);
                            queryBuffer.append(".NEXTVAL");
                        }
                        ++numKeys;
                        continue;
                    }
                    queryBuffer.append("?");
                    ++numKeys;
                }
                for (i = 0; i < values.length; ++i) {
                    if (numKeys + i > 0) {
                        queryBuffer.append(", ");
                    }
                    if (this.isLargeObject(values[i].getAttribute("type"))) {
                        if (values[i].getAttribute("type").equals("ascii")) {
                            queryBuffer.append("empty_clob()");
                            continue;
                        }
                        queryBuffer.append("empty_blob()");
                        continue;
                    }
                    queryBuffer.append("?");
                }
                queryBuffer.append(")");
                query = queryBuffer.toString();
                DatabaseAddAction.addStatements.put(conf, query);
            }
        }
        if ("".equals(query)) {
            return null;
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getSelectLOBQuery(Configuration conf) throws ConfigurationException {
        String query = null;
        Map map = selectLOBStatements;
        synchronized (map) {
            query = (String)selectLOBStatements.get(conf);
            if (query == null) {
                StringBuffer queryBuffer = new StringBuffer("SELECT ");
                Configuration table = conf.getChild("table");
                Configuration[] values = table.getChild("values").getChildren("value");
                Configuration[] keys = table.getChild("keys").getChildren("key");
                int numLobs = 0;
                for (int i = 0; i < values.length; ++i) {
                    if (!this.isLargeObject(values[i].getAttribute("type"))) continue;
                    if (++numLobs > 1) {
                        queryBuffer.append(", ");
                    }
                    queryBuffer.append(values[i].getAttribute("dbcol"));
                }
                if (numLobs < 1) {
                    query = "";
                    selectLOBStatements.put(conf, query);
                    return null;
                }
                queryBuffer.append(" FROM ").append(table.getAttribute("name"));
                if (keys.length > 0) {
                    queryBuffer.append(" WHERE ");
                    queryBuffer.append(this.buildList(keys, " AND "));
                }
                query = queryBuffer.toString().trim();
                selectLOBStatements.put(conf, query);
            }
        }
        return "".equals(query) ? null : query;
    }
}

