/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting.modular;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.cocoon.acting.modular.DatabaseAction;
import org.apache.cocoon.util.HashMap;

public class DatabaseQueryAction
extends DatabaseAction {
    protected String selectMode(boolean isAutoIncrement, Map modes) {
        return (String)modes.get(MODE_OTHERS);
    }

    protected boolean honourAutoIncrement() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DatabaseAction.CacheHelper getQuery(Configuration table, Map modeTypes, Map defaultModeNames) throws ConfigurationException, ServiceException {
        DatabaseAction.LookUpKey lookUpKey = new DatabaseAction.LookUpKey(table, modeTypes);
        DatabaseAction.CacheHelper queryData = null;
        HashMap hashMap = this.cachedQueryData;
        synchronized (hashMap) {
            queryData = (DatabaseAction.CacheHelper)this.cachedQueryData.get((Object)lookUpKey);
            if (queryData == null) {
                Configuration[] queries = table.getChild("queries").getChildren("query");
                Configuration[] keys = table.getChild("keys").getChildren("key");
                Configuration[] values = table.getChild("values").getChildren("value");
                boolean found = false;
                String queryModeName = "";
                String query = "";
                boolean useValues = true;
                for (int i = 0; i < queries.length; ++i) {
                    queryModeName = queries[i].getAttribute("mode", null);
                    if (!queryModeName.equals(modeTypes.get(MODE_OTHERS)) && !"all".equals(queryModeName)) continue;
                    query = queries[i].getValue();
                    useValues = queries[i].getAttributeAsBoolean("use-values", useValues);
                    found = true;
                    break;
                }
                if (!found) {
                    throw new ConfigurationException("Could not find query mode " + modeTypes.get(MODE_OTHERS) + " for table " + table.getAttribute("name", null));
                }
                queryData = new DatabaseAction.CacheHelper(keys.length, keys.length + (useValues ? values.length : 0));
                queryData.queryString = query;
                this.fillModes(keys, true, defaultModeNames, modeTypes, queryData);
                if (useValues) {
                    this.fillModes(values, false, defaultModeNames, modeTypes, queryData);
                }
                this.cachedQueryData.put((Object)lookUpKey, (Object)queryData);
            }
        }
        return queryData;
    }

    protected Object[][] getColumnValues(Configuration tableConf, DatabaseAction.CacheHelper queryData, Map objectModel) throws ConfigurationException, ServiceException {
        Object[][] columnValues = new Object[queryData.columns.length][];
        for (int i = 0; i < queryData.columns.length; ++i) {
            columnValues[i] = this.getColumnValue(tableConf, queryData.columns[i], objectModel);
        }
        return columnValues;
    }

    protected int processRow(Map objectModel, Connection conn, PreparedStatement statement, String outputMode, Configuration table, DatabaseAction.CacheHelper queryData, Object[][] columnValues, int rowIndex, Map results) throws SQLException, ConfigurationException, Exception {
        int currentIndex = 1;
        for (int i = 0; i < queryData.columns.length; ++i) {
            DatabaseAction.Column col = queryData.columns[i];
            if (!col.isKey) continue;
            this.setColumn(objectModel, outputMode, results, table, col.columnConf, rowIndex, columnValues[i][col.isSet ? rowIndex : 0], statement, currentIndex);
            ++currentIndex;
        }
        boolean hasResult = statement.execute();
        if (!hasResult) {
            return statement.getUpdateCount();
        }
        ResultSet resultset = statement.getResultSet();
        ResultSetMetaData metadata = resultset.getMetaData();
        rowIndex = 0;
        while (resultset.next()) {
            ++rowIndex;
            String tableName = "";
            String columnName = "";
            for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                Object value = resultset.getObject(i);
                tableName = metadata.getTableName(i);
                columnName = metadata.getColumnLabel(i) + "[" + rowIndex + "]";
                if (!tableName.equals("")) {
                    columnName = tableName + "." + columnName;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("retrieving " + columnName + " as " + value);
                }
                results.put(metadata.getTableName(i) + "." + metadata.getColumnLabel(i), value);
            }
        }
        return rowIndex;
    }
}

