/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.classfile;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.mozilla.classfile.ByteCode;
import org.mozilla.classfile.ClassFileField;
import org.mozilla.classfile.ClassFileMethod;
import org.mozilla.classfile.ConstantPool;
import org.mozilla.classfile.ExceptionTableEntry;
import org.mozilla.javascript.LabelTable;
import org.mozilla.javascript.LocalVariable;
import org.mozilla.javascript.VariableTable;

public class ClassFileWriter
extends LabelTable {
    public static final short ACC_PUBLIC = 1;
    public static final short ACC_PRIVATE = 2;
    public static final short ACC_PROTECTED = 4;
    public static final short ACC_STATIC = 8;
    public static final short ACC_FINAL = 16;
    public static final short ACC_SYNCHRONIZED = 32;
    public static final short ACC_VOLATILE = 64;
    public static final short ACC_TRANSIENT = 128;
    public static final short ACC_NATIVE = 256;
    public static final short ACC_ABSTRACT = 1024;
    private static final int LineNumberTableSize = 16;
    private static final int ExceptionTableSize = 4;
    private static final long FileHeaderConstant = -3819410108756852691L;
    private static final boolean DEBUG = true;
    private static final boolean DEBUGSTACK = false;
    private static final boolean DEBUGLABELS = false;
    private static final boolean DEBUGCODE = false;
    private static final int CodeBufferSize = 128;
    private ExceptionTableEntry[] itsExceptionTable;
    private int itsExceptionTableTop;
    private int[] itsLineNumberTable;
    private int itsLineNumberTableTop;
    private byte[] itsCodeBuffer;
    private int itsCodeBufferTop;
    private ConstantPool itsConstantPool;
    private short itsSourceFileAttributeIndex;
    private ClassFileMethod itsCurrentMethod;
    private short itsStackTop;
    private short itsMaxStack;
    private short itsMaxLocals;
    private Vector itsMethods = new Vector();
    private Vector itsFields = new Vector();
    private Vector itsInterfaces = new Vector();
    private short itsFlags;
    private short itsThisClassIndex;
    private short itsSuperClassIndex;
    private short itsSourceFileNameIndex;

    public ClassFileWriter(String className, String superClassName, String sourceFileName) {
        this.itsConstantPool = new ConstantPool();
        this.itsThisClassIndex = this.itsConstantPool.addClass(className);
        this.itsSuperClassIndex = this.itsConstantPool.addClass(superClassName);
        if (sourceFileName != null) {
            this.itsSourceFileNameIndex = this.itsConstantPool.addUtf8(sourceFileName);
        }
        this.itsFlags = 1;
    }

    public void addInterface(String interfaceName) {
        short interfaceIndex = this.itsConstantPool.addClass(interfaceName);
        this.itsInterfaces.addElement(new Short(interfaceIndex));
    }

    public void setFlags(short flags) {
        this.itsFlags = flags;
    }

    public static String fullyQualifiedForm(String name) {
        return name.replace('.', '/');
    }

    public void addField(String fieldName, String type, short flags) {
        short fieldNameIndex = this.itsConstantPool.addUtf8(fieldName);
        short typeIndex = this.itsConstantPool.addUtf8(type);
        this.itsFields.addElement(new ClassFileField(fieldNameIndex, typeIndex, flags));
    }

    public void addField(String fieldName, String type, short flags, int value) {
        short fieldNameIndex = this.itsConstantPool.addUtf8(fieldName);
        short typeIndex = this.itsConstantPool.addUtf8(type);
        short[] cvAttr = new short[]{this.itsConstantPool.addUtf8("ConstantValue"), 0, 2, this.itsConstantPool.addConstant(value)};
        this.itsFields.addElement(new ClassFileField(fieldNameIndex, typeIndex, flags, cvAttr));
    }

    public void addField(String fieldName, String type, short flags, long value) {
        short fieldNameIndex = this.itsConstantPool.addUtf8(fieldName);
        short typeIndex = this.itsConstantPool.addUtf8(type);
        short[] cvAttr = new short[]{this.itsConstantPool.addUtf8("ConstantValue"), 0, 2, this.itsConstantPool.addConstant(value)};
        this.itsFields.addElement(new ClassFileField(fieldNameIndex, typeIndex, flags, cvAttr));
    }

    public void addField(String fieldName, String type, short flags, double value) {
        short fieldNameIndex = this.itsConstantPool.addUtf8(fieldName);
        short typeIndex = this.itsConstantPool.addUtf8(type);
        short[] cvAttr = new short[]{this.itsConstantPool.addUtf8("ConstantValue"), 0, 2, this.itsConstantPool.addConstant(value)};
        this.itsFields.addElement(new ClassFileField(fieldNameIndex, typeIndex, flags, cvAttr));
    }

    public void startMethod(String methodName, String type, short flags) {
        short methodNameIndex = this.itsConstantPool.addUtf8(methodName);
        short typeIndex = this.itsConstantPool.addUtf8(type);
        this.itsCurrentMethod = new ClassFileMethod(methodNameIndex, typeIndex, flags);
        this.itsMethods.addElement(this.itsCurrentMethod);
    }

    public void stopMethod(short maxLocals, VariableTable vars) {
        if (this.itsCurrentMethod == null) {
            throw new RuntimeException("No method to stop");
        }
        for (int i = 0; i < this.itsLabelTableTop; ++i) {
            this.itsLabelTable[i].fixGotos(this.itsCodeBuffer);
        }
        this.itsMaxLocals = maxLocals;
        int lineNumberTableLength = 0;
        if (this.itsLineNumberTable != null) {
            lineNumberTableLength = 8 + this.itsLineNumberTableTop * 4;
        }
        int variableTableLength = 0;
        if (vars != null) {
            variableTableLength = 8 + vars.size() * 10;
        }
        int attrLength = 14 + this.itsCodeBufferTop + 2 + this.itsExceptionTableTop * 8 + 2 + lineNumberTableLength + variableTableLength;
        byte[] codeAttribute = new byte[attrLength];
        int index = 0;
        short codeAttrIndex = this.itsConstantPool.addUtf8("Code");
        codeAttribute[index++] = (byte)(codeAttrIndex >> 8);
        codeAttribute[index++] = (byte)codeAttrIndex;
        codeAttribute[index++] = (byte)((attrLength -= 6) >> 24);
        codeAttribute[index++] = (byte)(attrLength >> 16);
        codeAttribute[index++] = (byte)(attrLength >> 8);
        codeAttribute[index++] = (byte)attrLength;
        codeAttribute[index++] = (byte)(this.itsMaxStack >> 8);
        codeAttribute[index++] = (byte)this.itsMaxStack;
        codeAttribute[index++] = (byte)(this.itsMaxLocals >> 8);
        codeAttribute[index++] = (byte)this.itsMaxLocals;
        codeAttribute[index++] = (byte)(this.itsCodeBufferTop >> 24);
        codeAttribute[index++] = (byte)(this.itsCodeBufferTop >> 16);
        codeAttribute[index++] = (byte)(this.itsCodeBufferTop >> 8);
        codeAttribute[index++] = (byte)this.itsCodeBufferTop;
        System.arraycopy(this.itsCodeBuffer, 0, codeAttribute, index, this.itsCodeBufferTop);
        index += this.itsCodeBufferTop;
        if (this.itsExceptionTableTop > 0) {
            codeAttribute[index++] = (byte)(this.itsExceptionTableTop >> 8);
            codeAttribute[index++] = (byte)this.itsExceptionTableTop;
            for (int i = 0; i < this.itsExceptionTableTop; ++i) {
                short startPC = this.itsExceptionTable[i].getStartPC(this.itsLabelTable);
                codeAttribute[index++] = (byte)(startPC >> 8);
                codeAttribute[index++] = (byte)startPC;
                short endPC = this.itsExceptionTable[i].getEndPC(this.itsLabelTable);
                codeAttribute[index++] = (byte)(endPC >> 8);
                codeAttribute[index++] = (byte)endPC;
                short handlerPC = this.itsExceptionTable[i].getHandlerPC(this.itsLabelTable);
                codeAttribute[index++] = (byte)(handlerPC >> 8);
                codeAttribute[index++] = (byte)handlerPC;
                short catchType = this.itsExceptionTable[i].getCatchType();
                codeAttribute[index++] = (byte)(catchType >> 8);
                codeAttribute[index++] = (byte)catchType;
            }
        } else {
            codeAttribute[index++] = 0;
            codeAttribute[index++] = 0;
        }
        int attributeCount = 0;
        if (this.itsLineNumberTable != null) {
            ++attributeCount;
        }
        if (vars != null) {
            ++attributeCount;
        }
        codeAttribute[index++] = 0;
        codeAttribute[index++] = (byte)attributeCount;
        if (this.itsLineNumberTable != null) {
            short lineNumberTableAttrIndex = this.itsConstantPool.addUtf8("LineNumberTable");
            codeAttribute[index++] = (byte)(lineNumberTableAttrIndex >> 8);
            codeAttribute[index++] = (byte)lineNumberTableAttrIndex;
            int tableAttrLength = 2 + this.itsLineNumberTableTop * 4;
            codeAttribute[index++] = (byte)(tableAttrLength >> 24);
            codeAttribute[index++] = (byte)(tableAttrLength >> 16);
            codeAttribute[index++] = (byte)(tableAttrLength >> 8);
            codeAttribute[index++] = (byte)tableAttrLength;
            codeAttribute[index++] = (byte)(this.itsLineNumberTableTop >> 8);
            codeAttribute[index++] = (byte)this.itsLineNumberTableTop;
            for (int i = 0; i < this.itsLineNumberTableTop; ++i) {
                codeAttribute[index++] = (byte)(this.itsLineNumberTable[i] >> 24);
                codeAttribute[index++] = (byte)(this.itsLineNumberTable[i] >> 16);
                codeAttribute[index++] = (byte)(this.itsLineNumberTable[i] >> 8);
                codeAttribute[index++] = (byte)this.itsLineNumberTable[i];
            }
        }
        if (vars != null) {
            short variableTableAttrIndex = this.itsConstantPool.addUtf8("LocalVariableTable");
            codeAttribute[index++] = (byte)(variableTableAttrIndex >> 8);
            codeAttribute[index++] = (byte)variableTableAttrIndex;
            int varCount = vars.size();
            int tableAttrLength = 2 + varCount * 10;
            codeAttribute[index++] = (byte)(tableAttrLength >> 24);
            codeAttribute[index++] = (byte)(tableAttrLength >> 16);
            codeAttribute[index++] = (byte)(tableAttrLength >> 8);
            codeAttribute[index++] = (byte)tableAttrLength;
            codeAttribute[index++] = (byte)(varCount >> 8);
            codeAttribute[index++] = (byte)varCount;
            for (int i = 0; i < varCount; ++i) {
                LocalVariable lvar = vars.getVariable(i);
                int startPc = lvar.getStartPC();
                codeAttribute[index++] = (byte)(startPc >> 8);
                codeAttribute[index++] = (byte)startPc;
                int length = this.itsCodeBufferTop - startPc;
                codeAttribute[index++] = (byte)(length >> 8);
                codeAttribute[index++] = (byte)length;
                short nameIndex = this.itsConstantPool.addUtf8(lvar.getName());
                codeAttribute[index++] = (byte)(nameIndex >> 8);
                codeAttribute[index++] = (byte)nameIndex;
                short descriptorIndex = this.itsConstantPool.addUtf8(lvar.isNumber() ? "D" : "Ljava/lang/Object;");
                codeAttribute[index++] = (byte)(descriptorIndex >> 8);
                codeAttribute[index++] = (byte)descriptorIndex;
                short jreg = lvar.getJRegister();
                codeAttribute[index++] = (byte)(jreg >> 8);
                codeAttribute[index++] = (byte)jreg;
            }
        }
        this.itsCurrentMethod.setCodeAttribute(codeAttribute);
        this.itsExceptionTable = null;
        this.itsExceptionTableTop = 0;
        this.itsLabelTableTop = 0;
        this.itsLineNumberTable = null;
        this.itsCodeBufferTop = 0;
        this.itsCurrentMethod = null;
        this.itsMaxStack = 0;
        this.itsStackTop = 0;
    }

    public void add(byte theOpCode) {
        if (ByteCode.opcodeCount[theOpCode & 0xFF] != 0) {
            throw new RuntimeException("Expected operands");
        }
        this.addToCodeBuffer(theOpCode);
        this.itsStackTop = (short)(this.itsStackTop + ByteCode.stackChange[theOpCode & 0xFF]);
        if (this.itsStackTop < 0) {
            throw new RuntimeException("Stack underflow");
        }
        if (this.itsStackTop > this.itsMaxStack) {
            this.itsMaxStack = this.itsStackTop;
        }
    }

    public void add(byte theOpCode, int theOperand) {
        this.itsStackTop = (short)(this.itsStackTop + ByteCode.stackChange[theOpCode & 0xFF]);
        if (this.itsStackTop < 0) {
            throw new RuntimeException("Stack underflow");
        }
        if (this.itsStackTop > this.itsMaxStack) {
            this.itsMaxStack = this.itsStackTop;
        }
        switch (theOpCode) {
            case -103: 
            case -102: 
            case -101: 
            case -100: 
            case -99: 
            case -98: 
            case -97: 
            case -96: 
            case -95: 
            case -94: 
            case -93: 
            case -92: 
            case -91: 
            case -90: 
            case -89: 
            case -88: 
            case -58: 
            case -57: {
                if ((theOperand & Integer.MIN_VALUE) != Integer.MIN_VALUE && (theOperand < 0 || theOperand > 65535)) {
                    throw new RuntimeException("Bad label for branch");
                }
                int branchPC = this.itsCodeBufferTop;
                this.addToCodeBuffer(theOpCode);
                if ((theOperand & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
                    int temp_Label = this.acquireLabel();
                    int theLabel = temp_Label & Integer.MAX_VALUE;
                    this.itsLabelTable[theLabel].setPC((short)(branchPC + theOperand));
                    this.addToCodeBuffer((byte)(theOperand >> 8));
                    this.addToCodeBuffer((byte)theOperand);
                    break;
                }
                int theLabel = theOperand & Integer.MAX_VALUE;
                short targetPC = this.itsLabelTable[theLabel].getPC();
                if (targetPC != -1) {
                    short offset = (short)(targetPC - branchPC);
                    this.addToCodeBuffer((byte)(offset >> 8));
                    this.addToCodeBuffer((byte)offset);
                    break;
                }
                this.itsLabelTable[theLabel].addFixup(branchPC + 1);
                this.addToCodeBuffer((byte)0);
                this.addToCodeBuffer((byte)0);
                break;
            }
            case 16: {
                if (theOperand < -128 || theOperand > 127) {
                    throw new RuntimeException("out of range byte");
                }
                this.addToCodeBuffer(theOpCode);
                this.addToCodeBuffer((byte)theOperand);
                break;
            }
            case 17: {
                if (theOperand < Short.MIN_VALUE || theOperand > Short.MAX_VALUE) {
                    throw new RuntimeException("out of range short");
                }
                this.addToCodeBuffer(theOpCode);
                this.addToCodeBuffer((byte)(theOperand >> 8));
                this.addToCodeBuffer((byte)theOperand);
                break;
            }
            case -68: {
                if (theOperand < 0 || theOperand > 255) {
                    throw new RuntimeException("out of range index");
                }
                this.addToCodeBuffer(theOpCode);
                this.addToCodeBuffer((byte)theOperand);
                break;
            }
            case -76: 
            case -75: {
                if (theOperand < 0 || theOperand > 65535) {
                    throw new RuntimeException("out of range field");
                }
                this.addToCodeBuffer(theOpCode);
                this.addToCodeBuffer((byte)(theOperand >> 8));
                this.addToCodeBuffer((byte)theOperand);
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                if (theOperand < 0 || theOperand > 65535) {
                    throw new RuntimeException("out of range index");
                }
                if (theOperand >= 256 || theOpCode == 19 || theOpCode == 20) {
                    if (theOpCode == 18) {
                        this.addToCodeBuffer((byte)19);
                    } else {
                        this.addToCodeBuffer(theOpCode);
                    }
                    this.addToCodeBuffer((byte)(theOperand >> 8));
                    this.addToCodeBuffer((byte)theOperand);
                    break;
                }
                this.addToCodeBuffer(theOpCode);
                this.addToCodeBuffer((byte)theOperand);
                break;
            }
            case -87: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                if (theOperand < 0 || theOperand > 65535) {
                    throw new RuntimeException("out of range variable");
                }
                if (theOperand >= 256) {
                    this.addToCodeBuffer((byte)-60);
                    this.addToCodeBuffer(theOpCode);
                    this.addToCodeBuffer((byte)(theOperand >> 8));
                    this.addToCodeBuffer((byte)theOperand);
                    break;
                }
                this.addToCodeBuffer(theOpCode);
                this.addToCodeBuffer((byte)theOperand);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected opcode for 1 operand");
            }
        }
    }

    public void addLoadConstant(int k) {
        this.add((byte)18, this.itsConstantPool.addConstant(k));
    }

    public void addLoadConstant(long k) {
        this.add((byte)20, this.itsConstantPool.addConstant(k));
    }

    public void addLoadConstant(float k) {
        this.add((byte)18, this.itsConstantPool.addConstant(k));
    }

    public void addLoadConstant(double k) {
        this.add((byte)20, this.itsConstantPool.addConstant(k));
    }

    public void addLoadConstant(String k) {
        this.add((byte)18, this.itsConstantPool.addConstant(k));
    }

    public void add(byte theOpCode, int theOperand1, int theOperand2) {
        this.itsStackTop = (short)(this.itsStackTop + ByteCode.stackChange[theOpCode & 0xFF]);
        if (this.itsStackTop < 0) {
            throw new RuntimeException("Stack underflow");
        }
        if (this.itsStackTop > this.itsMaxStack) {
            this.itsMaxStack = this.itsStackTop;
        }
        if (theOpCode == -124) {
            if (theOperand1 < 0 || theOperand1 > 65535) {
                throw new RuntimeException("out of range variable");
            }
            if (theOperand2 < Short.MIN_VALUE || theOperand2 > Short.MAX_VALUE) {
                throw new RuntimeException("out of range increment");
            }
            if (theOperand1 > 255 || theOperand2 < -128 || theOperand2 > 127) {
                this.addToCodeBuffer((byte)-60);
                this.addToCodeBuffer((byte)-124);
                this.addToCodeBuffer((byte)(theOperand1 >> 8));
                this.addToCodeBuffer((byte)theOperand1);
                this.addToCodeBuffer((byte)(theOperand2 >> 8));
                this.addToCodeBuffer((byte)theOperand2);
            } else {
                this.addToCodeBuffer((byte)-60);
                this.addToCodeBuffer((byte)-124);
                this.addToCodeBuffer((byte)theOperand1);
                this.addToCodeBuffer((byte)theOperand2);
            }
        } else if (theOpCode == -59) {
            if (theOperand1 < 0 || theOperand1 > 65535) {
                throw new RuntimeException("out of range index");
            }
            if (theOperand2 < 0 || theOperand2 > 255) {
                throw new RuntimeException("out of range dimensions");
            }
            this.addToCodeBuffer((byte)-59);
            this.addToCodeBuffer((byte)(theOperand1 >> 8));
            this.addToCodeBuffer((byte)theOperand1);
            this.addToCodeBuffer((byte)theOperand2);
        } else {
            throw new RuntimeException("Unexpected opcode for 2 operands");
        }
    }

    public void add(byte theOpCode, String className) {
        this.itsStackTop = (short)(this.itsStackTop + ByteCode.stackChange[theOpCode & 0xFF]);
        if (this.itsStackTop < 0) {
            throw new RuntimeException("Stack underflow");
        }
        switch (theOpCode) {
            case -69: 
            case -67: 
            case -64: 
            case -63: {
                short classIndex = this.itsConstantPool.addClass(className);
                this.addToCodeBuffer(theOpCode);
                this.addToCodeBuffer((byte)(classIndex >> 8));
                this.addToCodeBuffer((byte)classIndex);
                break;
            }
            default: {
                throw new RuntimeException("bad opcode for class reference");
            }
        }
        if (this.itsStackTop > this.itsMaxStack) {
            this.itsMaxStack = this.itsStackTop;
        }
    }

    public void add(byte theOpCode, String className, String fieldName, String fieldType) {
        this.itsStackTop = (short)(this.itsStackTop + ByteCode.stackChange[theOpCode & 0xFF]);
        if (this.itsStackTop < 0) {
            throw new RuntimeException("After " + Integer.toHexString(theOpCode & 0xFF) + " Stack underflow");
        }
        char fieldTypeChar = fieldType.charAt(0);
        int fieldSize = fieldTypeChar == 'J' || fieldTypeChar == 'D' ? 2 : 1;
        switch (theOpCode) {
            case -78: 
            case -76: {
                this.itsStackTop = (short)(this.itsStackTop + fieldSize);
                break;
            }
            case -77: 
            case -75: {
                this.itsStackTop = (short)(this.itsStackTop - fieldSize);
                break;
            }
            default: {
                throw new RuntimeException("bad opcode for field reference");
            }
        }
        short fieldRefIndex = this.itsConstantPool.addFieldRef(className, fieldName, fieldType);
        this.addToCodeBuffer(theOpCode);
        this.addToCodeBuffer((byte)(fieldRefIndex >> 8));
        this.addToCodeBuffer((byte)fieldRefIndex);
        if (this.itsStackTop > this.itsMaxStack) {
            this.itsMaxStack = this.itsStackTop;
        }
    }

    public void add(byte theOpCode, String className, String methodName, String parametersType, String returnType) {
        int parameterInfo = this.sizeOfParameters(parametersType);
        this.itsStackTop = (short)(this.itsStackTop - (parameterInfo & 0xFFFF));
        this.itsStackTop = (short)(this.itsStackTop + ByteCode.stackChange[theOpCode & 0xFF]);
        if (this.itsStackTop < 0) {
            throw new RuntimeException("After " + Integer.toHexString(theOpCode & 0xFF) + " Stack underflow");
        }
        if (this.itsStackTop > this.itsMaxStack) {
            this.itsMaxStack = this.itsStackTop;
        }
        switch (theOpCode) {
            case -74: 
            case -73: 
            case -72: 
            case -71: {
                char returnTypeChar = returnType.charAt(0);
                if (returnTypeChar != 'V') {
                    this.itsStackTop = returnTypeChar == 'J' || returnTypeChar == 'D' ? (short)(this.itsStackTop + 2) : (short)(this.itsStackTop + 1);
                }
                this.addToCodeBuffer(theOpCode);
                if (theOpCode == -71) {
                    short ifMethodRefIndex = this.itsConstantPool.addInterfaceMethodRef(className, methodName, parametersType + returnType);
                    this.addToCodeBuffer((byte)(ifMethodRefIndex >> 8));
                    this.addToCodeBuffer((byte)ifMethodRefIndex);
                    this.addToCodeBuffer((byte)((parameterInfo >> 16) + 1));
                    this.addToCodeBuffer((byte)0);
                    break;
                }
                short methodRefIndex = this.itsConstantPool.addMethodRef(className, methodName, parametersType + returnType);
                this.addToCodeBuffer((byte)(methodRefIndex >> 8));
                this.addToCodeBuffer((byte)methodRefIndex);
                break;
            }
            default: {
                throw new RuntimeException("bad opcode for method reference");
            }
        }
        if (this.itsStackTop > this.itsMaxStack) {
            this.itsMaxStack = this.itsStackTop;
        }
    }

    public int markLabel(int theLabel) {
        return super.markLabel(theLabel, (short)this.itsCodeBufferTop);
    }

    public int markLabel(int theLabel, short stackTop) {
        this.itsStackTop = stackTop;
        return super.markLabel(theLabel, (short)this.itsCodeBufferTop);
    }

    public int markHandler(int theLabel) {
        this.itsStackTop = 1;
        return this.markLabel(theLabel);
    }

    public int getCurrentCodeOffset() {
        return this.itsCodeBufferTop;
    }

    public short getStackTop() {
        return this.itsStackTop;
    }

    public void adjustStackTop(int delta) {
        this.itsStackTop = (short)(this.itsStackTop + delta);
        if (this.itsStackTop < 0) {
            throw new RuntimeException("Stack underflow");
        }
        if (this.itsStackTop > this.itsMaxStack) {
            this.itsMaxStack = this.itsStackTop;
        }
    }

    public void addToCodeBuffer(byte b) {
        if (this.itsCurrentMethod == null) {
            throw new RuntimeException("No method to add to");
        }
        if (this.itsCodeBuffer == null) {
            this.itsCodeBuffer = new byte[128];
            this.itsCodeBuffer[0] = b;
            this.itsCodeBufferTop = 1;
        } else {
            if (this.itsCodeBufferTop == this.itsCodeBuffer.length) {
                byte[] currentBuffer = this.itsCodeBuffer;
                this.itsCodeBuffer = new byte[this.itsCodeBufferTop * 2];
                System.arraycopy(currentBuffer, 0, this.itsCodeBuffer, 0, this.itsCodeBufferTop);
            }
            this.itsCodeBuffer[this.itsCodeBufferTop++] = b;
        }
    }

    public void addExceptionHandler(int startLabel, int endLabel, int handlerLabel, String catchClassName) {
        if ((startLabel & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            throw new RuntimeException("Bad startLabel");
        }
        if ((endLabel & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            throw new RuntimeException("Bad endLabel");
        }
        if ((handlerLabel & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            throw new RuntimeException("Bad handlerLabel");
        }
        ExceptionTableEntry newEntry = new ExceptionTableEntry(startLabel, endLabel, handlerLabel, catchClassName == null ? (short)0 : this.itsConstantPool.addClass(catchClassName));
        if (this.itsExceptionTable == null) {
            this.itsExceptionTable = new ExceptionTableEntry[4];
            this.itsExceptionTable[0] = newEntry;
            this.itsExceptionTableTop = 1;
        } else {
            if (this.itsExceptionTableTop == this.itsExceptionTable.length) {
                ExceptionTableEntry[] oldTable = this.itsExceptionTable;
                this.itsExceptionTable = new ExceptionTableEntry[this.itsExceptionTableTop * 2];
                System.arraycopy(oldTable, 0, this.itsExceptionTable, 0, this.itsExceptionTableTop);
            }
            this.itsExceptionTable[this.itsExceptionTableTop++] = newEntry;
        }
    }

    public void addLineNumberEntry(short lineNumber) {
        if (this.itsCurrentMethod == null) {
            throw new RuntimeException("No method to stop");
        }
        if (this.itsLineNumberTable == null) {
            this.itsLineNumberTable = new int[16];
            this.itsLineNumberTable[0] = (this.itsCodeBufferTop << 16) + lineNumber;
            this.itsLineNumberTableTop = 1;
        } else {
            if (this.itsLineNumberTableTop == this.itsLineNumberTable.length) {
                int[] oldTable = this.itsLineNumberTable;
                this.itsLineNumberTable = new int[this.itsLineNumberTableTop * 2];
                System.arraycopy(oldTable, 0, this.itsLineNumberTable, 0, this.itsLineNumberTableTop);
            }
            this.itsLineNumberTable[this.itsLineNumberTableTop++] = (this.itsCodeBufferTop << 16) + lineNumber;
        }
    }

    public void write(OutputStream oStream) throws IOException {
        int i;
        DataOutputStream out = new DataOutputStream(oStream);
        short sourceFileAttributeNameIndex = 0;
        if (this.itsSourceFileNameIndex != 0) {
            sourceFileAttributeNameIndex = this.itsConstantPool.addUtf8("SourceFile");
        }
        out.writeLong(-3819410108756852691L);
        this.itsConstantPool.write(out);
        out.writeShort(this.itsFlags);
        out.writeShort(this.itsThisClassIndex);
        out.writeShort(this.itsSuperClassIndex);
        out.writeShort(this.itsInterfaces.size());
        for (i = 0; i < this.itsInterfaces.size(); ++i) {
            out.writeShort(((Short)this.itsInterfaces.elementAt(i)).shortValue());
        }
        out.writeShort(this.itsFields.size());
        for (i = 0; i < this.itsFields.size(); ++i) {
            ((ClassFileField)this.itsFields.elementAt(i)).write(out);
        }
        out.writeShort(this.itsMethods.size());
        for (i = 0; i < this.itsMethods.size(); ++i) {
            ((ClassFileMethod)this.itsMethods.elementAt(i)).write(out);
        }
        if (this.itsSourceFileNameIndex != 0) {
            out.writeShort(1);
            out.writeShort(sourceFileAttributeNameIndex);
            out.writeInt(2);
            out.writeShort(this.itsSourceFileNameIndex);
        } else {
            out.writeShort(0);
        }
    }

    private int getWriteSize() {
        int i;
        int size = 0;
        if (this.itsSourceFileNameIndex != 0) {
            this.itsConstantPool.addUtf8("SourceFile");
        }
        size += 8;
        size += this.itsConstantPool.getWriteSize();
        size += 2;
        size += 2;
        size += 2;
        size += 2;
        size += 2 * this.itsInterfaces.size();
        size += 2;
        for (i = 0; i < this.itsFields.size(); ++i) {
            size += ((ClassFileField)this.itsFields.elementAt(i)).getWriteSize();
        }
        size += 2;
        for (i = 0; i < this.itsMethods.size(); ++i) {
            size += ((ClassFileMethod)this.itsMethods.elementAt(i)).getWriteSize();
        }
        if (this.itsSourceFileNameIndex != 0) {
            size += 2;
            size += 2;
            size += 4;
            size += 2;
        } else {
            size += 2;
        }
        return size;
    }

    public byte[] toByteArray() {
        int size = this.getWriteSize();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(size);
        try {
            this.write(bos);
        }
        catch (IOException ioe) {
            throw new RuntimeException();
        }
        byte[] classBytes = bos.toByteArray();
        if (classBytes.length != size) {
            throw new RuntimeException();
        }
        return classBytes;
    }

    private int sizeOfParameters(String pString) {
        if (pString.charAt(0) != '(') {
            throw new RuntimeException("Bad parameter signature");
        }
        int index = 1;
        int size = 0;
        int count = 0;
        block6: while (pString.charAt(index) != ')') {
            switch (pString.charAt(index)) {
                case 'D': 
                case 'J': {
                    ++size;
                }
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    ++size;
                    ++count;
                    ++index;
                    continue block6;
                }
                case '[': {
                    while (pString.charAt(index) == '[') {
                        ++index;
                    }
                    if (pString.charAt(index) != 'L') {
                        ++size;
                        ++count;
                        ++index;
                        continue block6;
                    }
                }
                case 'L': {
                    ++size;
                    ++count;
                    while (pString.charAt(index++) != ';') {
                    }
                    continue block6;
                }
            }
            throw new RuntimeException("Bad signature character");
        }
        return count << 16 | size;
    }
}

