/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.ClassNameHelper;
import org.mozilla.javascript.ClassOutput;
import org.mozilla.javascript.ClassRepository;
import org.mozilla.javascript.ContextListener;
import org.mozilla.javascript.DefaultErrorReporter;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.LazilyLoadedCtor;
import org.mozilla.javascript.ListenerArray;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeBoolean;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeDate;
import org.mozilla.javascript.NativeError;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeMath;
import org.mozilla.javascript.NativeNumber;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.NativeScript;
import org.mozilla.javascript.NativeString;
import org.mozilla.javascript.NativeWith;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.NotAFunctionException;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecuritySupport;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrapHandler;
import org.mozilla.javascript.debug.DebugReader;
import org.mozilla.javascript.debug.Debugger;

public class Context {
    public static final String languageVersionProperty = "language version";
    public static final String errorReporterProperty = "error reporter";
    public static final int VERSION_UNKNOWN = -1;
    public static final int VERSION_DEFAULT = 0;
    public static final int VERSION_1_0 = 100;
    public static final int VERSION_1_1 = 110;
    public static final int VERSION_1_2 = 120;
    public static final int VERSION_1_3 = 130;
    public static final int VERSION_1_4 = 140;
    public static final int VERSION_1_5 = 150;
    public static final int FEATURE_NON_ECMA_GET_YEAR = 1;
    public static final int FEATURE_MEMBER_EXPR_AS_FUNCTION_NAME = 2;
    public static final int FEATURE_RESERVED_KEYWORD_AS_IDENTIFIER = 3;
    static final String defaultResource = "org.mozilla.javascript.resources.Messages";
    static final boolean printTrees = false;
    static final boolean printICode = false;
    private static Class codegenClass;
    private static ClassNameHelper savedNameHelper;
    static final String[] interpreterClassNames;
    private static boolean requireSecurityDomain;
    private static boolean resourceMissing;
    static final String securityResourceName = "org.mozilla.javascript.resources.Security";
    static final boolean check = true;
    static final boolean useJSObject = false;
    static boolean isCachingEnabled;
    private static Hashtable threadContexts;
    private static Object[] contextListeners;
    NativeCall currentActivation;
    Hashtable iterating;
    Object interpreterSecurityDomain;
    int version;
    int errorCount;
    private SecuritySupport securitySupport;
    private ErrorReporter errorReporter;
    private Thread currentThread;
    private RegExpProxy regExpProxy;
    private Locale locale;
    private boolean generatingDebug;
    private boolean generatingDebugChanged;
    private boolean generatingSource = true;
    private boolean compileFunctionsWithDynamicScopeFlag;
    private int optimizationLevel;
    WrapHandler wrapHandler;
    Debugger debugger;
    private Object debuggerData;
    private int enterCount;
    private Object[] listeners;
    private Hashtable hashtable;
    private Hashtable activationNames;
    int interpreterLine;
    String interpreterSourceFile;
    Vector interpreterStackTrace;
    int instructionCount;
    int instructionThreshold;
    static /* synthetic */ Class class$org$mozilla$javascript$Interpreter;

    public Context() {
        this.init();
    }

    public Context(SecuritySupport securitySupport) {
        this.securitySupport = securitySupport;
        this.init();
    }

    private void init() {
        this.setLanguageVersion(0);
        this.optimizationLevel = codegenClass != null ? 0 : -1;
        Object[] array = contextListeners;
        if (array != null) {
            int i = array.length;
            while (i-- != 0) {
                ((ContextListener)array[i]).contextCreated(this);
            }
        }
    }

    public static Context enter() {
        return Context.enter(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Context enter(Context cx) {
        Object[] listeners;
        Context current;
        Thread t = Thread.currentThread();
        Hashtable hashtable = threadContexts;
        synchronized (hashtable) {
            current = (Context)threadContexts.get(t);
            if (cx != null) {
                Thread old = cx.currentThread;
                if (old != null && old != t) {
                    throw new RuntimeException("Cannot enter Context active on another thread");
                }
                if (old == t && cx != current) {
                    Context.codeBug();
                }
            }
            if (current == null) {
                if (cx == null) {
                    cx = new Context();
                }
                cx.currentThread = t;
                threadContexts.put(t, cx);
                current = cx;
            }
            ++current.enterCount;
            listeners = contextListeners;
        }
        if (listeners != null) {
            int i = listeners.length;
            while (i-- != 0) {
                ((ContextListener)listeners[i]).contextEntered(current);
            }
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exit() {
        Object[] listeners;
        Context cx;
        Thread t = Thread.currentThread();
        boolean released = false;
        Hashtable hashtable = threadContexts;
        synchronized (hashtable) {
            cx = (Context)threadContexts.get(t);
            if (cx == null) {
                throw new RuntimeException("Calling Context.exit without previous Context.enter");
            }
            if (cx.currentThread != t || cx.enterCount < 1) {
                Context.codeBug();
            }
            --cx.enterCount;
            if (cx.enterCount == 0) {
                released = true;
                threadContexts.remove(t);
                cx.currentThread = null;
            }
            listeners = contextListeners;
        }
        if (listeners != null) {
            int i = listeners.length;
            while (i-- != 0) {
                ((ContextListener)listeners[i]).contextExited(cx);
            }
            if (released) {
                i = listeners.length;
                while (i-- != 0) {
                    ((ContextListener)listeners[i]).contextReleased(cx);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addContextListener(ContextListener listener) {
        Hashtable hashtable = threadContexts;
        synchronized (hashtable) {
            contextListeners = ListenerArray.add(contextListeners, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeContextListener(ContextListener listener) {
        Hashtable hashtable = threadContexts;
        synchronized (hashtable) {
            contextListeners = ListenerArray.remove(contextListeners, listener);
        }
    }

    public static Context getCurrentContext() {
        Thread t = Thread.currentThread();
        return (Context)threadContexts.get(t);
    }

    public int getLanguageVersion() {
        return this.version;
    }

    public void setLanguageVersion(int version) {
        Object[] array = this.listeners;
        if (array != null && version != this.version) {
            this.firePropertyChangeImpl(array, languageVersionProperty, new Integer(this.version), new Integer(version));
        }
        this.version = version;
    }

    public String getImplementationVersion() {
        return "Rhino 1.5 release 4 0000 00 00 (in progress)";
    }

    public ErrorReporter getErrorReporter() {
        if (this.errorReporter == null) {
            this.errorReporter = new DefaultErrorReporter();
        }
        return this.errorReporter;
    }

    public ErrorReporter setErrorReporter(ErrorReporter reporter) {
        ErrorReporter result = this.errorReporter;
        Object[] array = this.listeners;
        if (array != null && this.errorReporter != reporter) {
            this.firePropertyChangeImpl(array, errorReporterProperty, this.errorReporter, reporter);
        }
        this.errorReporter = reporter;
        return result;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    public Locale setLocale(Locale loc) {
        Locale result = this.locale;
        this.locale = loc;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        Context context = this;
        synchronized (context) {
            this.listeners = ListenerArray.add(this.listeners, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        Context context = this;
        synchronized (context) {
            this.listeners = ListenerArray.remove(this.listeners, listener);
        }
    }

    void firePropertyChange(String property, Object oldValue, Object newValue) {
        Object[] array = this.listeners;
        if (array != null) {
            this.firePropertyChangeImpl(array, property, oldValue, newValue);
        }
    }

    private void firePropertyChangeImpl(Object[] array, String property, Object oldValue, Object newValue) {
        int i = array.length;
        while (i-- != 0) {
            Object obj = array[i];
            if (!(obj instanceof PropertyChangeListener)) continue;
            PropertyChangeListener l = (PropertyChangeListener)obj;
            l.propertyChange(new PropertyChangeEvent(this, property, oldValue, newValue));
        }
    }

    public static void reportWarning(String message, String sourceName, int lineno, String lineSource, int lineOffset) {
        Context cx = Context.getContext();
        cx.getErrorReporter().warning(message, sourceName, lineno, lineSource, lineOffset);
    }

    public static void reportWarning(String message) {
        int[] linep = new int[]{0};
        String filename = Context.getSourcePositionFromStack(linep);
        Context.reportWarning(message, filename, linep[0], null, 0);
    }

    public static void reportError(String message, String sourceName, int lineno, String lineSource, int lineOffset) {
        Context cx = Context.getCurrentContext();
        if (cx != null) {
            ++cx.errorCount;
        } else {
            throw new EvaluatorException(message);
        }
        cx.getErrorReporter().error(message, sourceName, lineno, lineSource, lineOffset);
    }

    public static void reportError(String message) {
        int[] linep = new int[]{0};
        String filename = Context.getSourcePositionFromStack(linep);
        Context.reportError(message, filename, linep[0], null, 0);
    }

    public static EvaluatorException reportRuntimeError(String message, String sourceName, int lineno, String lineSource, int lineOffset) {
        Context cx = Context.getCurrentContext();
        if (cx != null) {
            ++cx.errorCount;
            return cx.getErrorReporter().runtimeError(message, sourceName, lineno, lineSource, lineOffset);
        }
        throw new EvaluatorException(message);
    }

    static EvaluatorException reportRuntimeError0(String messageId) {
        return Context.reportRuntimeError(Context.getMessage0(messageId));
    }

    static EvaluatorException reportRuntimeError1(String messageId, Object arg1) {
        return Context.reportRuntimeError(Context.getMessage1(messageId, arg1));
    }

    static EvaluatorException reportRuntimeError2(String messageId, Object arg1, Object arg2) {
        return Context.reportRuntimeError(Context.getMessage2(messageId, arg1, arg2));
    }

    static EvaluatorException reportRuntimeError3(String messageId, Object arg1, Object arg2, Object arg3) {
        return Context.reportRuntimeError(Context.getMessage3(messageId, arg1, arg2, arg3));
    }

    public static EvaluatorException reportRuntimeError(String message) {
        int[] linep = new int[]{0};
        String filename = Context.getSourcePositionFromStack(linep);
        return Context.reportRuntimeError(message, filename, linep[0], null, 0);
    }

    public Scriptable initStandardObjects(ScriptableObject scope) {
        return this.initStandardObjects(scope, false);
    }

    public ScriptableObject initStandardObjects(ScriptableObject scope, boolean sealed) {
        if (scope == null) {
            scope = new NativeObject();
        }
        BaseFunction.init(this, scope, sealed);
        NativeObject.init(this, scope, sealed);
        Scriptable objectProto = ScriptableObject.getObjectPrototype(scope);
        Scriptable functionProto = ScriptableObject.getFunctionPrototype(scope);
        functionProto.setPrototype(objectProto);
        if (scope.getPrototype() == null) {
            scope.setPrototype(objectProto);
        }
        NativeError.init(this, scope, sealed);
        NativeGlobal.init(this, scope, sealed);
        NativeArray.init(this, scope, sealed);
        NativeString.init(this, scope, sealed);
        NativeBoolean.init(this, scope, sealed);
        NativeNumber.init(this, scope, sealed);
        NativeDate.init(this, scope, sealed);
        NativeMath.init(this, scope, sealed);
        NativeWith.init(this, scope, sealed);
        NativeCall.init(this, scope, sealed);
        NativeScript.init(this, scope, sealed);
        new LazilyLoadedCtor(scope, "RegExp", "org.mozilla.javascript.regexp.NativeRegExp", sealed);
        new LazilyLoadedCtor(scope, "Packages", "org.mozilla.javascript.NativeJavaPackage", sealed);
        new LazilyLoadedCtor(scope, "java", "org.mozilla.javascript.NativeJavaPackage", sealed);
        new LazilyLoadedCtor(scope, "getClass", "org.mozilla.javascript.NativeJavaPackage", sealed);
        new LazilyLoadedCtor(scope, "JavaClass", "org.mozilla.javascript.NativeJavaClass", sealed);
        String adapterClass = "org.mozilla.javascript.JavaAdapter";
        String adapterProperty = "JavaAdapter";
        try {
            adapterClass = System.getProperty(adapterClass, adapterClass);
            adapterProperty = System.getProperty("org.mozilla.javascript.JavaAdapterClassName", adapterProperty);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        new LazilyLoadedCtor(scope, adapterProperty, adapterClass, sealed);
        return scope;
    }

    public static Object getUndefinedValue() {
        return Undefined.instance;
    }

    public Object evaluateString(Scriptable scope, String source, String sourceName, int lineno, Object securityDomain) throws JavaScriptException {
        try {
            StringReader in = new StringReader(source);
            return this.evaluateReader(scope, in, sourceName, lineno, securityDomain);
        }
        catch (IOException ioe) {
            throw new RuntimeException();
        }
    }

    public Object evaluateReader(Scriptable scope, Reader in, String sourceName, int lineno, Object securityDomain) throws IOException, JavaScriptException {
        Script script = this.compileReader(scope, in, sourceName, lineno, securityDomain);
        if (script != null) {
            return script.exec(this, scope);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean stringIsCompilableUnit(String source) {
        StringReader in = new StringReader(source);
        TokenStream ts = new TokenStream(in, null, null, 1);
        ErrorReporter currentReporter = this.setErrorReporter(new DefaultErrorReporter());
        boolean errorseen = false;
        try {
            Interpreter interp = this.getInterpreter();
            Parser p = interp.createParser(ts, null, null);
            p.parse(ts);
        }
        catch (IOException ioe) {
            errorseen = true;
        }
        catch (EvaluatorException ee) {
            errorseen = true;
        }
        finally {
            this.setErrorReporter(currentReporter);
        }
        return !errorseen || !ts.eof();
    }

    public Script compileReader(Scriptable scope, Reader in, String sourceName, int lineno, Object securityDomain) throws IOException {
        return (Script)this.compile(scope, in, sourceName, lineno, securityDomain, false);
    }

    public Function compileFunction(Scriptable scope, String source, String sourceName, int lineno, Object securityDomain) {
        StringReader in = new StringReader(source);
        try {
            return (Function)this.compile(scope, in, sourceName, lineno, securityDomain, true);
        }
        catch (IOException ioe) {
            throw new RuntimeException();
        }
    }

    public String decompileScript(Script script, Scriptable scope, int indent) {
        NativeScript ns = (NativeScript)script;
        ns.initScript(scope);
        return ns.decompile(this, indent, false);
    }

    public String decompileFunction(Function fun, int indent) {
        if (fun instanceof BaseFunction) {
            return ((BaseFunction)fun).decompile(this, indent, false);
        }
        return "function " + fun.getClassName() + "() {\n\t[native code]\n}\n";
    }

    public String decompileFunctionBody(Function fun, int indent) {
        if (fun instanceof BaseFunction) {
            return ((BaseFunction)fun).decompile(this, indent, true);
        }
        return "[native code]\n";
    }

    public Scriptable newObject(Scriptable scope) throws PropertyException, NotAFunctionException, JavaScriptException {
        return this.newObject(scope, "Object", null);
    }

    public Scriptable newObject(Scriptable scope, String constructorName) throws PropertyException, NotAFunctionException, JavaScriptException {
        return this.newObject(scope, constructorName, null);
    }

    public Scriptable newObject(Scriptable scope, String constructorName, Object[] args) throws PropertyException, NotAFunctionException, JavaScriptException {
        Object ctorVal = ScriptRuntime.getTopLevelProp(scope, constructorName);
        if (ctorVal == Scriptable.NOT_FOUND) {
            String message = Context.getMessage1("msg.ctor.not.found", constructorName);
            throw new PropertyException(message);
        }
        if (!(ctorVal instanceof Function)) {
            String message = Context.getMessage1("msg.not.ctor", constructorName);
            throw new NotAFunctionException(message);
        }
        Function ctor = (Function)ctorVal;
        return ctor.construct(this, ctor.getParentScope(), args == null ? ScriptRuntime.emptyArgs : args);
    }

    public Scriptable newArray(Scriptable scope, int length) {
        NativeArray result = new NativeArray(length);
        this.newArrayHelper(scope, result);
        return result;
    }

    public Scriptable newArray(Scriptable scope, Object[] elements) {
        NativeArray result = new NativeArray(elements);
        this.newArrayHelper(scope, result);
        return result;
    }

    public Object[] getElements(Scriptable object) {
        double doubleLen = NativeArray.getLengthProperty(object);
        if (doubleLen != doubleLen) {
            return null;
        }
        int len = (int)doubleLen;
        Object[] result = new Object[len];
        for (int i = 0; i < len; ++i) {
            Object elem = object.get(i, object);
            result[i] = elem == Scriptable.NOT_FOUND ? Undefined.instance : elem;
        }
        return result;
    }

    public static boolean toBoolean(Object value) {
        return ScriptRuntime.toBoolean(value);
    }

    public static double toNumber(Object value) {
        return ScriptRuntime.toNumber(value);
    }

    public static String toString(Object value) {
        return ScriptRuntime.toString(value);
    }

    public static Scriptable toObject(Object value, Scriptable scope) {
        return ScriptRuntime.toObject(scope, value, null);
    }

    public static Scriptable toObject(Object value, Scriptable scope, Class staticType) {
        if (value == null && staticType != null) {
            return null;
        }
        return ScriptRuntime.toObject(scope, value, staticType);
    }

    public static Object toType(Object value, Class desiredType) throws IllegalArgumentException {
        return NativeJavaObject.coerceType(desiredType, value, false);
    }

    public boolean isGeneratingDebug() {
        return this.generatingDebug;
    }

    public void setGeneratingDebug(boolean generatingDebug) {
        this.generatingDebugChanged = true;
        if (generatingDebug && this.getOptimizationLevel() > 0) {
            this.setOptimizationLevel(-1);
        }
        this.generatingDebug = generatingDebug;
    }

    public boolean isGeneratingSource() {
        return this.generatingSource;
    }

    public void setGeneratingSource(boolean generatingSource) {
        this.generatingSource = generatingSource;
    }

    public int getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public void setOptimizationLevel(int optimizationLevel) {
        if (optimizationLevel < -2) {
            optimizationLevel = -2;
        } else if (optimizationLevel > 9) {
            optimizationLevel = 9;
        }
        if (optimizationLevel >= 0 && codegenClass == null) {
            optimizationLevel = -1;
        }
        this.optimizationLevel = optimizationLevel;
    }

    public String getClassName() {
        ClassNameHelper nameHelper = Context.getNameHelper();
        return nameHelper != null ? nameHelper.getClassName() : null;
    }

    public void setClassName(String className) {
        ClassNameHelper nameHelper = Context.getNameHelper();
        if (nameHelper != null) {
            nameHelper.setClassName(className);
        }
    }

    public String getTargetClassFileName() {
        ClassRepository repository;
        ClassNameHelper nameHelper = Context.getNameHelper();
        if (nameHelper != null && (repository = nameHelper.getClassRepository()) instanceof FileClassRepository) {
            return ((FileClassRepository)repository).getTargetClassFileName(nameHelper.getClassName());
        }
        return null;
    }

    public void setTargetClassFileName(String classFileName) {
        ClassNameHelper nameHelper = Context.getNameHelper();
        if (nameHelper != null) {
            if (classFileName != null) {
                nameHelper.setClassRepository(new FileClassRepository(classFileName));
            } else {
                nameHelper.setClassName(null);
            }
        }
    }

    public String getTargetPackage() {
        ClassNameHelper nameHelper = Context.getNameHelper();
        return nameHelper != null ? nameHelper.getTargetPackage() : null;
    }

    public void setTargetPackage(String targetPackage) {
        ClassNameHelper nameHelper = Context.getNameHelper();
        if (nameHelper != null) {
            nameHelper.setTargetPackage(targetPackage);
        }
    }

    public ClassRepository getClassRepository() {
        ClassNameHelper nameHelper = Context.getNameHelper();
        return nameHelper != null ? nameHelper.getClassRepository() : null;
    }

    public void setClassRepository(ClassRepository classRepository) {
        ClassNameHelper nameHelper = Context.getNameHelper();
        if (nameHelper != null) {
            nameHelper.setClassRepository(classRepository);
        }
    }

    public ClassOutput getClassOutput() {
        ClassRepository repository;
        ClassNameHelper nameHelper = Context.getNameHelper();
        if (nameHelper != null && (repository = nameHelper.getClassRepository()) != null && repository instanceof ClassOutputWrapper) {
            return ((ClassOutputWrapper)repository).classOutput;
        }
        return null;
    }

    public void setClassOutput(ClassOutput classOutput) {
        ClassNameHelper nameHelper = Context.getNameHelper();
        if (nameHelper != null) {
            if (classOutput != null) {
                nameHelper.setClassRepository(new ClassOutputWrapper(classOutput));
            } else {
                nameHelper.setClassRepository(null);
            }
        }
    }

    public synchronized void setSecuritySupport(SecuritySupport supportObj) {
        if (this.securitySupport != null) {
            throw new SecurityException("Cannot overwrite existing SecuritySupport object");
        }
        this.securitySupport = supportObj;
    }

    public static boolean isSecurityDomainRequired() {
        return requireSecurityDomain;
    }

    public Object getInterpreterSecurityDomain() {
        return this.interpreterSecurityDomain;
    }

    public Vector getInterpreterStackTrace() {
        return this.interpreterStackTrace;
    }

    public void setInterpreterStackTrace(Vector vec) {
        this.interpreterStackTrace = vec;
    }

    public boolean isInterpreterClass(Class cl) {
        return cl == (class$org$mozilla$javascript$Interpreter == null ? (class$org$mozilla$javascript$Interpreter = Context.class$("org.mozilla.javascript.Interpreter")) : class$org$mozilla$javascript$Interpreter);
    }

    public void setTargetExtends(Class extendsClass) {
        ClassNameHelper nameHelper = Context.getNameHelper();
        if (nameHelper != null) {
            nameHelper.setTargetExtends(extendsClass);
        }
    }

    public void setTargetImplements(Class[] implementsClasses) {
        ClassNameHelper nameHelper = Context.getNameHelper();
        if (nameHelper != null) {
            nameHelper.setTargetImplements(implementsClasses);
        }
    }

    public Object getThreadLocal(Object key) {
        if (this.hashtable == null) {
            return null;
        }
        return this.hashtable.get(key);
    }

    public void putThreadLocal(Object key, Object value) {
        if (this.hashtable == null) {
            this.hashtable = new Hashtable();
        }
        this.hashtable.put(key, value);
    }

    public void removeThreadLocal(Object key) {
        if (this.hashtable == null) {
            return;
        }
        this.hashtable.remove(key);
    }

    public boolean hasCompileFunctionsWithDynamicScope() {
        return this.compileFunctionsWithDynamicScopeFlag;
    }

    public void setCompileFunctionsWithDynamicScope(boolean flag) {
        this.compileFunctionsWithDynamicScopeFlag = flag;
    }

    public static void setCachingEnabled(boolean cachingEnabled) {
        if (isCachingEnabled && !cachingEnabled) {
            JavaMembers.classTable = new Hashtable();
            if (savedNameHelper != null) {
                savedNameHelper.reset();
            }
        }
        isCachingEnabled = cachingEnabled;
        FunctionObject.setCachingEnabled(cachingEnabled);
    }

    public void setWrapHandler(WrapHandler wrapHandler) {
        this.wrapHandler = wrapHandler;
    }

    public WrapHandler getWrapHandler() {
        return this.wrapHandler;
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public Object getDebuggerContextData() {
        return this.debuggerData;
    }

    public void setDebugger(Debugger debugger, Object contextData) {
        this.debugger = debugger;
        this.debuggerData = contextData;
    }

    public boolean hasFeature(int featureIndex) {
        switch (featureIndex) {
            case 1: {
                return this.version == 100 || this.version == 110 || this.version == 120;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
        }
        throw new IllegalArgumentException();
    }

    public int getInstructionObserverThreshold() {
        return this.instructionThreshold;
    }

    public void setInstructionObserverThreshold(int threshold) {
        this.instructionThreshold = threshold;
    }

    protected void observeInstructionCount(int instructionCount) {
    }

    public static String getMessage0(String messageId) {
        return Context.getMessage(messageId, null);
    }

    public static String getMessage1(String messageId, Object arg1) {
        Object[] arguments = new Object[]{arg1};
        return Context.getMessage(messageId, arguments);
    }

    public static String getMessage2(String messageId, Object arg1, Object arg2) {
        Object[] arguments = new Object[]{arg1, arg2};
        return Context.getMessage(messageId, arguments);
    }

    public static String getMessage3(String messageId, Object arg1, Object arg2, Object arg3) {
        Object[] arguments = new Object[]{arg1, arg2, arg3};
        return Context.getMessage(messageId, arguments);
    }

    static Context getContext() {
        Context cx = Context.getCurrentContext();
        if (cx == null) {
            throw new RuntimeException("No Context associated with current Thread");
        }
        return cx;
    }

    public static String getMessage(String messageId, Object[] arguments) {
        String formatString;
        Context cx = Context.getCurrentContext();
        Locale locale = cx != null ? cx.getLocale() : Locale.getDefault();
        ResourceBundle rb = ResourceBundle.getBundle(defaultResource, locale);
        try {
            formatString = rb.getString(messageId);
        }
        catch (MissingResourceException mre) {
            throw new RuntimeException("no message resource found for message property " + messageId);
        }
        MessageFormat formatter = new MessageFormat(formatString);
        return formatter.format(arguments);
    }

    private Object compile(Scriptable scope, Reader in, String sourceName, int lineno, Object securityDomain, boolean returnFunction) throws IOException {
        if (this.debugger != null && in != null) {
            in = new DebugReader(in);
        }
        TokenStream ts = new TokenStream(in, scope, sourceName, lineno);
        return this.compile(scope, ts, securityDomain, in, returnFunction);
    }

    private static ClassNameHelper getNameHelper() {
        if (savedNameHelper != null) {
            return savedNameHelper;
        }
        if (codegenClass == null) {
            return null;
        }
        try {
            Class<?> nameHelperClass = Class.forName("org.mozilla.javascript.optimizer.OptClassNameHelper");
            savedNameHelper = (ClassNameHelper)nameHelperClass.newInstance();
            return savedNameHelper;
        }
        catch (ClassNotFoundException x) {
            return null;
        }
        catch (IllegalAccessException x) {
            return null;
        }
        catch (InstantiationException x) {
            return null;
        }
    }

    private Interpreter getInterpreter() {
        int i = -(this.optimizationLevel + 1);
        try {
            Class<?> c = Class.forName(interpreterClassNames[i]);
            return (Interpreter)c.newInstance();
        }
        catch (Exception e) {
            throw new Error("fix me!: can't load interpreter class: " + e);
        }
    }

    private Interpreter getCompiler() {
        if (codegenClass != null) {
            try {
                return (Interpreter)codegenClass.newInstance();
            }
            catch (SecurityException x) {
            }
            catch (IllegalArgumentException x) {
            }
            catch (InstantiationException x) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return this.getInterpreter();
    }

    private Object compile(Scriptable scope, TokenStream ts, Object securityDomain, Reader in, boolean returnFunction) throws IOException {
        Interpreter compiler = this.optimizationLevel < 0 ? this.getInterpreter() : this.getCompiler();
        ClassNameHelper nameHelper = this.optimizationLevel < 0 ? null : Context.getNameHelper();
        this.errorCount = 0;
        Parser p = compiler.createParser(ts, nameHelper, scope);
        Node tree = (Node)p.parse(ts);
        if (tree == null) {
            return null;
        }
        tree = compiler.transform(tree, ts, scope);
        if (returnFunction) {
            Node first = tree.getFirstChild();
            if (first == null) {
                return null;
            }
            tree = (Node)first.getProp(5);
            if (tree == null) {
                return null;
            }
        }
        if (in instanceof DebugReader) {
            DebugReader dr = (DebugReader)in;
            tree.putProp(31, dr.getSaved());
        }
        Object result = compiler.compile(this, scope, tree, securityDomain, this.securitySupport, nameHelper);
        return this.errorCount == 0 ? result : null;
    }

    public static String getSourcePositionFromStack(int[] linep) {
        Context cx = Context.getCurrentContext();
        if (cx == null) {
            return null;
        }
        if (cx.interpreterLine > 0 && cx.interpreterSourceFile != null) {
            linep[0] = cx.interpreterLine;
            return cx.interpreterSourceFile;
        }
        CharArrayWriter writer = new CharArrayWriter();
        RuntimeException re = new RuntimeException();
        re.printStackTrace(new PrintWriter(writer));
        String s = writer.toString();
        int open = -1;
        int close = -1;
        int colon = -1;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ':') {
                colon = i;
                continue;
            }
            if (c == '(') {
                open = i;
                continue;
            }
            if (c == ')') {
                close = i;
                continue;
            }
            if (c != '\n' || open == -1 || close == -1 || colon == -1 || open >= colon || colon >= close) continue;
            String fileStr = s.substring(open + 1, colon);
            if (!fileStr.endsWith(".java")) {
                String lineStr = s.substring(colon + 1, close);
                try {
                    linep[0] = Integer.parseInt(lineStr);
                    return fileStr;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            colon = -1;
            close = -1;
            open = -1;
        }
        return null;
    }

    RegExpProxy getRegExpProxy() {
        if (this.regExpProxy == null) {
            try {
                Class<?> c = Class.forName("org.mozilla.javascript.regexp.RegExpImpl");
                this.regExpProxy = (RegExpProxy)c.newInstance();
                return this.regExpProxy;
            }
            catch (ClassNotFoundException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return this.regExpProxy;
    }

    private void newArrayHelper(Scriptable scope, Scriptable array) {
        array.setParentScope(scope);
        Object ctor = ScriptRuntime.getTopLevelProp(scope, "Array");
        if (ctor != null && ctor instanceof Scriptable) {
            Scriptable s = (Scriptable)ctor;
            array.setPrototype((Scriptable)s.get("prototype", s));
        }
    }

    final boolean isVersionECMA1() {
        return this.version == 0 || this.version >= 130;
    }

    Object getSecurityDomainFromClass(Class cl) {
        if (cl == (class$org$mozilla$javascript$Interpreter == null ? (class$org$mozilla$javascript$Interpreter = Context.class$("org.mozilla.javascript.Interpreter")) : class$org$mozilla$javascript$Interpreter)) {
            return this.interpreterSecurityDomain;
        }
        return this.securitySupport.getSecurityDomain(cl);
    }

    SecuritySupport getSecuritySupport() {
        return this.securitySupport;
    }

    public Object getSecurityDomainForStackDepth(int depth) {
        Class[] classes;
        Object result = null;
        if (this.securitySupport != null && (classes = this.securitySupport.getClassContext()) != null) {
            if (depth != -1) {
                int depth1 = depth + 1;
                result = this.getSecurityDomainFromClass(classes[depth1]);
            } else {
                for (int i = 1; i < classes.length && (result = this.getSecurityDomainFromClass(classes[i])) == null; ++i) {
                }
            }
        }
        if (result != null) {
            return result;
        }
        if (requireSecurityDomain) {
            Context.checkSecurityDomainRequired();
        }
        return null;
    }

    public static final void checkSecurityDomainRequired() {
        if (requireSecurityDomain) {
            String msg = "Required security context not found";
            if (resourceMissing) {
                msg = msg + ". Didn't find properties file at org.mozilla.javascript.resources.Security";
            }
            throw new SecurityException(msg);
        }
    }

    public boolean isGeneratingDebugChanged() {
        return this.generatingDebugChanged;
    }

    public void addActivationName(String name) {
        if (this.activationNames == null) {
            this.activationNames = new Hashtable(5);
        }
        this.activationNames.put(name, name);
    }

    public boolean isActivationNeeded(String name) {
        if ("arguments".equals(name)) {
            return true;
        }
        return this.activationNames != null && this.activationNames.containsKey(name);
    }

    public void removeActivationName(String name) {
        if (this.activationNames != null) {
            this.activationNames.remove(name);
        }
    }

    static void codeBug() {
        throw new RuntimeException("FAILED ASSERTION");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            codegenClass = Class.forName("org.mozilla.javascript.optimizer.Codegen");
        }
        catch (ClassNotFoundException x) {
            codegenClass = null;
        }
        interpreterClassNames = new String[]{"org.mozilla.javascript.Interpreter", "org.mozilla.javascript.continuations.ContinuationInterpreter"};
        requireSecurityDomain = true;
        resourceMissing = false;
        try {
            ResourceBundle rb = ResourceBundle.getBundle(securityResourceName);
            String s = rb.getString("security.requireSecurityDomain");
            requireSecurityDomain = s.equals("true");
        }
        catch (MissingResourceException mre) {
            requireSecurityDomain = true;
            resourceMissing = true;
        }
        catch (SecurityException se) {
            requireSecurityDomain = true;
        }
        isCachingEnabled = true;
        threadContexts = new Hashtable(11);
    }

    private static class ClassOutputWrapper
    implements ClassRepository {
        ClassOutput classOutput;

        ClassOutputWrapper(ClassOutput classOutput) {
            this.classOutput = classOutput;
        }

        public boolean storeClass(String name, byte[] bytes, boolean tl) throws IOException {
            OutputStream out = this.classOutput.getOutputStream(name, tl);
            out.write(bytes);
            out.close();
            return true;
        }
    }

    private class FileClassRepository
    implements ClassRepository {
        String generatingDirectory;

        FileClassRepository(String classFileName) {
            String initialName;
            int lastSeparator = classFileName.lastIndexOf(File.separatorChar);
            if (lastSeparator == -1) {
                this.generatingDirectory = null;
                initialName = classFileName;
            } else {
                this.generatingDirectory = classFileName.substring(0, lastSeparator);
                initialName = classFileName.substring(lastSeparator + 1);
            }
            if (initialName.endsWith(".class")) {
                initialName = initialName.substring(0, initialName.length() - 6);
            }
            Context.getNameHelper().setClassName(initialName);
        }

        public boolean storeClass(String className, byte[] bytes, boolean tl) throws IOException {
            String targetPackage = Context.getNameHelper().getTargetPackage();
            if (targetPackage != null && targetPackage.length() > 0 && className.startsWith(targetPackage + ".")) {
                className = className.substring(targetPackage.length() + 1);
            }
            FileOutputStream out = new FileOutputStream(this.getTargetClassFileName(className));
            out.write(bytes);
            out.close();
            return false;
        }

        String getTargetClassFileName(String className) {
            StringBuffer sb = new StringBuffer();
            if (this.generatingDirectory != null) {
                sb.append(this.generatingDirectory);
                sb.append(File.separator);
            }
            sb.append(className);
            sb.append(".class");
            return sb.toString();
        }
    }
}

