/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.NativeJavaPackage;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ImporterTopLevel
extends ScriptableObject {
    static /* synthetic */ Class class$org$mozilla$javascript$ImporterTopLevel;

    public ImporterTopLevel() {
        this.init();
    }

    public ImporterTopLevel(Context cx) {
        cx.initStandardObjects(this);
        this.init();
    }

    private void init() {
        String[] names = new String[]{"importClass", "importPackage"};
        try {
            this.defineFunctionProperties(names, class$org$mozilla$javascript$ImporterTopLevel == null ? (class$org$mozilla$javascript$ImporterTopLevel = ImporterTopLevel.class$("org.mozilla.javascript.ImporterTopLevel")) : class$org$mozilla$javascript$ImporterTopLevel, 2);
        }
        catch (PropertyException e) {
            throw new Error();
        }
    }

    public String getClassName() {
        return "global";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String name, Scriptable start) {
        Object[] elements;
        Object result = super.get(name, start);
        if (result != Scriptable.NOT_FOUND) {
            return result;
        }
        if (name.equals("_packages_")) {
            return result;
        }
        Object plist = ScriptableObject.getProperty(start, "_packages_");
        if (plist == Scriptable.NOT_FOUND) {
            return result;
        }
        Context cx = Context.enter();
        try {
            elements = cx.getElements((Scriptable)plist);
        }
        finally {
            Context.exit();
        }
        for (int i = 0; i < elements.length; ++i) {
            NativeJavaPackage p = (NativeJavaPackage)elements[i];
            Object v = p.getPkgProperty(name, start, false);
            if (v == null || v instanceof NativeJavaPackage) continue;
            if (result == Scriptable.NOT_FOUND) {
                result = v;
                continue;
            }
            throw Context.reportRuntimeError2("msg.ambig.import", result.toString(), v.toString());
        }
        return result;
    }

    public static void importClass(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        for (int i = 0; i < args.length; ++i) {
            Object cl = args[i];
            if (!(cl instanceof NativeJavaClass)) {
                throw Context.reportRuntimeError1("msg.not.class", Context.toString(cl));
            }
            String s = ((NativeJavaClass)cl).getClassObject().getName();
            String n = s.substring(s.lastIndexOf(46) + 1);
            Object val = thisObj.get(n, thisObj);
            if (val != Scriptable.NOT_FOUND && val != cl) {
                throw Context.reportRuntimeError1("msg.prop.defined", n);
            }
            thisObj.put(n, thisObj, cl);
        }
    }

    public static void importPackage(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Scriptable importedPackages;
        Object plist = thisObj.get("_packages_", thisObj);
        if (plist == Scriptable.NOT_FOUND) {
            importedPackages = cx.newArray(thisObj, 0);
            thisObj.put("_packages_", thisObj, (Object)importedPackages);
        } else {
            importedPackages = (Scriptable)plist;
        }
        for (int i = 0; i < args.length; ++i) {
            Object pkg = args[i];
            if (!(pkg instanceof NativeJavaPackage)) {
                throw Context.reportRuntimeError1("msg.not.pkg", Context.toString(pkg));
            }
            Object[] elements = cx.getElements(importedPackages);
            for (int j = 0; j < elements.length; ++j) {
                if (pkg != elements[j]) continue;
                pkg = null;
                break;
            }
            if (pkg == null) continue;
            importedPackages.put(elements.length, importedPackages, pkg);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

