/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.debug.DebuggableScript;

public class InterpretedFunction
extends NativeFunction
implements DebuggableScript,
Serializable {
    static final long serialVersionUID = -6235150451107527319L;
    public InterpreterData itsData;

    public InterpretedFunction(Context cx, InterpreterData theData, String[] argNames, short argCount) {
        this.itsData = theData;
        this.argNames = argNames;
        this.argCount = argCount;
        this.init(cx);
    }

    public void init(Context cx) {
        this.functionName = this.itsData.itsName;
        this.source = this.itsData.itsSource;
        this.nestedFunctions = this.itsData.itsNestedFunctions;
        if (cx != null) {
            this.version = (short)cx.getLanguageVersion();
        }
    }

    public InterpretedFunction(InterpretedFunction theOther, Scriptable theScope, Context cx) {
        this.itsData = theOther.itsData;
        this.argNames = theOther.argNames;
        this.argCount = theOther.argCount;
        this.itsClosure = theScope;
        this.init(cx);
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        return Interpreter.interpret(cx, scope, thisObj, args, this, this.itsData);
    }

    public boolean isFunction() {
        return true;
    }

    public Scriptable getScriptable() {
        return this;
    }

    public String getSourceName() {
        return this.itsData.itsSourceFile;
    }

    public int[] getLineNumbers() {
        return this.itsData.itsLineNumberTable.getKeys();
    }

    public boolean placeBreakpoint(int line) {
        return this.itsData.placeBreakpoint(line);
    }

    public boolean removeBreakpoint(int line) {
        return this.itsData.removeBreakpoint(line);
    }
}

