/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;

public class Monitor
extends ScriptableObject {
    Object monitor;
    static final Object[] emptyArgs = new Object[0];

    public String getClassName() {
        return "Monitor";
    }

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws JavaScriptException {
        Monitor result = new Monitor();
        if (args.length > 0) {
            Object arg = args[0];
            if (arg instanceof Wrapper) {
                arg = ((Wrapper)arg).unwrap();
            }
            result.monitor = arg;
        } else {
            result.monitor = result;
        }
        if (!inNewExpr) {
            Scriptable topScope = ScriptableObject.getTopLevelScope(ctorObj);
            result.setParentScope(topScope);
            result.setPrototype(ScriptableObject.getClassPrototype(topScope, result.getClassName()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void jsFunction_wait(Context cx, Scriptable scope, Scriptable thisObj, Scriptable funObj, Object[] args) throws JavaScriptException {
        try {
            if (!(thisObj instanceof Monitor)) {
                throw new JavaScriptException((Object)"wait called on non-monitor");
            }
            Monitor mon = (Monitor)thisObj;
            if (args.length < 1 || !(args[0] instanceof Function)) {
                return;
            }
            Function fun = (Function)args[0];
            Object object = mon.monitor;
            synchronized (object) {
                Object result;
                boolean bool;
                while (bool = Context.toBoolean(result = fun.call(cx, scope, scope, emptyArgs))) {
                    mon.monitor.wait();
                }
            }
        }
        catch (Exception e) {
            throw WrappedException.wrapException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jsFunction_notify() throws JavaScriptException {
        try {
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.notify();
            }
        }
        catch (Exception e) {
            throw WrappedException.wrapException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jsFunction_notifyAll() throws JavaScriptException {
        try {
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.notifyAll();
            }
        }
        catch (Exception e) {
            throw WrappedException.wrapException(e);
        }
    }
}

