/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class NativeJavaClass
extends NativeJavaObject
implements Function {
    private Hashtable fieldAndMethods;
    private Scriptable parent;

    public NativeJavaClass() {
    }

    public NativeJavaClass(Scriptable scope, Class cl) {
        super(scope, (Object)cl, JavaMembers.lookupClass(scope, cl, cl));
        this.fieldAndMethods = this.members.getFieldAndMethodsObjects(this, this.javaObject, true);
    }

    public String getClassName() {
        return "JavaClass";
    }

    public boolean has(String name, Scriptable start) {
        if (this.members == null) {
            return false;
        }
        return this.members.has(name, true);
    }

    public Object get(String name, Scriptable start) {
        Object result = Scriptable.NOT_FOUND;
        if (this.fieldAndMethods != null && (result = this.fieldAndMethods.get(name)) != null) {
            return result;
        }
        if (this.members.has(name, true)) {
            result = this.members.get(this, name, this.javaObject, true);
        } else {
            try {
                String nestedName = this.getClassObject().getName() + '$' + name;
                Class nestedClass = ScriptRuntime.loadClassName(nestedName);
                NativeJavaClass nestedValue = NativeJavaClass.wrap(ScriptableObject.getTopLevelScope(this), nestedClass);
                nestedValue.setParentScope(this);
                result = nestedValue;
            }
            catch (ClassNotFoundException ex) {
                throw this.members.reportMemberNotFound(name);
            }
            catch (IllegalArgumentException e) {
                throw this.members.reportMemberNotFound(name);
            }
        }
        return result;
    }

    public void put(String name, Scriptable start, Object value) {
        if (this.members != null) {
            this.members.put(this, name, this.javaObject, value, true);
        }
    }

    public Object[] getIds() {
        if (this.members != null) {
            return this.members.getIds(true);
        }
        return new Object[0];
    }

    public Class getClassObject() {
        return (Class)super.unwrap();
    }

    public static NativeJavaClass wrap(Scriptable scope, Class cls) {
        return new NativeJavaClass(scope, cls);
    }

    public Object getDefaultValue(Class hint) {
        if (hint == null || hint == ScriptRuntime.StringClass) {
            return this.toString();
        }
        if (hint == ScriptRuntime.BooleanClass) {
            return Boolean.TRUE;
        }
        if (hint == ScriptRuntime.NumberClass) {
            return ScriptRuntime.NaNobj;
        }
        return this;
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        Class c = this.getClassObject();
        if (c == null) {
            return Undefined.instance;
        }
        if (args.length == 1 && args[0] instanceof Scriptable) {
            Scriptable p = (Scriptable)args[0];
            do {
                Object o;
                if (!(p instanceof Wrapper) || !c.isInstance(o = ((Wrapper)((Object)p)).unwrap())) continue;
                return p;
            } while ((p = p.getPrototype()) != null);
        }
        return this.construct(cx, scope, args);
    }

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws JavaScriptException {
        if (args.length < 1) {
            return Undefined.instance;
        }
        Object arg = args[0];
        if (arg instanceof Wrapper) {
            arg = ((Wrapper)arg).unwrap();
        }
        if (!(arg instanceof Class)) {
            return Undefined.instance;
        }
        Scriptable scope = ScriptableObject.getTopLevelScope(ctorObj);
        NativeJavaClass result = new NativeJavaClass(scope, (Class)arg);
        result.setPrototype(ScriptableObject.getClassPrototype(scope, "JavaClass"));
        return result;
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args) throws JavaScriptException {
        String msg;
        Class classObject;
        block5: {
            classObject = this.getClassObject();
            int modifiers = classObject.getModifiers();
            if (!Modifier.isInterface(modifiers) && !Modifier.isAbstract(modifiers)) {
                Member[] ctors = this.members.getConstructors();
                Member member = NativeJavaMethod.findFunction(ctors, args);
                Constructor ctor = (Constructor)member;
                if (ctor == null) {
                    String sig = NativeJavaMethod.scriptSignature(args);
                    throw Context.reportRuntimeError2("msg.no.java.ctor", classObject.getName(), sig);
                }
                return NativeJavaClass.constructSpecific(cx, scope, this, ctor, args);
            }
            Scriptable topLevel = ScriptableObject.getTopLevelScope(this);
            msg = "";
            try {
                Object v = topLevel.get("JavaAdapter", topLevel);
                if (v != Scriptable.NOT_FOUND) {
                    Function f = (Function)v;
                    Object[] adapterArgs = new Object[]{this, args[0]};
                    return f.construct(cx, topLevel, adapterArgs);
                }
            }
            catch (Exception ex) {
                String m = ex.getMessage();
                if (m == null) break block5;
                msg = m;
            }
        }
        throw Context.reportRuntimeError2("msg.cant.instantiate", msg, classObject.getName());
    }

    public static Scriptable constructSpecific(Context cx, Scriptable scope, Scriptable thisObj, Constructor ctor, Object[] args) throws JavaScriptException {
        Scriptable topLevel = ScriptableObject.getTopLevelScope(thisObj);
        Class classObject = ctor.getDeclaringClass();
        Class<?>[] paramTypes = ctor.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            args[i] = NativeJavaObject.coerceType(paramTypes[i], args[i], true);
        }
        try {
            return (Scriptable)NativeJavaObject.wrap(topLevel, ctor.newInstance(args), classObject);
        }
        catch (InstantiationException instEx) {
            throw Context.reportRuntimeError2("msg.cant.instantiate", instEx.getMessage(), classObject.getName());
        }
        catch (IllegalArgumentException argEx) {
            String signature = NativeJavaMethod.scriptSignature(args);
            String ctorString = ctor.toString();
            throw Context.reportRuntimeError3("msg.bad.ctor.sig", argEx.getMessage(), ctorString, signature);
        }
        catch (InvocationTargetException e) {
            throw JavaScriptException.wrapException(scope, e);
        }
        catch (IllegalAccessException accessEx) {
            throw Context.reportRuntimeError1("msg.java.internal.private", accessEx.getMessage());
        }
    }

    public String toString() {
        return "[JavaClass " + this.getClassObject().getName() + "]";
    }

    public boolean hasInstance(Scriptable value) {
        if (value instanceof Wrapper && !(value instanceof NativeJavaClass)) {
            Object instance = ((Wrapper)((Object)value)).unwrap();
            return this.getClassObject().isInstance(instance);
        }
        return false;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.parent);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.parent = (Scriptable)in.readObject();
        this.fieldAndMethods = this.members.getFieldAndMethodsObjects(this, this.javaObject, true);
    }
}

