/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Vector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.LocalVariable;
import org.mozilla.javascript.ObjToIntMap;

public class VariableTable {
    protected Vector itsVariables = new Vector();
    private ObjToIntMap itsVariableNames = new ObjToIntMap(11);
    protected int varStart;

    public int size() {
        return this.itsVariables.size();
    }

    public int getParameterCount() {
        return this.varStart;
    }

    public LocalVariable createLocalVariable(String name, boolean isParameter) {
        return new LocalVariable(name, isParameter);
    }

    public LocalVariable getVariable(int index) {
        return (LocalVariable)this.itsVariables.elementAt(index);
    }

    public LocalVariable getVariable(String name) {
        int vIndex = this.itsVariableNames.get(name, -1);
        if (vIndex != -1) {
            return (LocalVariable)this.itsVariables.elementAt(vIndex);
        }
        return null;
    }

    public int getOrdinal(String name) {
        return this.itsVariableNames.get(name, -1);
    }

    public String getName(int index) {
        return ((LocalVariable)this.itsVariables.elementAt(index)).getName();
    }

    public String[] getAllNames() {
        int N = this.size();
        String[] result = null;
        if (N != 0) {
            result = new String[N];
            for (int i = 0; i != N; ++i) {
                result[i] = this.getName(i);
            }
        }
        return result;
    }

    public void establishIndices() {
        for (int i = 0; i < this.itsVariables.size(); ++i) {
            LocalVariable lVar = (LocalVariable)this.itsVariables.elementAt(i);
            lVar.setIndex(i);
        }
    }

    public void addParameter(String pName) {
        int pIndex = this.itsVariableNames.get(pName, -1);
        if (pIndex != -1) {
            LocalVariable p = (LocalVariable)this.itsVariables.elementAt(pIndex);
            if (p.isParameter()) {
                String message = Context.getMessage1("msg.dup.parms", pName);
                Context.reportWarning(message, null, 0, null, 0);
            } else {
                this.itsVariables.removeElementAt(pIndex);
            }
        }
        int curIndex = this.varStart++;
        LocalVariable lVar = this.createLocalVariable(pName, true);
        this.itsVariables.insertElementAt(lVar, curIndex);
        this.itsVariableNames.put(pName, curIndex);
    }

    public void addLocal(String vName) {
        int vIndex = this.itsVariableNames.get(vName, -1);
        if (vIndex != -1) {
            return;
        }
        int index = this.itsVariables.size();
        LocalVariable lVar = this.createLocalVariable(vName, false);
        this.itsVariables.addElement(lVar);
        this.itsVariableNames.put(vName, index);
    }

    public void removeLocal(String name) {
        int i = this.itsVariableNames.get(name, -1);
        if (i != -1) {
            this.itsVariables.removeElementAt(i);
            this.itsVariableNames.remove(name);
            ObjToIntMap.Iterator iter = this.itsVariableNames.newIterator();
            iter.start();
            while (!iter.done()) {
                int v = iter.getValue();
                if (v > i) {
                    iter.setValue(v - 1);
                }
                iter.next();
            }
        }
    }
}

