/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.continuations;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.continuations.ContinuationInterpreter;
import org.mozilla.javascript.debug.DebugFrame;

public final class InterpreterState
implements Serializable {
    InterpreterState caller;
    int lock = 1;
    boolean ctor;
    Scriptable thisObj;
    Scriptable fnOrScript;
    Scriptable scope;
    int[] catchStack;
    int stackTop;
    int tryStackTop;
    int pc = 6;
    int lineno;
    InterpreterData theData;
    int maxVars;
    transient Object[] stack;
    transient double[] sDbl;
    transient Object[] vars;
    transient double[] varDbl;
    transient DebugFrame frame;
    static final int NO_LOCK = 1;
    static final int WRITE_LOCK = 2;
    static final int READ_LOCK = 4;

    public String toString() {
        return "" + System.identityHashCode(this) + ": pc=" + this.pc;
    }

    final int LOCAL_SHFT() {
        return this.theData.itsMaxVars;
    }

    final int TRY_SCOPE_SHFT() {
        return this.theData.itsMaxStack;
    }

    final void clearStack() {
        int i;
        int n = i = this.stackTop < 0 ? 0 : this.stackTop;
        while (i < this.theData.itsMaxStack) {
            this.stack[i] = null;
            ++i;
        }
    }

    InterpreterState() {
    }

    InterpreterState(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, NativeFunction fnOrScript, InterpreterData theData) {
        this.init(cx, scope, thisObj, args, fnOrScript, theData);
    }

    void init(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, NativeFunction fnOrScript, InterpreterData theData) {
        this.ctor = false;
        this.thisObj = thisObj;
        this.stackTop = -1;
        this.tryStackTop = 0;
        this.pc = 6;
        Scriptable undefined = Undefined.instance;
        if (this.theData != theData) {
            this.scope = scope;
            int maxStack = theData.itsMaxStack;
            int maxLocals = theData.itsMaxLocals;
            this.maxVars = fnOrScript.argNames == null ? 0 : fnOrScript.argNames.length;
            int maxTryDepth = theData.itsMaxTryDepth;
            boolean VAR_SHFT = false;
            int LOCAL_SHFT = this.maxVars;
            int TRY_SCOPE_SHFT = maxStack;
            this.fnOrScript = fnOrScript;
            this.theData = theData;
            this.stack = new Object[TRY_SCOPE_SHFT + maxTryDepth];
            this.sDbl = new double[TRY_SCOPE_SHFT];
            this.vars = new Object[this.maxVars + maxLocals];
            this.varDbl = new double[this.maxVars + maxLocals];
            if (this.maxVars != 0) {
                int i;
                int definedArgs = fnOrScript.argCount;
                if (definedArgs != 0) {
                    if (definedArgs > args.length) {
                        definedArgs = args.length;
                    }
                    for (i = 0; i != definedArgs; ++i) {
                        this.vars[i] = args[i];
                    }
                }
                for (i = definedArgs; i != this.maxVars; ++i) {
                    this.vars[i] = undefined;
                }
            }
            if (theData.itsNestedFunctions != null) {
                ContinuationInterpreter.initFunctionObjects(theData.itsNestedFunctions, scope);
            }
            if (maxTryDepth != 0) {
                this.catchStack = new int[maxTryDepth * 2];
            }
        } else {
            int i;
            this.fnOrScript = fnOrScript;
            int n = this.maxVars = fnOrScript.argNames == null ? 0 : fnOrScript.argNames.length;
            if (this.scope != scope) {
                this.scope = scope;
                if (theData.itsNestedFunctions != null) {
                    ContinuationInterpreter.initFunctionObjects(theData.itsNestedFunctions, scope);
                }
            }
            int maxStack = theData.itsMaxStack;
            for (i = 0; i < this.stack.length; ++i) {
                this.stack[i] = null;
            }
            if (this.maxVars != 0) {
                int definedArgs = fnOrScript.argCount;
                if (definedArgs != 0) {
                    if (definedArgs > args.length) {
                        definedArgs = args.length;
                    }
                    for (i = 0; i != definedArgs; ++i) {
                        this.vars[i] = args[i];
                    }
                }
                for (i = (int)definedArgs; i != this.maxVars; ++i) {
                    this.vars[i] = undefined;
                }
            }
        }
    }

    private int next(int pc) {
        byte[] iCode = this.theData.itsICode;
        return InterpreterState.nextPC(iCode, pc);
    }

    private static int nextPC(byte[] iCode, int pc) {
        block6: while (true) {
            int ic = iCode[pc] & 0xFF;
            switch (ic) {
                case 6: {
                    pc = ContinuationInterpreter.getTarget(iCode, pc + 1);
                    continue block6;
                }
                case 147: 
                case 149: {
                    pc += 3;
                    continue block6;
                }
                case 148: {
                    ++pc;
                    continue block6;
                }
                case 153: {
                    return -1;
                }
            }
            break;
        }
        return pc;
    }

    final int checkTail() {
        int pc;
        byte[] iCode = this.theData.itsICode;
        int pc0 = pc = this.pc;
        if (this.ctor || this.tryStackTop != 0) {
            iCode[pc0] = -3;
            return 253;
        }
        int ic = iCode[pc] & 0xFF;
        switch (ic) {
            case 253: 
            case 254: {
                return ic;
            }
        }
        return this.checkTail(pc0, pc, iCode, ic);
    }

    private int icode(byte[] iCode, int pc) {
        if (pc == -1) {
            return -1;
        }
        return iCode[pc] & 0xFF;
    }

    private int checkTail(int pc0, int pc, byte[] iCode, int ic) {
        pc = this.next(pc + 5);
        int slot = -1;
        int prev = -1;
        int result = 253;
        block8: while (pc != -1) {
            prev = ic;
            ic = this.icode(iCode, pc);
            switch (ic) {
                case 2: {
                    if (prev == 43) break;
                    break block8;
                }
                case 153: {
                    if (prev != 2 && prev != 43) break block8;
                    result = 254;
                    break block8;
                }
                case 57: {
                    if (prev == 43) {
                        ic = this.icode(iCode, pc = this.next(pc + 1));
                        if (ic != 152) break block8;
                        result = 254;
                        break block8;
                    }
                    if (prev == 73) break;
                    break block8;
                }
                case 72: {
                    int gslot = iCode[++pc] & 0xFF;
                    if (gslot == slot) break;
                    break block8;
                }
                case 73: {
                    slot = iCode[++pc] & 0xFF;
                    break;
                }
                case 5: {
                    result = 254;
                    break block8;
                }
                default: {
                    break block8;
                }
            }
            pc = this.next(pc + 1);
        }
        iCode[pc0] = (byte)result;
        return result;
    }

    public void setCaller(InterpreterState caller) {
        InterpreterState s = this;
        while (s.caller != null) {
            s = s.caller;
        }
        s.caller = caller;
    }

    public void construct(InterpreterState other) {
        InterpreterState caller = other.caller;
        InterpreterState callee = this;
        while (caller != null) {
            InterpreterState tmp = new InterpreterState();
            tmp.construct1(caller);
            callee.caller = tmp;
            callee = tmp;
            caller = caller.caller;
        }
        this.construct1(other);
    }

    public void construct1(InterpreterState other) {
        this.thisObj = other.thisObj;
        this.fnOrScript = other.fnOrScript;
        this.scope = other.scope;
        this.ctor = other.ctor;
        this.catchStack = (int[])(other.catchStack != null ? (int[])other.catchStack.clone() : null);
        this.stackTop = other.stackTop;
        this.tryStackTop = other.tryStackTop;
        this.pc = other.pc;
        this.lineno = other.lineno;
        this.theData = other.theData;
        this.maxVars = other.maxVars;
        this.sDbl = (double[])(other.sDbl != null ? (double[])other.sDbl.clone() : null);
        this.vars = other.vars;
        this.varDbl = other.varDbl;
        if (other.stack != null) {
            this.stack = new Object[other.stack.length];
            System.arraycopy(other.stack, 0, this.stack, 0, this.stackTop + 1);
            System.arraycopy(other.stack, this.theData.itsMaxStack, this.stack, this.theData.itsMaxStack, this.stack.length - this.theData.itsMaxStack);
        } else {
            this.stack = null;
        }
        this.frame = other.frame;
    }

    private void writeObject(ObjectOutputStream strm) throws IOException {
        Object[] tmp = (Object[])this.stack.clone();
        for (int i = 0; i < this.stack.length; ++i) {
            if (i > this.stackTop && i < this.theData.itsMaxStack) {
                tmp[i] = null;
                continue;
            }
            if (tmp[i] != ContinuationInterpreter.DBL_MRK) continue;
            tmp[i] = new Double(this.sDbl[i]);
        }
        Object[] tmp2 = (Object[])this.vars.clone();
        for (int i = 0; i < this.vars.length; ++i) {
            if (tmp2[i] != ContinuationInterpreter.DBL_MRK) continue;
            tmp2[i] = new Double(this.varDbl[i]);
        }
        strm.defaultWriteObject();
        strm.writeObject(tmp);
        strm.writeObject(tmp2);
    }

    private void readObject(ObjectInputStream strm) throws IOException, ClassNotFoundException {
        int i;
        strm.defaultReadObject();
        this.stack = (Object[])strm.readObject();
        this.sDbl = new double[this.stack.length];
        for (i = 0; i < this.stack.length; ++i) {
            if (!(this.stack[i] instanceof Double)) continue;
            this.sDbl[i] = (Double)this.stack[i];
            this.stack[i] = ContinuationInterpreter.DBL_MRK;
        }
        this.vars = (Object[])strm.readObject();
        this.varDbl = new double[this.vars.length];
        for (i = 0; i < this.vars.length; ++i) {
            if (!(this.vars[i] instanceof Double)) continue;
            this.varDbl[i] = (Double)this.vars[i];
            this.vars[i] = ContinuationInterpreter.DBL_MRK;
        }
    }

    public Object[] getArguments() {
        return null;
    }

    private InterpreterState shallowDuplicate() {
        InterpreterState newState = new InterpreterState();
        newState.construct1(this);
        newState.caller = this.caller;
        return newState;
    }

    synchronized InterpreterState writeLock() {
        InterpreterState result = this;
        switch (this.lock) {
            case 1: {
                break;
            }
            case 4: {
                if (this.caller != null) {
                    this.caller.readLock();
                }
                result = this.shallowDuplicate();
                break;
            }
            case 2: {
                throw new Error("writeLock(): encountered WRITE_LOCK");
            }
        }
        result.lock = 2;
        return result;
    }

    synchronized void readLock() {
        switch (this.lock) {
            case 1: {
                this.lock = 4;
                break;
            }
            case 4: {
                break;
            }
            case 2: {
                throw new Error("readLock(): encountered WRITE_LOCK");
            }
        }
    }

    synchronized void writeUnlock() {
        switch (this.lock) {
            case 1: {
                break;
            }
            case 2: {
                this.lock = 1;
                break;
            }
            case 4: {
                throw new Error("writeUnLock(): encountered READ_LOCK");
            }
        }
    }

    synchronized InterpreterState lockForSave() {
        if (this.getBreak() == 0) {
            return null;
        }
        InterpreterState result = this;
        switch (this.lock) {
            case 1: {
                break;
            }
            case 4: {
                result = this.shallowDuplicate();
                break;
            }
            case 2: {
                throw new Error("lockForSave(): encountered WRITE_LOCK");
            }
        }
        return result;
    }

    synchronized InterpreterState lockForReturn() {
        if (this.getReturn() == 0) {
            return null;
        }
        InterpreterState result = this;
        switch (this.lock) {
            case 1: {
                break;
            }
            case 4: {
                result = this.shallowDuplicate();
                break;
            }
            case 2: {
                throw new Error("lockForSave(): encountered WRITE_LOCK");
            }
        }
        return result;
    }

    synchronized InterpreterState lockForRestore() {
        if (this.getContinue() == 0) {
            return null;
        }
        InterpreterState result = this;
        switch (this.lock) {
            case 1: {
                break;
            }
            case 4: {
                result = this.shallowDuplicate();
                break;
            }
            case 2: {
                throw new Error("lockForRestore(): encountered WRITE_LOCK");
            }
        }
        return result;
    }

    int getContinue() {
        byte[] iCode = this.theData.itsICode;
        int beforeTarget = ContinuationInterpreter.getShort(iCode, 0);
        int ic = iCode[beforeTarget = InterpreterState.nextPC(iCode, beforeTarget)] & 0xFF;
        return ic != 249 ? beforeTarget : 0;
    }

    int getBreak() {
        byte[] iCode = this.theData.itsICode;
        int afterTarget = ContinuationInterpreter.getShort(iCode, 2);
        int ic = iCode[afterTarget = InterpreterState.nextPC(iCode, afterTarget)] & 0xFF;
        return ic != 248 ? afterTarget : 0;
    }

    int getReturn() {
        byte[] iCode = this.theData.itsICode;
        int retTarget = ContinuationInterpreter.getShort(iCode, 4);
        int ic = iCode[retTarget = InterpreterState.nextPC(iCode, retTarget)] & 0xFF;
        return ic != 247 ? retTarget : 0;
    }

    static InterpreterState save(Context cx, InterpreterState state) throws JavaScriptException {
        InterpreterState s = state;
        InterpreterState result = null;
        InterpreterState caller_ = null;
        while (s != null) {
            InterpreterState tmp = s;
            if ((s = s.lockForSave()) == null) {
                if (result == null) {
                    result = tmp;
                }
                caller_ = tmp;
                s = tmp.caller;
                continue;
            }
            if (result == null) {
                result = s;
            }
            if (caller_ != null) {
                caller_.caller = s;
            }
            caller_ = s;
            s = s.caller;
        }
        s = result;
        while (s != null) {
            int afterTarget = s.getBreak();
            if (afterTarget != 0) {
                if (s.lock != 1) {
                    throw new Error("save: " + s.lock);
                }
                int savepc = s.pc;
                s.pc = afterTarget;
                --s.stackTop;
                ContinuationInterpreter.interpret(cx, s, true);
                ++s.stackTop;
                s.pc = savepc;
                s.writeUnlock();
            }
            s = s.caller;
        }
        result.readLock();
        return result;
    }

    static InterpreterState restore(Context cx, InterpreterState state) throws JavaScriptException {
        InterpreterState s = state;
        InterpreterState result = null;
        InterpreterState caller_ = null;
        while (s != null) {
            InterpreterState tmp = s;
            if ((s = s.lockForRestore()) == null) {
                if (result == null) {
                    result = tmp;
                }
                caller_ = tmp;
                s = tmp.caller;
                continue;
            }
            if (result == null) {
                result = s;
            }
            if (caller_ != null) {
                caller_.caller = s;
            }
            caller_ = s;
            s = s.caller;
        }
        s = result;
        while (s != null) {
            int beforeTarget = s.getContinue();
            if (beforeTarget != 0) {
                if (s.lock != 1) {
                    throw new Error("restore: " + s.lock);
                }
                int savepc = s.pc;
                s.pc = beforeTarget;
                --s.stackTop;
                ContinuationInterpreter.interpret(cx, s, true);
                ++s.stackTop;
                s.pc = savepc;
                s.writeUnlock();
            }
            s = s.caller;
        }
        return result;
    }

    static InterpreterState terminate(Context cx, InterpreterState state) throws JavaScriptException {
        InterpreterState s = state;
        InterpreterState result = null;
        InterpreterState caller_ = null;
        while (s != null) {
            InterpreterState tmp = s;
            if ((s = s.lockForReturn()) == null) {
                if (result == null) {
                    result = tmp;
                }
                caller_ = tmp;
                s = tmp.caller;
                continue;
            }
            if (result == null) {
                result = s;
            }
            if (caller_ != null) {
                caller_.caller = s;
            }
            caller_ = s;
            s = s.caller;
        }
        s = result;
        while (s != null) {
            int retTarget = s.getReturn();
            if (retTarget != 0) {
                if (s.lock != 1) {
                    throw new Error("return: " + s.lock);
                }
                int savepc = s.pc;
                s.pc = retTarget;
                --s.stackTop;
                ContinuationInterpreter.interpret(cx, s, true);
                ++s.stackTop;
                s.pc = savepc;
                s.writeUnlock();
            }
            s = s.caller;
        }
        result.readLock();
        return result;
    }
}

