/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Vector;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.VariableTable;
import org.mozilla.javascript.optimizer.CSEHolder;
import org.mozilla.javascript.optimizer.DataFlowBitSet;
import org.mozilla.javascript.optimizer.FatBlock;
import org.mozilla.javascript.optimizer.OptFunctionNode;
import org.mozilla.javascript.optimizer.OptLocalVariable;

public class Block {
    private IRFactory itsIRFactory;
    private Block[] itsSuccessors;
    private Block[] itsPredecessors;
    private int itsStartNodeIndex;
    private int itsEndNodeIndex;
    private Node[] itsStatementNodes;
    private int itsBlockID;
    private DataFlowBitSet itsLiveOnEntrySet;
    private DataFlowBitSet itsLiveOnExitSet;
    private DataFlowBitSet itsUseBeforeDefSet;
    private DataFlowBitSet itsNotDefSet;

    public Block(int startNodeIndex, int endNodeIndex, Node[] statementNodes) {
        this.itsStartNodeIndex = startNodeIndex;
        this.itsEndNodeIndex = endNodeIndex;
        this.itsStatementNodes = statementNodes;
    }

    public void setBlockID(int id) {
        this.itsBlockID = id;
    }

    public int getBlockID() {
        return this.itsBlockID;
    }

    public Node getStartNode() {
        return this.itsStatementNodes[this.itsStartNodeIndex];
    }

    public Node getEndNode() {
        return this.itsStatementNodes[this.itsEndNodeIndex];
    }

    public Block[] getPredecessorList() {
        return this.itsPredecessors;
    }

    public Block[] getSuccessorList() {
        return this.itsSuccessors;
    }

    public static Block[] buildBlocks(Node[] statementNodes) {
        FatBlock fb;
        int i;
        Hashtable<Node, FatBlock> theTargetBlocks = new Hashtable<Node, FatBlock>();
        Vector<FatBlock> theBlocks = new Vector<FatBlock>();
        int beginNodeIndex = 0;
        block4: for (i = 0; i < statementNodes.length; ++i) {
            switch (statementNodes[i].getType()) {
                case 137: {
                    if (i == beginNodeIndex) continue block4;
                    fb = new FatBlock(beginNodeIndex, i - 1, statementNodes);
                    if (statementNodes[beginNodeIndex].getType() == 137) {
                        theTargetBlocks.put(statementNodes[beginNodeIndex], fb);
                    }
                    theBlocks.addElement(fb);
                    beginNodeIndex = i;
                    continue block4;
                }
                case 6: 
                case 7: 
                case 8: {
                    fb = new FatBlock(beginNodeIndex, i, statementNodes);
                    if (statementNodes[beginNodeIndex].getType() == 137) {
                        theTargetBlocks.put(statementNodes[beginNodeIndex], fb);
                    }
                    theBlocks.addElement(fb);
                    beginNodeIndex = i + 1;
                }
            }
        }
        if (beginNodeIndex != statementNodes.length) {
            FatBlock fb2 = new FatBlock(beginNodeIndex, statementNodes.length - 1, statementNodes);
            if (statementNodes[beginNodeIndex].getType() == 137) {
                theTargetBlocks.put(statementNodes[beginNodeIndex], fb2);
            }
            theBlocks.addElement(fb2);
        }
        for (i = 0; i < theBlocks.size(); ++i) {
            fb = (FatBlock)theBlocks.elementAt(i);
            Node blockEndNode = fb.getEndNode();
            int blockEndNodeType = blockEndNode.getType();
            if (blockEndNodeType != 6 && i < theBlocks.size() - 1) {
                FatBlock fallThruTarget = (FatBlock)theBlocks.elementAt(i + 1);
                fb.addSuccessor(fallThruTarget);
                fallThruTarget.addPredecessor(fb);
            }
            if (blockEndNodeType != 8 && blockEndNodeType != 7 && blockEndNodeType != 6) continue;
            Node target = (Node)blockEndNode.getProp(1);
            FatBlock branchTargetBlock = (FatBlock)theTargetBlocks.get(target);
            target.putProp(23, branchTargetBlock.getSlimmerSelf());
            fb.addSuccessor(branchTargetBlock);
            branchTargetBlock.addPredecessor(fb);
        }
        Block[] result = new Block[theBlocks.size()];
        for (int i2 = 0; i2 < theBlocks.size(); ++i2) {
            FatBlock fb3 = (FatBlock)theBlocks.elementAt(i2);
            result[i2] = fb3.diet();
            result[i2].setBlockID(i2);
        }
        return result;
    }

    public static String toString(Block[] blockList, Node[] statementNodes) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(blockList.length + " Blocks");
        for (int i = 0; i < blockList.length; ++i) {
            int j;
            Block b = blockList[i];
            pw.println("#" + b.itsBlockID);
            pw.println("from " + b.itsStartNodeIndex + " " + statementNodes[b.itsStartNodeIndex].toString());
            pw.println("thru " + b.itsEndNodeIndex + " " + statementNodes[b.itsEndNodeIndex].toString());
            pw.print("Predecessors ");
            if (b.itsPredecessors != null) {
                for (j = 0; j < b.itsPredecessors.length; ++j) {
                    pw.print(b.itsPredecessors[j].getBlockID() + " ");
                }
                pw.println();
            } else {
                pw.println("none");
            }
            pw.print("Successors ");
            if (b.itsSuccessors != null) {
                for (j = 0; j < b.itsSuccessors.length; ++j) {
                    pw.print(b.itsSuccessors[j].getBlockID() + " ");
                }
                pw.println();
                continue;
            }
            pw.println("none");
        }
        return sw.toString();
    }

    void lookForVariablesAndCalls(Node n, boolean[] liveSet, VariableTable theVariables) {
        switch (n.getType()) {
            case 73: {
                Node lhs = n.getFirstChild();
                Node rhs = lhs.getNextSibling();
                this.lookForVariablesAndCalls(rhs, liveSet, theVariables);
                Object theVarProp = n.getProp(24);
                if (theVarProp == null) break;
                int theVarIndex = ((OptLocalVariable)theVarProp).getIndex();
                liveSet[theVarIndex] = true;
                break;
            }
            case 43: {
                for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.lookForVariablesAndCalls(child, liveSet, theVariables);
                }
                for (int i = 0; i < liveSet.length; ++i) {
                    if (!liveSet[i]) continue;
                    ((OptLocalVariable)theVariables.getVariable(i)).markLiveAcrossCall();
                }
                break;
            }
            case 72: {
                Object theVarProp = n.getProp(24);
                if (theVarProp == null) break;
                int theVarIndex = ((OptLocalVariable)theVarProp).getIndex();
                if (n.getProp(25) == null || this.itsLiveOnExitSet.test(theVarIndex)) break;
                liveSet[theVarIndex] = false;
                break;
            }
            default: {
                for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.lookForVariablesAndCalls(child, liveSet, theVariables);
                }
            }
        }
    }

    void markAnyTypeVariables(VariableTable theVariables) {
        for (int i = 0; i < theVariables.size(); ++i) {
            if (!this.itsLiveOnEntrySet.test(i)) continue;
            ((OptLocalVariable)theVariables.getVariable(i)).assignType(3);
        }
    }

    void markVolatileVariables(VariableTable theVariables) {
        int i;
        boolean[] liveSet = new boolean[theVariables.size()];
        for (i = 0; i < liveSet.length; ++i) {
            liveSet[i] = this.itsLiveOnEntrySet.test(i);
        }
        for (i = this.itsStartNodeIndex; i <= this.itsEndNodeIndex; ++i) {
            Node n = this.itsStatementNodes[i];
            this.lookForVariablesAndCalls(n, liveSet, theVariables);
        }
    }

    void lookForVariableAccess(Node n, Node[] lastUse) {
        switch (n.getType()) {
            case 106: 
            case 107: {
                Object theVarProp;
                Node child = n.getFirstChild();
                if (child.getType() != 72 || (theVarProp = child.getProp(24)) == null) break;
                int theVarIndex = ((OptLocalVariable)theVarProp).getIndex();
                if (!this.itsNotDefSet.test(theVarIndex)) {
                    this.itsUseBeforeDefSet.set(theVarIndex);
                }
                this.itsNotDefSet.set(theVarIndex);
                break;
            }
            case 73: {
                Node lhs = n.getFirstChild();
                Node rhs = lhs.getNextSibling();
                this.lookForVariableAccess(rhs, lastUse);
                Object theVarProp = n.getProp(24);
                if (theVarProp == null) break;
                int theVarIndex = ((OptLocalVariable)theVarProp).getIndex();
                this.itsNotDefSet.set(theVarIndex);
                if (lastUse[theVarIndex] == null) break;
                lastUse[theVarIndex].putProp(25, theVarProp);
                break;
            }
            case 72: {
                Object theVarProp = n.getProp(24);
                if (theVarProp == null) break;
                int theVarIndex = ((OptLocalVariable)theVarProp).getIndex();
                if (!this.itsNotDefSet.test(theVarIndex)) {
                    this.itsUseBeforeDefSet.set(theVarIndex);
                }
                lastUse[theVarIndex] = n;
                break;
            }
            default: {
                for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.lookForVariableAccess(child, lastUse);
                }
            }
        }
    }

    public void initLiveOnEntrySets(VariableTable theVariables) {
        int i;
        int listLength = theVariables.size();
        Node[] lastUse = new Node[listLength];
        this.itsUseBeforeDefSet = new DataFlowBitSet(listLength);
        this.itsNotDefSet = new DataFlowBitSet(listLength);
        this.itsLiveOnEntrySet = new DataFlowBitSet(listLength);
        this.itsLiveOnExitSet = new DataFlowBitSet(listLength);
        for (i = this.itsStartNodeIndex; i <= this.itsEndNodeIndex; ++i) {
            Node n = this.itsStatementNodes[i];
            this.lookForVariableAccess(n, lastUse);
        }
        for (i = 0; i < listLength; ++i) {
            if (lastUse[i] == null) continue;
            lastUse[i].putProp(25, this);
        }
        this.itsNotDefSet.not();
    }

    boolean doReachedUseDataFlow() {
        this.itsLiveOnExitSet.clear();
        if (this.itsSuccessors != null) {
            for (int i = 0; i < this.itsSuccessors.length; ++i) {
                this.itsLiveOnExitSet.or(this.itsSuccessors[i].itsLiveOnEntrySet);
            }
        }
        return this.itsLiveOnEntrySet.df2(this.itsLiveOnExitSet, this.itsUseBeforeDefSet, this.itsNotDefSet);
    }

    int findExpressionType(Node n) {
        Node child;
        switch (n.getType()) {
            case 45: {
                return 1;
            }
            case 30: 
            case 43: {
                return 0;
            }
            case 41: {
                return 3;
            }
            case 72: {
                OptLocalVariable theVar = (OptLocalVariable)n.getProp(24);
                if (theVar != null) {
                    return theVar.getTypeUnion();
                }
            }
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 106: 
            case 107: {
                return 1;
            }
            case 23: {
                Node child2 = n.getFirstChild();
                int lType = this.findExpressionType(child2);
                int rType = this.findExpressionType(child2.getNextSibling());
                return lType | rType;
            }
        }
        if (child == null) {
            return 3;
        }
        int result = 0;
        for (child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
            result |= this.findExpressionType(child);
        }
        return result;
    }

    boolean findDefPoints(Node n) {
        boolean result = false;
        switch (n.getType()) {
            default: {
                for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
                    result |= this.findDefPoints(child);
                }
                break;
            }
            case 106: 
            case 107: {
                Node firstChild = n.getFirstChild();
                OptLocalVariable theVar = (OptLocalVariable)firstChild.getProp(24);
                if (theVar == null) break;
                result |= theVar.assignType(1);
                break;
            }
            case 40: {
                Node baseChild = n.getFirstChild();
                Node nameChild = baseChild.getNextSibling();
                Node rhs = nameChild.getNextSibling();
                if (baseChild != null) {
                    OptLocalVariable theVar;
                    if (baseChild.getType() == 72 && (theVar = (OptLocalVariable)baseChild.getProp(24)) != null) {
                        theVar.assignType(3);
                    }
                    result |= this.findDefPoints(baseChild);
                }
                if (nameChild != null) {
                    result |= this.findDefPoints(nameChild);
                }
                if (rhs == null) break;
                result |= this.findDefPoints(rhs);
                break;
            }
            case 73: {
                Node firstChild = n.getFirstChild();
                OptLocalVariable theVar = (OptLocalVariable)n.getProp(24);
                if (theVar == null) break;
                Node rValue = firstChild.getNextSibling();
                int theType = this.findExpressionType(rValue);
                result |= theVar.assignType(theType);
            }
        }
        return result;
    }

    void localCSE(Node parent, Node n, Hashtable theCSETable, OptFunctionNode theFunction) {
        switch (n.getType()) {
            default: {
                for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.localCSE(n, child, theCSETable, theFunction);
                }
                break;
            }
            case 106: 
            case 107: {
                Node child = n.getFirstChild();
                if (child.getType() == 39) {
                    Node nameChild = child.getFirstChild().getNextSibling();
                    if (nameChild.getType() == 46) {
                        theCSETable.remove(nameChild.getString());
                        break;
                    }
                    theCSETable.clear();
                    break;
                }
                if (child.getType() == 72) break;
                theCSETable.clear();
                break;
            }
            case 40: {
                Node baseChild = n.getFirstChild();
                Node nameChild = baseChild.getNextSibling();
                Node rhs = nameChild.getNextSibling();
                if (baseChild != null) {
                    this.localCSE(n, baseChild, theCSETable, theFunction);
                }
                if (nameChild != null) {
                    this.localCSE(n, nameChild, theCSETable, theFunction);
                }
                if (rhs != null) {
                    this.localCSE(n, rhs, theCSETable, theFunction);
                }
                if (nameChild.getType() == 46) {
                    theCSETable.remove(nameChild.getString());
                    break;
                }
                theCSETable.clear();
                break;
            }
            case 39: {
                Node theCSE;
                Node nameChild;
                Node baseChild = n.getFirstChild();
                if (baseChild != null) {
                    this.localCSE(n, baseChild, theCSETable, theFunction);
                }
                if (baseChild.getType() != 109 || baseChild.getInt() != 50 || (nameChild = baseChild.getNextSibling()).getType() != 46) break;
                String theName = nameChild.getString();
                Object cse = theCSETable.get(theName);
                if (cse == null) {
                    theCSETable.put(theName, new CSEHolder(parent, n));
                    break;
                }
                if (parent == null) break;
                if (cse instanceof CSEHolder) {
                    CSEHolder cseHolder = (CSEHolder)cse;
                    Node nextChild = cseHolder.getPropChild.getNextSibling();
                    cseHolder.getPropParent.removeChild(cseHolder.getPropChild);
                    theCSE = this.itsIRFactory.createNewLocal(cseHolder.getPropChild);
                    theFunction.incrementLocalCount();
                    if (nextChild == null) {
                        cseHolder.getPropParent.addChildToBack(theCSE);
                    } else {
                        cseHolder.getPropParent.addChildBefore(theCSE, nextChild);
                    }
                    theCSETable.put(theName, theCSE);
                } else {
                    theCSE = (Node)cse;
                }
                Node nextChild = n.getNextSibling();
                parent.removeChild(n);
                Node cseUse = this.itsIRFactory.createUseLocal(theCSE);
                if (nextChild == null) {
                    parent.addChildToBack(cseUse);
                    break;
                }
                parent.addChildBefore(cseUse, nextChild);
                break;
            }
            case 42: {
                Node lhsBase = n.getFirstChild();
                Node lhsIndex = lhsBase.getNextSibling();
                Node rhs = lhsIndex.getNextSibling();
                if (lhsBase != null) {
                    this.localCSE(n, lhsBase, theCSETable, theFunction);
                }
                if (lhsIndex != null) {
                    this.localCSE(n, lhsIndex, theCSETable, theFunction);
                }
                if (rhs != null) {
                    this.localCSE(n, rhs, theCSETable, theFunction);
                }
                theCSETable.clear();
                break;
            }
            case 43: {
                for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.localCSE(n, child, theCSETable, theFunction);
                }
                theCSETable.clear();
            }
        }
    }

    Hashtable localCSE(Hashtable theCSETable, OptFunctionNode theFunction) {
        this.itsIRFactory = new IRFactory(null, null);
        if (theCSETable == null) {
            theCSETable = new Hashtable(5);
        }
        for (int i = this.itsStartNodeIndex; i <= this.itsEndNodeIndex; ++i) {
            Node n = this.itsStatementNodes[i];
            if (n == null) continue;
            this.localCSE(null, n, theCSETable, theFunction);
        }
        return theCSETable;
    }

    void findDefs() {
        for (int i = this.itsStartNodeIndex; i <= this.itsEndNodeIndex; ++i) {
            Node n = this.itsStatementNodes[i];
            if (n == null) continue;
            this.findDefPoints(n);
        }
    }

    public boolean doTypeFlow() {
        boolean changed = false;
        for (int i = this.itsStartNodeIndex; i <= this.itsEndNodeIndex; ++i) {
            Node n = this.itsStatementNodes[i];
            if (n == null) continue;
            changed |= this.findDefPoints(n);
        }
        return changed;
    }

    public boolean isLiveOnEntry(int index) {
        return this.itsLiveOnEntrySet != null && this.itsLiveOnEntrySet.test(index);
    }

    public void printLiveOnEntrySet(PrintWriter pw, VariableTable theVariables) {
        for (int i = 0; i < theVariables.size(); ++i) {
            if (this.itsUseBeforeDefSet.test(i)) {
                pw.println(theVariables.getVariable(i).getName() + " is used before def'd");
            }
            if (this.itsNotDefSet.test(i)) {
                pw.println(theVariables.getVariable(i).getName() + " is not def'd");
            }
            if (this.itsLiveOnEntrySet.test(i)) {
                pw.println(theVariables.getVariable(i).getName() + " is live on entry");
            }
            if (!this.itsLiveOnExitSet.test(i)) continue;
            pw.println(theVariables.getVariable(i).getName() + " is live on exit");
        }
    }

    public void setSuccessorList(Block[] b) {
        this.itsSuccessors = b;
    }

    public void setPredecessorList(Block[] b) {
        this.itsPredecessors = b;
    }
}

