/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

class DataFlowBitSet {
    private int[] itsBits;
    int itsSize;

    DataFlowBitSet(int size) {
        this.itsSize = size;
        this.itsBits = new int[(size >> 5) + 1];
    }

    int size() {
        return this.itsSize;
    }

    void set(int n) {
        if (n < 0 || n >= this.itsSize) {
            throw new RuntimeException("DataFlowBitSet bad index " + n);
        }
        int n2 = n >> 5;
        this.itsBits[n2] = this.itsBits[n2] | 1 << (n & 0x1F);
    }

    boolean test(int n) {
        if (n < 0 || n >= this.itsSize) {
            throw new RuntimeException("DataFlowBitSet bad index " + n);
        }
        return (this.itsBits[n >> 5] & 1 << (n & 0x1F)) != 0;
    }

    void not() {
        int bitsLength = this.itsBits.length;
        for (int i = 0; i < bitsLength; ++i) {
            this.itsBits[i] = ~this.itsBits[i];
        }
    }

    void clear(int n) {
        if (n < 0 || n >= this.itsSize) {
            throw new RuntimeException("DataFlowBitSet bad index " + n);
        }
        int n2 = n >> 5;
        this.itsBits[n2] = this.itsBits[n2] & ~(1 << (n & 0x1F));
    }

    void clear() {
        int bitsLength = this.itsBits.length;
        for (int i = 0; i < bitsLength; ++i) {
            this.itsBits[i] = 0;
        }
    }

    void or(DataFlowBitSet b) {
        int bitsLength = this.itsBits.length;
        for (int i = 0; i < bitsLength; ++i) {
            int n = i;
            this.itsBits[n] = this.itsBits[n] | b.itsBits[i];
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("DataFlowBitSet, size = " + this.itsSize + "\n");
        for (int i = 0; i < this.itsBits.length; ++i) {
            result.append(Integer.toHexString(this.itsBits[i]) + " ");
        }
        return result.toString();
    }

    boolean df(DataFlowBitSet in, DataFlowBitSet gen, DataFlowBitSet notKill) {
        int bitsLength = this.itsBits.length;
        boolean changed = false;
        for (int i = 0; i < bitsLength; ++i) {
            int oldBits = this.itsBits[i];
            this.itsBits[i] = (in.itsBits[i] | gen.itsBits[i]) & notKill.itsBits[i];
            changed |= oldBits != this.itsBits[i];
        }
        return changed;
    }

    boolean df2(DataFlowBitSet in, DataFlowBitSet gen, DataFlowBitSet notKill) {
        int bitsLength = this.itsBits.length;
        boolean changed = false;
        for (int i = 0; i < bitsLength; ++i) {
            int oldBits = this.itsBits[i];
            this.itsBits[i] = in.itsBits[i] & notKill.itsBits[i] | gen.itsBits[i];
            changed |= oldBits != this.itsBits[i];
        }
        return changed;
    }
}

