/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.util.Enumeration;
import java.util.Hashtable;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.optimizer.Block;

public class FatBlock {
    private Hashtable itsSuccessors = new Hashtable(4);
    private Hashtable itsPredecessors = new Hashtable(4);
    private Block itsShadowOfFormerSelf;

    public FatBlock(int startNodeIndex, int endNodeIndex, Node[] statementNodes) {
        this.itsShadowOfFormerSelf = new Block(startNodeIndex, endNodeIndex, statementNodes);
    }

    public Node getEndNode() {
        return this.itsShadowOfFormerSelf.getEndNode();
    }

    public Block getSlimmerSelf() {
        return this.itsShadowOfFormerSelf;
    }

    private Block[] reduceToArray(Hashtable h) {
        Block[] result = null;
        if (!h.isEmpty()) {
            result = new Block[h.size()];
            Enumeration enumeration = h.elements();
            int i = 0;
            while (enumeration.hasMoreElements()) {
                FatBlock fb = (FatBlock)enumeration.nextElement();
                result[i++] = fb.itsShadowOfFormerSelf;
            }
        }
        return result;
    }

    Block diet() {
        this.itsShadowOfFormerSelf.setSuccessorList(this.reduceToArray(this.itsSuccessors));
        this.itsShadowOfFormerSelf.setPredecessorList(this.reduceToArray(this.itsPredecessors));
        return this.itsShadowOfFormerSelf;
    }

    public void addSuccessor(FatBlock b) {
        this.itsSuccessors.put(b, b);
    }

    public void addPredecessor(FatBlock b) {
        this.itsPredecessors.put(b, b);
    }
}

