/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.debugger.FileHeader;
import org.mozilla.javascript.tools.debugger.FileTextArea;
import org.mozilla.javascript.tools.debugger.LoadFile;
import org.mozilla.javascript.tools.debugger.Main;
import org.mozilla.javascript.tools.debugger.MessageDialogWrapper;

class FileWindow
extends JInternalFrame
implements ActionListener {
    Main db;
    FileTextArea textArea;
    FileHeader fileHeader;
    JScrollPane p;
    int currentPos;
    Hashtable breakpoints;
    String url;
    JLabel statusBar;

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (!cmd.equals("Cut")) {
            if (cmd.equals("Copy")) {
                this.textArea.copy();
            } else if (cmd.equals("Paste")) {
                // empty if block
            }
        }
    }

    public void dispose() {
        Enumeration e = this.breakpoints.keys();
        while (e.hasMoreElements()) {
            Integer line = (Integer)this.breakpoints.get(e.nextElement());
            this.db.clearBreakPoint(this.url, line);
        }
        this.db.removeWindow(this);
        super.dispose();
    }

    void runToCursor(ActionEvent e) {
        try {
            this.db.runToCursor(this.url, this.textArea.getLineOfOffset(this.textArea.getCaretPosition()) + 1, e);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    void load() {
        Scriptable scope = this.db.getScope();
        if (scope == null) {
            MessageDialogWrapper.showMessageDialog(this.db, "Can't load scripts: no scope available", "Run", 0);
        } else {
            String fileName = this.url;
            if (fileName != null) {
                new Thread(new LoadFile(this.db, scope, fileName)).start();
            }
        }
    }

    public int getPosition(int line) {
        int result = -1;
        try {
            result = this.textArea.getLineStartOffset(line);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return result;
    }

    boolean isBreakPoint(int line) {
        int pos = this.getPosition(line - 1);
        return this.breakpoints.get(new Integer(pos)) != null;
    }

    void toggleBreakPoint(int line) {
        int pos = this.getPosition(line - 1);
        Integer i = new Integer(pos);
        if (this.breakpoints.get(i) == null) {
            this.setBreakPoint(line);
        } else {
            this.clearBreakPoint(line);
        }
    }

    void setBreakPoint(int line) {
        int actualLine = this.db.setBreakPoint(this.url, line);
        if (actualLine != -1) {
            int pos = this.getPosition(actualLine - 1);
            this.breakpoints.put(new Integer(pos), new Integer(line));
            this.fileHeader.repaint();
        }
    }

    void clearBreakPoint(int line) {
        this.db.clearBreakPoint(this.url, line);
        int pos = this.getPosition(line - 1);
        Integer loc = new Integer(pos);
        if (this.breakpoints.get(loc) != null) {
            this.breakpoints.remove(loc);
            this.fileHeader.repaint();
        }
    }

    FileWindow(Main db, String fileName, String text) {
        super(new File(fileName).getName(), true, true, true, true);
        this.db = db;
        this.breakpoints = (Hashtable)db.breakpointsMap.get(fileName);
        if (this.breakpoints == null) {
            this.breakpoints = new Hashtable();
            db.breakpointsMap.put(fileName, this.breakpoints);
        }
        this.setUrl(fileName);
        this.currentPos = -1;
        this.textArea = new FileTextArea(this);
        this.textArea.setRows(24);
        this.textArea.setColumns(80);
        this.p = new JScrollPane();
        this.fileHeader = new FileHeader(this);
        this.p.setViewportView(this.textArea);
        this.p.setRowHeaderView(this.fileHeader);
        this.setContentPane(this.p);
        this.pack();
        this.setText(text);
        this.textArea.select(0);
    }

    public void setUrl(String fileName) {
        Component c = this.getComponent(1);
        if (c != null && c instanceof JComponent) {
            ((JComponent)c).setToolTipText(fileName);
        }
        this.url = fileName;
    }

    public String getUrl() {
        return this.url;
    }

    void setText(String newText) {
        if (!this.textArea.getText().equals(newText)) {
            this.textArea.setText(newText);
            int pos = 0;
            if (this.currentPos != -1) {
                pos = this.currentPos;
            }
            this.textArea.select(pos);
        }
        Enumeration e = this.breakpoints.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Integer line = (Integer)this.breakpoints.get(key);
            if (this.db.setBreakPoint(this.url, line) != -1) continue;
            this.breakpoints.remove(key);
        }
        this.fileHeader.update();
        this.fileHeader.repaint();
    }

    void setPosition(int pos) {
        this.textArea.select(pos);
        this.currentPos = pos;
        this.fileHeader.repaint();
    }

    void select(int start, int end) {
        int docEnd = this.textArea.getDocument().getLength();
        this.textArea.select(docEnd, docEnd);
        this.textArea.select(start, end);
    }
}

