/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.io.FileReader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.debugger.ContextData;
import org.mozilla.javascript.tools.debugger.Main;
import org.mozilla.javascript.tools.debugger.MessageDialogWrapper;

class LoadFile
implements Runnable {
    Scriptable scope;
    String fileName;
    Main db;

    LoadFile(Main db, Scriptable scope, String fileName) {
        this.scope = scope;
        this.fileName = fileName;
        this.db = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Context cx = Context.enter();
        ContextData contextData = ContextData.get(cx);
        contextData.breakNextLine = true;
        cx.setOptimizationLevel(this.db.getOptimizationLevel());
        try {
            cx.evaluateReader(this.scope, new FileReader(this.fileName), this.fileName, 1, null);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            String msg = exc.getMessage();
            if (exc instanceof EcmaError) {
                EcmaError err = (EcmaError)exc;
                msg = err.getSourceName() + ", line " + err.getLineNumber() + ": " + msg;
            }
            MessageDialogWrapper.showMessageDialog(this.db, msg, "Run", 0);
        }
        finally {
            cx.exit();
        }
    }
}

