<?xml version="1.0" encoding="UTF-8"?>
<!--Changes :
    2/2/2005 : retrait de Doc2HTML qui est traité dans le pipeline de la sitemap TestDoc= ajout des balises injacDoc/injacDocRender
-->
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:dir="http://apache.org/cocoon/directory/2.0"
	xmlns:collection="http://apache.org/cocoon/collection/1.0"
	exclude-result-prefixes="collection dir" 
>
	<!--xmlns:text="http://chaperon.sourceforge.net/schema/text/1.0"-->
   	<!--xsl:import href="../docbook-xsl-1.66.1/html/docbook.xsl" /-->
    <xsl:param name ="path" />
	<xsl:param name ="file" />
	<xsl:param name="baselink"/>
	<xsl:param name ="pdftypes" select="'txt xml html html'"/>
	<xsl:param name ="pdflink" select="'yes'"/>
	<xsl:variable name="filetype" select="substring-after($file, '.')" />
	
	<!-- pre-htmlized  documents-->	
	<xsl:template match="html|HTML">
		<div id="iDocRender">
			<!-- Documents avec conversion PDF -->
			<xsl:if test="$pdflink='yes' and not(starts-with($file, 'error-'))">	
				<xsl:if test="contains($pdftypes, $filetype)">
					<xsl:call-template name="insert-ToPDF-link"/>
				</xsl:if>
			</xsl:if>	
			<xsl:copy-of select="//body/*|//BODY/*"/>
		</div>
	</xsl:template>

	<xsl:template name="insert-ToPDF-link">
		<xsl:if test="$file != 'void.xml'">
		<div id="iDocToPDF">
			<a target="_blank" href="{$baselink}makepdf{$path}/{$file}.pdf" ><img alt="format PDF" height="16" width="16" border="0" src="{$baselink}_images/acrobat.gif" ></img></a>           
		</div>
		</xsl:if>
	</xsl:template>
	
	<!-- non-pre-htmlized documents -->
	<xsl:template match="*">
			<div style="left: 0px; top: 800px; z-index:5"><xsl:value-of select="name()"/></div>
            <xsl:choose>
			<!-- Documents avec conversion PDF -->
			<xsl:when test="$filetype='txt'">
				<div id="iDocRender">
					<xsl:call-template name="insert-ToPDF-link"/>
					<pre>
						<xsl:copy-of select="."/>
					</pre>
				</div>
			</xsl:when>
			<xsl:when test="$filetype='xml' and $file!='void.xml'">
				<div id="iDocRender">
					<xsl:call-template name="insert-ToPDF-link"/>		
					<xsl:copy-of select="."/>
				</div>
			</xsl:when>
			<xsl:when test="$filetype='html' or $filetype='htm'">
				<div id="iDocRender">
					<xsl:call-template name="insert-ToPDF-link"/>
                    <xsl:copy-of select="."/>
				</div>
			</xsl:when>
			<!-- Documents sans conversion PDF -->
			<xsl:when test="$filetype='jpg' or $filetype='gif' or $filetype='png' or $filetype='JPG' or $filetype='GIF' or $filetype='PNG'">
				<div id="iDocRender">
					<img src="res-{substring-after($path, '/')}/{$file}" alt="{$file}"/>
				</div>
			</xsl:when>
            <xsl:when test="$filetype='java'">
				<div id="iDocRender">
					<xsl:call-template name="insert-ToPDF-link"/>
					<xsl:copy-of select="."/>
				</div>
			</xsl:when>
			<xsl:otherwise>
				<div id="iDocRender">
					<xsl:call-template name="insert-ToPDF-link"/>
                    <xsl:copy-of select="."/>
				</div>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>

