<?xml version="1.0" encoding="iso-8859-1"?>
<!-- xmlns:dir="http://apache.org/cocoon/directory/2.0" -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
			      xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
     	<xsl:param name="sitemapAsBase" />
    	<xsl:param name="path" />
	<xsl:param name="baselink" />	
	<xsl:param name="user" />
	<xsl:param name="logoutURL" select="'logout'"/>		
	<!-- Elements du Header-->
	<xsl:template match="MDREP/skin/header">
		<!-- DEBUT HEADER -->	
    	<div id="header">        
			<xsl:apply-templates select="logos"/>
			<div id="headerlinks">
				<xsl:for-each select="links/link">
					<a href="{@href}" title="{@text}">
						<xsl:value-of select="@text"/>
					</a>
				</xsl:for-each>
			</div>	
		</div>	
		<!-- FIN HEADER -->	
		<xsl:choose>
			<xsl:when test="$user != ''">
				<div id="welcome">
		  			<i18n:text>Welcome</i18n:text>, <xsl:value-of select="$user"/> !
				</div>
				<div id="logout">
					<a href="{$baselink}logout" ><i18n:text><xsl:value-of select="@logout"/></i18n:text></a>
				</div>
			</xsl:when>
			<xsl:otherwise>
        		<div id="login">
               		<a  href="{$baselink}auth" ><i18n:text><xsl:value-of select="@login"/></i18n:text></a>
                   </div>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="logos">
		<xsl:for-each select="logo">
			<div id="{@id}">				
				<h1>
					<img  src="{$baselink}_images/{@src}" alt="{@alt}" width="{@width}" height="{@height}"/> 
				</h1>	
			</div>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>

