<!--?xml version="1.0" encoding="UTF-8"? -->
<!--DOCTYPE accents PUBLIC "-//ESUP//DTD Injac Accents v1.0//EN"
 "../../dtd/accents.dtd" --> 
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
								xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
	
	<xsl:param name="path" select="''"/>
	<xsl:param name="baselink"/>
	<xsl:param name="indexingURL" select="'../injac-indexing'"/>
	<!-- Outils injac -->
	
	<xsl:template match="tools">
    	<div id="tools">
        	<xsl:for-each select="tool">
				<div class="tool">
				<h2><i18n:text><xsl:value-of select="@text"/></i18n:text></h2>
				<xsl:choose>
	                <!-- Recherche -->	
					<xsl:when test="./@type = 'lucene'">
    					<form action="{$baselink}search">
							<input size="19" name="queryString" ></input>
							<input type="hidden" name="path" value="{$path}"></input>
	                    </form>
						<br></br>
        	            <a style="font-size:8pt" href="{$baselink}advsearch?path={$path}"><i18n:text>advanced search</i18n:text></a>                             
					</xsl:when>
				</xsl:choose>
				</div>
			</xsl:for-each>
		</div>
	</xsl:template>
	<!-- Annonces -->
	<xsl:template match="injacAnouncement">
	      <div id="iAnouncement">
			<div class="titre_annonce"><i18n:text>Anouncements</i18n:text></div>
			<xsl:apply-templates />
           		</div>
	</xsl:template>

	<!-- RSS -->
	<xsl:template match="injacRSS">
	      <div id="iRSS">
			<div class="titre_annonce"><i18n:text>Current events</i18n:text></div>
			<xsl:apply-templates />
           	</div>
	</xsl:template>


</xsl:stylesheet>

