<?xml version="1.0" encoding="UTF-8"?>   

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
	
    <xsl:output encoding="UTF-8"/>
    <xsl:include href="../../genskin/stylesheets/xsl/skin2html.xsl" />	
	<xsl:param name="path"/>
	<xsl:param name="file"/>
	<xsl:param name="upnode" /> 
	<xsl:param name="localURI"/>
	<xsl:param name="baselink" select="''"/>
	<xsl:param name="intdocs" select="'xml html htm txt jpg png gif XML HTML HTM TXT JPG PNG GIF'"/>
	<xsl:variable name="relpath">
		<xsl:choose>
			<xsl:when test="contains($path, $upnode)">
				<xsl:value-of select="substring-after($path, $upnode)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$path"/>
			</xsl:otherwise>
		</xsl:choose>	
	</xsl:variable>
	<xsl:variable name="context">
		<xsl:choose>
			<!-- extern rendering link (with filename appended)-->
			<xsl:when test="not(contains($intdocs, substring-after($file, '.')))">ext</xsl:when>
			<xsl:otherwise>nav</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="append-file">
		<xsl:choose>
			<!-- extern rendering link (with filename appended)-->
			<xsl:when test="not(contains($intdocs, substring-after($file, '.')))">/<xsl:value-of select="$file"/></xsl:when>
			<xsl:otherwise></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>	
	<xsl:template match="/page">
      	<html>
        	<head>
			<xsl:call-template name="MDREP" />
			<title>Injac - <xsl:value-of select="preview/@label"/></title>
        	</head>
		<body>
			
			<xsl:apply-templates select="preview"/>
			<xsl:apply-templates select="injacDoc|results|advsearch"/>
		</body> 
      	</html>
   	</xsl:template>
<!-- espace IDocRender -->    
    <!-- document -->    
	<xsl:template match="injacDoc">
        <xsl:copy-of select="./*"/>
    </xsl:template>
	
	<!-- espace IDocRender END -->     
	<xsl:template name="MDREP">
		<style type="text/css" media="all">@import "<xsl:value-of select="$baselink"/><xsl:value-of select="substring-before(/page/MDREP/@skinname,'xml')"/>css";</style>
	</xsl:template>
	
	
<xsl:template match="preview">
	<div id="card-div">
	<table width="100%" id="main-table">
	<thead>
		<tr>
			<th ><div class="card-title"> Injac - <xsl:value-of select="@label"/></div></th>
		</tr>
	</thead>
	<tbody>
	<tr>
	<td>
	<table bgcolor="{/page/MDREP/skin/card/infos/@bgcolor}"  width="{/page/MDREP/skin/card/infos/@width}" border="{/page/MDREP/skin/card/infos/@border}" cellpading="{/page/MDREP/skin/card/infos/@cellpading}" cellspacing="{/page/MDREP/skin/card/infos/@cellspacing}">
		<xsl:for-each select="*[name() != 'labels']">
		<tr><td class="names">
			<xsl:value-of select="@label"/>
		</td>
		<td class="values">
			<xsl:value-of select="."/>
		</td></tr>
		</xsl:for-each>
	</table>
	</td>
	<td>
		<table bgcolor="{/page/MDREP/skin/card/links-table/@bgcolor}">
		<tr><td><xsl:value-of select="labels/navlink"/> :</td></tr>
		<tr><td border="1" border-color="black" bgcolor="white"><a href="{$baselink}{$context}{$relpath}{$append-file}"><xsl:value-of select="concat($localURI,'/',$context,$relpath,$append-file)"/></a></td></tr>
		<xsl:choose>
			<xsl:when test="$append-file=''">
				<tr><td><xsl:value-of select="labels/doclink"/> :</td></tr>
				<tr><td border="1" border-color="black" bgcolor="white" ><a href="{$baselink}doc{$relpath}"><xsl:value-of select="concat($localURI,'/doc', $relpath)"/></a></td></tr>
			</xsl:when>
			<xsl:otherwise>
				<tr><td><xsl:value-of select="labels/doclink"/> :</td></tr>
				<tr><td border="1" border-color="black" bgcolor="white"><a href="{$baselink}{$context}{$relpath}{$append-file}"><xsl:value-of select="concat($localURI,'/',$context,$relpath,$append-file)"/></a></td></tr>
			</xsl:otherwise>	
		</xsl:choose>
		</table>
	</td>
	</tr>
	</tbody>
	</table>	
	</div>
</xsl:template>	
	
</xsl:stylesheet>

