<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:MD="http://esup-portail.org/injac"
	xmlns:fd="http://apache.org/cocoon/forms/1.0#definition"
	xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
	 <xsl:param name="path"/>
	 <xsl:key name="distinct-metadatas" match="MD:metadata" use="." />
	<xsl:template match="/">
		<fd:form>

			<fd:widgets>
				
				<fd:field id="searchfield" required="false">
					<fd:label>
						<i18n:text>field</i18n:text>
						:
					</fd:label>
					<fd:hint>
						<i18n:text>Choose a field to search</i18n:text>
					</fd:hint>
					<fd:datatype base="string" />
					<fd:selection-list>
						<fd:item value="by default">
							<fd:label>
								<i18n:text>by default</i18n:text>
							</fd:label>
						</fd:item>
						<fd:item value="body" />
						<xsl:apply-templates select="/MD:response/MD:metadatas[contains(@href,$path)]"/>
						
					</fd:selection-list>
					<fd:validation>
						<fd:length min="2" />
					</fd:validation>

				</fd:field>
				<fd:field id="searchfield2" required="false">
					<fd:label>
						<i18n:text>field</i18n:text>
						:
					</fd:label>
					<fd:hint>
						<i18n:text>Choose a field to search</i18n:text>
					</fd:hint>
					<fd:datatype base="string" />
					<fd:selection-list>
						<fd:item value="by default">
							<fd:label>
								<i18n:text>by default</i18n:text>
							</fd:label>
						</fd:item>
						<fd:item value="body" />
						<xsl:apply-templates select="/MD:response/MD:metadatas[contains(@href,$path)]"/>
						
					</fd:selection-list>
					<fd:validation>
						<fd:length min="2" />
					</fd:validation>
				</fd:field>
				<fd:field id="queryfield" required="false">
					<fd:label></fd:label>
					<fd:datatype base="string" />
					<fd:validation>
						<fd:length min="2" max="50" />
					</fd:validation>
				</fd:field>
				<fd:field id="queryfield2" required="false">
					<fd:label></fd:label>
					<fd:datatype base="string" />
					<fd:validation>
						<fd:length min="2" max="50" />
					</fd:validation>
				</fd:field>
				<fd:field id="fromfield" required="false">
					<fd:label>De</fd:label>
					<fd:datatype base="string" />
					<fd:validation>
						<fd:length min="2" max="50" />
					</fd:validation>
				</fd:field>
				<fd:field id="inclufield" required="false">
					<fd:label></fd:label>
					<fd:datatype base="string" />
					<fd:selection-list>
						<fd:item value="yes">
							<fd:label><i18n:text>included</i18n:text></fd:label>
						</fd:item>
						<fd:item value="no">
							<fd:label><i18n:text>excluded</i18n:text></fd:label>
						</fd:item>
					</fd:selection-list>
					<fd:validation>
						<fd:length min="2" max="50" />
					</fd:validation>
				</fd:field>
				<fd:field id="tofield" required="false">
					<fd:label><i18n:text>to</i18n:text></fd:label>
					<fd:datatype base="string" />
					<fd:validation>
						<fd:length min="2" max="50" />
					</fd:validation>
				</fd:field>
				<fd:field id="approxfield" required="false">
					<fd:label>Approximation</fd:label>
					<fd:datatype base="decimal" />
					<fd:selection-list>
						<fd:item value="0.5">
							<fd:label>
								<i18n:text>average</i18n:text>
							</fd:label>
						</fd:item>
						<fd:item value="1.0">
							<fd:label>
								<i18n:text>strict</i18n:text>
							</fd:label>
						</fd:item>
						<fd:item value="0.0">
							<fd:label>
								<i18n:text>wide</i18n:text>
							</fd:label>
						</fd:item>
					</fd:selection-list>
					<fd:validation>
						<fd:range min="0.0" max="1.0" />
					</fd:validation>
				</fd:field>
				<fd:field id="proximfield" required="false">
					<fd:label>
						<i18n:text>Distance</i18n:text>
					</fd:label>
					<fd:datatype base="integer" />
					<fd:selection-list>
						<fd:item value="1" />
						<fd:item value="2" />
						<fd:item value="3" />
						<fd:item value="5" />
						<fd:item value="10" />
						<fd:item value="15" />
						<fd:item value="50" />
						<fd:item value="100" />
						<fd:item value="200" />						
					</fd:selection-list>
					<fd:validation>
						<fd:range min="0" max="1000" />
					</fd:validation>
				</fd:field>
				<fd:field id="andorfield" required="false">
					<fd:label></fd:label>
					<fd:datatype base="string" />
					<fd:selection-list>
						<fd:item value="AND">
							<fd:label><i18n:text>AND</i18n:text></fd:label>
						</fd:item>	
						<fd:item value="OR">
							<fd:label><i18n:text>OR</i18n:text></fd:label>
						</fd:item>
						<fd:item value="NOT">
							<fd:label><i18n:text>NOT</i18n:text></fd:label>
						</fd:item>
					</fd:selection-list>
					<fd:validation>
						<fd:length min="2" max="3" />
					</fd:validation>
				</fd:field>
			</fd:widgets>
		</fd:form>

	</xsl:template>
	<xsl:template match="MD:metadatas">
		<xsl:for-each select="MD:metadata[generate-id()=generate-id(key('distinct-metadatas',.))]">
			<fd:item value="{.}">
				<fd:label><i18n:text><xsl:value-of select="."/></i18n:text></fd:label>
			</fd:item>	
		</xsl:for-each>	
	</xsl:template>
	
</xsl:stylesheet>