/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import oracle.net.nl.RepConversion;
import oracle.net.ns.NetException;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class Packet
implements SQLnetDef {
    private int buffer2send;
    protected int sdu;
    protected int tdu;
    protected int length;
    public int type;
    protected int flags;
    protected int dataLen;
    protected int dataOff;
    protected String data;
    protected byte[] buffer;
    protected byte[] header = new byte[8];
    public SessionAtts sAtts;

    public Packet(Packet packet) {
        this(packet.sAtts);
        this.length = packet.length;
        this.type = packet.type;
        this.flags = packet.flags;
        this.dataLen = packet.dataLen;
        this.dataOff = packet.dataOff;
        this.buffer = packet.buffer;
    }

    public Packet(SessionAtts sessionAtts) {
        this.sAtts = sessionAtts;
        this.sdu = sessionAtts.getSDU();
        this.tdu = sessionAtts.getTDU();
    }

    public Packet(SessionAtts sessionAtts, int n) {
        this(sessionAtts);
        this.createBuffer(n);
    }

    public Packet(SessionAtts sessionAtts, int n, int n2, int n3) {
        this(sessionAtts);
        this.createBuffer(n, n2, n3);
    }

    protected void createBuffer(int n) {
        this.buffer = new byte[n];
        this.buffer[0] = (byte)(n / 256);
        this.buffer[1] = (byte)(n % 256);
    }

    protected void createBuffer(int n, int n2, int n3) {
        this.buffer = new byte[n];
        this.buffer[0] = (byte)(n / 256);
        this.buffer[1] = (byte)(n % 256);
        this.buffer[5] = (byte)n3;
        this.buffer[4] = (byte)n2;
    }

    protected void dump(byte[] byArray, int n, int n2) {
        int n3 = 0;
        System.out.println("Packet dump");
        System.out.println("buffer.length=" + byArray.length);
        System.out.println("offset       =" + n);
        System.out.println("len          =" + n2);
        int n4 = n;
        while (n4 < n2) {
            System.out.print("|");
            int n5 = 0;
            while (n5 < 8 && n3 < n2 - 1) {
                n3 = n4 + n5;
                RepConversion.printInHex(byArray[n3]);
                System.out.print(" ");
                ++n5;
            }
            System.out.println("|");
            n4 += 8;
        }
        System.out.println("finish dump");
    }

    protected void extractData() throws IOException, NetException {
        if (this.dataLen <= 0) {
            this.data = new String();
        } else if (this.length > this.dataOff) {
            this.data = new String(this.buffer, 0, this.dataOff, this.dataLen);
        } else {
            byte[] byArray = new byte[this.dataLen];
            if (this.sAtts.nsInputStream.read(byArray) < 0) {
                throw new NetException(0);
            }
            this.data = new String(byArray, 0);
        }
    }

    protected String getData() {
        return this.data;
    }

    protected void receive() throws IOException, NetException {
        int n = 0;
        while (n < this.header.length) {
            if ((n += this.sAtts.ntInputStream.read(this.header, n, this.header.length - n)) > 0) continue;
            throw new NetException(0);
        }
        this.length = this.header[0] & 0xFF;
        this.length <<= 8;
        this.length |= this.header[1] & 0xFF;
        this.type = this.header[4];
        this.flags = this.header[5];
        if (this.type > 19) {
            throw new NetException(204);
        }
        if (this.length > 4086 || this.length > this.sdu) {
            throw new NetException(203);
        }
        if (this.length < 8) {
            throw new NetException(207);
        }
        this.buffer[5] = (byte)this.flags;
        this.buffer[4] = (byte)this.type;
        while (n < this.length) {
            if ((n += this.sAtts.ntInputStream.read(this.buffer, n, this.length - n)) > 0) continue;
            throw new NetException(0);
        }
    }

    protected void send() throws IOException {
        this.sAtts.ntOutputStream.write(this.buffer, 0, this.buffer.length);
    }
}

