/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.internal.OracleResultSetMetaData;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCHAR;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.OracleTypeRAW;
import oracle.jdbc.oracore.OracleTypeREF;
import oracle.sql.StructDescriptor;

public class StructMetaData
implements OracleResultSetMetaData {
    StructDescriptor m_desc;
    OracleTypeADT m_otype;
    OracleType[] m_types;

    public StructMetaData(StructDescriptor structDescriptor) throws SQLException {
        if (structDescriptor == null) {
            DBError.check_error(1, "illegal operation: descriptor is null");
        }
        this.m_desc = structDescriptor;
        this.m_otype = structDescriptor.getOracleTypeADT();
        this.m_types = this.m_otype.getAttrTypes();
    }

    public String getCatalogName(int n) throws SQLException {
        return null;
    }

    public String getColumnClassName(int n) throws SQLException {
        DBError.check_error(23, null);
        return null;
    }

    public int getColumnCount() throws SQLException {
        return this.m_types.length;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        if (this.m_types[n2] instanceof OracleTypeCHAR) {
            return ((OracleTypeCHAR)this.m_types[n2]).getLength();
        }
        if (this.m_types[n2] instanceof OracleTypeRAW) {
            return ((OracleTypeRAW)this.m_types[n2]).getLength();
        }
        return 0;
    }

    public String getColumnLabel(int n) throws SQLException {
        return this.getColumnName(n);
    }

    public String getColumnName(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        return this.m_otype.getAttributeName(n);
    }

    public int getColumnType(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        return this.m_types[n2].getTypeCode();
    }

    public String getColumnTypeName(int n) throws SQLException {
        int n2 = this.getColumnType(n);
        int n3 = this.getValidColumnIndex(n);
        switch (n2) {
            case 12: {
                return "VARCHAR";
            }
            case 1: {
                return "CHAR";
            }
            case -2: {
                return "RAW";
            }
            case 6: {
                return "FLOAT";
            }
            case 2: {
                return "NUMBER";
            }
            case 8: {
                return "DOUBLE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 91: {
                return "DATE";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case -13: {
                return "BFILE";
            }
            case 2002: 
            case 2003: {
                return ((OracleTypeADT)this.m_types[n3]).getFullName();
            }
            case 2006: {
                return "REF " + ((OracleTypeREF)this.m_types[n3]).getFullName();
            }
        }
        return null;
    }

    public String getOracleColumnClassName(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        int n3 = this.getColumnType(n2);
        switch (n3) {
            case 1: {
                return "CHAR";
            }
            case -2: {
                return "RAW";
            }
            case 2: {
                return "NUMBER";
            }
            case 91: {
                return "DATE";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case -13: {
                return "BFILE";
            }
            case 2002: {
                return "STRUCT";
            }
            case 2003: {
                return "ARRAY";
            }
            case 2006: {
                return "REF";
            }
        }
        return null;
    }

    public int getPrecision(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        if (this.m_types[n2] instanceof OracleTypeNUMBER) {
            return ((OracleTypeNUMBER)this.m_types[n2]).getPrecision();
        }
        return 0;
    }

    public int getScale(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        if (this.m_types[n2] instanceof OracleTypeNUMBER) {
            return ((OracleTypeNUMBER)this.m_types[n2]).getScale();
        }
        return 0;
    }

    public String getSchemaName(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        if (this.m_types[n2] instanceof OracleTypeADT) {
            return ((OracleTypeADT)this.m_types[n2]).getSchemaName();
        }
        return "";
    }

    public String getTableName(int n) throws SQLException {
        return null;
    }

    private int getValidColumnIndex(int n) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n2 >= this.m_types.length) {
            DBError.check_error(3, "getValidColumnIndex");
        }
        return n2;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        return false;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        return this.m_types[n2] instanceof OracleTypeCHAR;
    }

    public boolean isCurrency(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        return this.m_types[n2] instanceof OracleTypeNUMBER || this.m_types[n2] instanceof OracleTypeFLOAT;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        return false;
    }

    public int isNullable(int n) throws SQLException {
        return 1;
    }

    public boolean isReadOnly(int n) throws SQLException {
        return false;
    }

    public boolean isSearchable(int n) throws SQLException {
        return false;
    }

    public boolean isSigned(int n) throws SQLException {
        return true;
    }

    public boolean isWritable(int n) throws SQLException {
        return false;
    }
}

