/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.runtime;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.STRUCT;

public class Util {
    static short lastCsId = (short)870;
    static CharacterSet lastCS = CharacterSet.make(870);

    public static Object convertToObject(Datum datum, int n, Object object) throws SQLException {
        if (datum == null) {
            return null;
        }
        if (datum instanceof STRUCT) {
            return ((CustomDatumFactory)object).create(datum, 2002);
        }
        if (datum instanceof REF) {
            return ((CustomDatumFactory)object).create(datum, 2006);
        }
        if (datum instanceof ARRAY) {
            return ((CustomDatumFactory)object).create(datum, 2003);
        }
        if (object != null) {
            return ((CustomDatumFactory)object).create(datum, n);
        }
        if (datum instanceof NUMBER) {
            if (n == 2 || n == 3) {
                return ((NUMBER)datum).bigDecimalValue();
            }
            if (n == 8 || n == 6) {
                return new Double(((NUMBER)datum).doubleValue());
            }
            if (n == 4 || n == 5) {
                return new Integer(((NUMBER)datum).intValue());
            }
            if (n == 7) {
                return new Float(((NUMBER)datum).floatValue());
            }
            throw new SQLException("Unexpected java.sql.OracleTypes type: " + n);
        }
        return datum.toJdbc();
    }

    public static Datum convertToOracle(Object object, OracleConnection oracleConnection) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof CustomDatum) {
            return ((CustomDatum)object).toDatum(oracleConnection);
        }
        if (object instanceof String) {
            short s;
            short s2 = s = oracleConnection == null ? (short)870 : (short)oracleConnection.getDbCsId();
            if (s != lastCsId) {
                lastCsId = s;
                lastCS = CharacterSet.make(lastCsId);
            }
            return new CHAR((String)object, lastCS);
        }
        if (object instanceof BigDecimal) {
            return new NUMBER((BigDecimal)object);
        }
        if (object instanceof Double) {
            return new NUMBER((Double)object);
        }
        if (object instanceof Float) {
            return new NUMBER(((Float)object).floatValue());
        }
        if (object instanceof Integer) {
            return new NUMBER((Integer)object);
        }
        if (object instanceof Timestamp) {
            return new DATE((Timestamp)object);
        }
        if (object instanceof byte[]) {
            return new RAW((byte[])object);
        }
        if (object instanceof Datum) {
            return (Datum)object;
        }
        throw new SQLException("Unable to convert object to oracle.sql.Datum: " + object);
    }

    static boolean isMutable(Datum datum, CustomDatumFactory customDatumFactory) {
        if (datum == null) {
            return false;
        }
        return datum instanceof BFILE || datum instanceof BLOB || datum instanceof CLOB || datum instanceof STRUCT && customDatumFactory != null || datum instanceof ARRAY && customDatumFactory != null;
    }
}

