/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;

public class ARRAY
extends Datum
implements Array {
    static boolean DEBUG = false;
    ArrayDescriptor m_descriptor;
    OracleConnection m_conn;
    Object m_objArray;
    Datum[] m_datumArray;
    byte[] m_locator;
    int m_numElems = -1;
    boolean m_enableBuffering = false;
    boolean m_enableIndexing = false;
    public static final int ACCESS_FORWARD = 1;
    public static final int ACCESS_REVERSE = 2;
    public static final int ACCESS_UNKNOWN = 3;
    int m_accessDirection = 3;
    long m_lastIndex;
    long m_lastOffset;
    long[] m_indexArray;
    long m_imgOffset;
    long m_imgLength;

    public ARRAY(ArrayDescriptor arrayDescriptor, Connection connection, Object object) throws SQLException {
        if (arrayDescriptor != null) {
            this.m_descriptor = arrayDescriptor;
        } else {
            DBError.check_error(61, "ARRAY");
        }
        if (connection != null) {
            this.m_conn = (OracleConnection)connection;
        } else {
            DBError.check_error(8, "Connection is null");
        }
        this.m_datumArray = object == null ? new Datum[0] : this.m_descriptor.toOracleArray(object, 1L, -1);
    }

    public ARRAY(ArrayDescriptor arrayDescriptor, byte[] byArray, Connection connection) throws SQLException {
        super(byArray);
        if (connection != null) {
            this.m_conn = (OracleConnection)connection;
        } else {
            DBError.check_error(8, "Connection is null");
        }
        this.m_descriptor = arrayDescriptor;
        this.m_datumArray = null;
        this.m_locator = null;
    }

    public int getAccessDirection() throws SQLException {
        return this.m_accessDirection;
    }

    public synchronized Object getArray() throws SQLException {
        return this.m_descriptor.toJavaArray(this, 1L, -1, this.getMap(), this.m_enableBuffering);
    }

    public synchronized Object getArray(long l, int n) throws SQLException {
        if (l < 1L || n < 0) {
            DBError.check_error(68, "getArray()");
        }
        return this.m_descriptor.toJavaArray(this, l, n, this.getMap(), false);
    }

    public synchronized Object getArray(long l, int n, Map map) throws SQLException {
        if (l < 1L || n < 0) {
            DBError.check_error(68, "getArray()");
        }
        return this.m_descriptor.toJavaArray(this, l, n, map, false);
    }

    public synchronized Object getArray(Map map) throws SQLException {
        return this.m_descriptor.toJavaArray(this, 1L, -1, map, this.m_enableBuffering);
    }

    public boolean getAutoBuffering() throws SQLException {
        return this.m_enableBuffering;
    }

    public boolean getAutoIndexing() throws SQLException {
        return this.m_enableIndexing;
    }

    public synchronized int getBaseType() throws SQLException {
        return this.m_descriptor.getBaseType();
    }

    public synchronized String getBaseTypeName() throws SQLException {
        return this.m_descriptor.getBaseName();
    }

    public OracleConnection getConnection() throws SQLException {
        return this.m_conn;
    }

    public ArrayDescriptor getDescriptor() throws SQLException {
        return this.m_descriptor;
    }

    public synchronized double[] getDoubleArray() throws SQLException {
        return (double[])this.m_descriptor.toNumericArray(this, 1L, -1, 5, this.m_enableBuffering);
    }

    public synchronized double[] getDoubleArray(long l, int n) throws SQLException {
        return (double[])this.m_descriptor.toNumericArray(this, l, n, 5, false);
    }

    public synchronized float[] getFloatArray() throws SQLException {
        return (float[])this.m_descriptor.toNumericArray(this, 1L, -1, 6, this.m_enableBuffering);
    }

    public synchronized float[] getFloatArray(long l, int n) throws SQLException {
        return (float[])this.m_descriptor.toNumericArray(this, l, n, 6, false);
    }

    public long getImageLength() {
        return this.m_imgLength;
    }

    public long getImageOffset() {
        return this.m_imgOffset;
    }

    public synchronized int[] getIntArray() throws SQLException {
        return (int[])this.m_descriptor.toNumericArray(this, 1L, -1, 4, this.m_enableBuffering);
    }

    public synchronized int[] getIntArray(long l, int n) throws SQLException {
        return (int[])this.m_descriptor.toNumericArray(this, l, n, 4, false);
    }

    public long getLastIndex() throws SQLException {
        return this.m_lastIndex;
    }

    public long getLastOffset() throws SQLException {
        return this.m_lastOffset;
    }

    public byte[] getLocator() {
        return this.m_locator;
    }

    public synchronized long[] getLongArray() throws SQLException {
        return (long[])this.m_descriptor.toNumericArray(this, 1L, -1, 7, this.m_enableBuffering);
    }

    public synchronized long[] getLongArray(long l, int n) throws SQLException {
        return (long[])this.m_descriptor.toNumericArray(this, l, n, 7, false);
    }

    public Map getMap() throws SQLException {
        return this.getConnection().getTypeMap();
    }

    public long getOffset(long l) throws SQLException {
        if (this.m_indexArray == null) {
            return -1L;
        }
        return this.m_indexArray[(int)l - 1];
    }

    public synchronized Datum[] getOracleArray() throws SQLException {
        return this.m_descriptor.toOracleArray(this, 1L, -1, this.m_enableBuffering);
    }

    public synchronized Datum[] getOracleArray(long l, int n) throws SQLException {
        if (l < 1L || n < 0) {
            DBError.check_error(68, "getOracleArray()");
        }
        return this.m_descriptor.toOracleArray(this, l, n, false);
    }

    public synchronized ResultSet getResultSet() throws SQLException {
        return this.getResultSet(this.m_conn.getTypeMap());
    }

    public synchronized ResultSet getResultSet(long l, int n) throws SQLException {
        return this.getResultSet(l, n, this.m_conn.getTypeMap());
    }

    public synchronized ResultSet getResultSet(long l, int n, Map map) throws SQLException {
        if (l < 1L || n < -1) {
            DBError.check_error(68, "getResultSet()");
        }
        return this.m_descriptor.toResultSet(this, l, n, map, false);
    }

    public synchronized ResultSet getResultSet(Map map) throws SQLException {
        return this.m_descriptor.toResultSet(this, 1L, -1, map, this.m_enableBuffering);
    }

    public synchronized String getSQLTypeName() throws SQLException {
        if (this.m_descriptor != null) {
            return this.m_descriptor.getName();
        }
        DBError.check_error(61, "ARRAY");
        return null;
    }

    public synchronized short[] getShortArray() throws SQLException {
        return (short[])this.m_descriptor.toNumericArray(this, 1L, -1, 8, this.m_enableBuffering);
    }

    public synchronized short[] getShortArray(long l, int n) throws SQLException {
        return (short[])this.m_descriptor.toNumericArray(this, l, n, 8, false);
    }

    public boolean hasDataSeg() {
        return this.m_locator == null;
    }

    public boolean isConvertibleTo(Class clazz) {
        return false;
    }

    public synchronized int length() throws SQLException {
        return this.m_descriptor.toLength(this);
    }

    public Object makeJdbcArray(int n) {
        return new Object[n][];
    }

    public synchronized void setAutoBuffering(boolean bl) throws SQLException {
        this.m_enableBuffering = bl;
    }

    public synchronized void setAutoIndexing(boolean bl) throws SQLException {
        this.m_enableIndexing = bl;
        this.m_accessDirection = 3;
    }

    public synchronized void setAutoIndexing(boolean bl, int n) throws SQLException {
        this.m_enableIndexing = bl;
        this.m_accessDirection = n;
    }

    public synchronized void setDatumArray(Datum[] datumArray) {
        this.m_datumArray = datumArray;
    }

    public void setImage(byte[] byArray, long l, long l2) throws SQLException {
        this.setShareBytes(byArray);
        this.m_imgOffset = l;
        this.m_imgLength = l2;
    }

    public void setImageLength(long l) throws SQLException {
        this.m_imgLength = l;
    }

    public void setIndexOffset(long l, long l2) throws SQLException {
        if (this.m_indexArray == null) {
            this.m_indexArray = new long[this.m_numElems];
        }
        this.m_indexArray[(int)l - 1] = l2;
    }

    public void setLastIndexOffset(long l, long l2) throws SQLException {
        this.m_lastIndex = l;
        this.m_lastOffset = l2;
    }

    public synchronized void setLength(int n) {
        this.m_numElems = n;
    }

    public synchronized void setLocator(byte[] byArray) {
        if (byArray != null && byArray.length != 0) {
            this.m_locator = byArray;
        }
    }

    public synchronized void setObjArray(Object object) throws SQLException {
        if (object == null) {
            DBError.throwSqlException(1);
        }
        this.m_objArray = object;
    }

    public synchronized byte[] toBytes() throws SQLException {
        return this.m_descriptor.toBytes(this, this.m_enableBuffering);
    }

    public Object toJdbc() throws SQLException {
        return this;
    }
}

