/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleBlobInputStream;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleConversionInputStream;
import oracle.jdbc.driver.OracleConversionReader;
import oracle.jdbc.driver.OracleDriver;
import oracle.sql.BfileDBAccess;
import oracle.sql.Datum;

public class BFILE
extends Datum {
    static final int MAX_CHUNK_SIZE = 32512;
    OracleConnection m_conn;
    BfileDBAccess m_dbaccess;

    protected BFILE() {
    }

    public BFILE(OracleConnection oracleConnection) throws SQLException {
        this(oracleConnection, null);
    }

    public BFILE(OracleConnection oracleConnection, byte[] byArray) throws SQLException {
        super(byArray);
        if (oracleConnection != null) {
            this.m_conn = oracleConnection;
        } else {
            DBError.check_error(8, "Connection is null");
        }
        this.m_dbaccess = oracleConnection.createBfileDBAccess();
    }

    public InputStream asciiStreamValue() throws SQLException {
        return new OracleConversionInputStream(this.m_conn.conversion, this.getBinaryStream(), 2);
    }

    public InputStream binaryStreamValue() throws SQLException {
        return this.getBinaryStream();
    }

    public Reader characterStreamValue() throws SQLException {
        return new OracleConversionReader(this.m_conn.conversion, this.getBinaryStream(), 8);
    }

    public void closeFile() throws SQLException {
        this.getDBAccess().closeFile(this);
    }

    public boolean fileExists() throws SQLException {
        return this.getDBAccess().fileExists(this);
    }

    public InputStream getBinaryStream() throws SQLException {
        return new OracleBlobInputStream(this, 32512);
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (l < 1L || n < 0) {
            DBError.check_error(68, null);
        }
        if (n == 0) {
            return new byte[0];
        }
        long l2 = 0L;
        byte[] byArray = new byte[n];
        l2 = this.getBytes(l, n, byArray);
        if (l2 > 0L) {
            if (l2 == (long)n) {
                return byArray;
            }
            byte[] byArray2 = new byte[(int)l2];
            System.arraycopy(byArray, 0, byArray2, 0, (int)l2);
            return byArray2;
        }
        return new byte[0];
    }

    public int getBytes(long l, int n, byte[] byArray) throws SQLException {
        return this.getDBAccess().getBytes(this, l, n, byArray);
    }

    public OracleConnection getConnection() throws SQLException {
        if (this.m_conn == null) {
            this.m_conn = (OracleConnection)new OracleDriver().defaultConnection();
        }
        return this.m_conn;
    }

    public BfileDBAccess getDBAccess() throws SQLException {
        if (this.m_dbaccess == null) {
            this.m_dbaccess = this.getConnection().createBfileDBAccess();
        }
        return this.m_dbaccess;
    }

    public String getDirAlias() throws SQLException {
        return this.getDBAccess().getDirAlias(this);
    }

    public byte[] getLocator() {
        return this.getBytes();
    }

    public String getName() throws SQLException {
        return this.getDBAccess().getName(this);
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.io.Reader") == 0;
    }

    public boolean isFileOpen() throws SQLException {
        return this.getDBAccess().isFileOpen(this);
    }

    public long length() throws SQLException {
        return this.getDBAccess().length(this);
    }

    public Object makeJdbcArray(int n) {
        return new BFILE[n];
    }

    public void openFile() throws SQLException {
        this.getDBAccess().openFile(this);
    }

    public long position(BFILE bFILE, long l) throws SQLException {
        return this.getDBAccess().position(this, bFILE, l);
    }

    public long position(byte[] byArray, long l) throws SQLException {
        return this.getDBAccess().position(this, byArray, l);
    }

    public void setLocator(byte[] byArray) {
        this.setBytes(byArray);
    }

    public Object toJdbc() throws SQLException {
        return this;
    }
}

