/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.sql.SQLException;
import oracle.sql.converter.CharacterConverter;

public abstract class CharacterConverter12Byte
extends CharacterConverter {
    static final int ORACHARMASK = 255;
    static final int UCSCHARWIDTH = 16;
    static final int ORACHARWIDTH = 16;
    static final int BYTEWIDTH = 8;
    static final int HIBYTEMASK = 65280;
    static final int LOWBYTEMASK = 255;
    static final int BELOW_CJK = 12287;
    static final int INVALID_ORA_CHAR = 65535;
    transient int m_ucsL1KeyWidth;
    transient int m_ucsL1KeyShift;
    transient int m_ucsL1KeyMask;
    transient int m_ucsL2KeyMask;
    transient int m_oraL1KeyWidth;
    transient int m_oraL1KeyShift;
    transient int m_oraL1KeyMask;
    transient int m_oraL2KeyMask;
    transient char[] m_ucsCharLevel1;
    transient char[] m_ucsCharLevel2;
    transient char m_ucsCharReplacement;
    transient char[] m_oraCharLevel1;
    transient char[] m_oraCharLevel2;
    transient char m_1ByteOraCharReplacement;
    transient char m_2ByteOraCharReplacement;
    static final transient int MAX_7BIT = 127;

    CharacterConverter12Byte() {
        this.m_groupId = 2;
    }

    protected void buildUnicodeToOracleMapping(char[][] cArray) {
        int n;
        int n2;
        int n3;
        int n4;
        char c;
        this.m_ucsL1KeyShift = 16 - this.m_ucsL1KeyWidth;
        this.m_ucsL1KeyMask = (1 << this.m_ucsL1KeyWidth) - 1;
        this.m_ucsL2KeyMask = (1 << this.m_ucsL1KeyShift) - 1;
        int n5 = this.m_oraL1KeyWidth;
        int n6 = 16 - n5;
        int n7 = (1 << n5) - 1;
        int n8 = (1 << n6) - 1;
        this.m_oraL1KeyShift = n6;
        this.m_oraL1KeyMask = n7;
        this.m_oraL2KeyMask = n8;
        int n9 = 1 << n5;
        char[] cArray2 = new char[n9];
        char[][] cArray3 = new char[n9][2];
        int n10 = 0;
        while (n10 < n9) {
            cArray2[n10] = '\u0000';
            cArray3[n10][0] = (char)n8;
            cArray3[n10][1] = '\u0000';
            ++n10;
        }
        int n11 = 65536;
        char c2 = this.m_ucsCharReplacement;
        n10 = 0;
        while (n10 < n11) {
            c = this.toUnicodeWithReplacement(n10);
            if (c != c2) {
                n4 = c >> n6 & n7;
                cArray2[n4] = '\u0001';
                n3 = c & n8;
                if (n3 < cArray3[n4][0]) {
                    cArray3[n4][0] = (char)n3;
                }
                if (n3 > cArray3[n4][1]) {
                    cArray3[n4][1] = (char)n3;
                }
            }
            ++n10;
        }
        if (cArray != null) {
            n11 = cArray.length;
            n10 = 0;
            while (n10 < n11) {
                c = cArray[n10][0];
                n4 = c >> n6 & n7;
                cArray2[n4] = '\u0001';
                n3 = c & n8;
                if (n3 < cArray3[n4][0]) {
                    cArray3[n4][0] = (char)n3;
                }
                if (n3 > cArray3[n4][1]) {
                    cArray3[n4][1] = (char)n3;
                }
                ++n10;
            }
        }
        int n12 = n2 = n8 + 1;
        int n13 = 0;
        n10 = 0;
        while (n10 < n9) {
            if (cArray2[n10] != '\u0000') {
                int n14 = cArray3[n10][0];
                cArray2[n10] = (char)(n12 - (n13 < n14 ? n13 : n14));
                n12 = cArray2[n10] + n2;
                n13 = n2 - cArray3[n10][1] - 1;
            }
            ++n10;
        }
        char[] cArray4 = new char[n12];
        n10 = 0;
        while (n10 < n12) {
            cArray4[n10] = 65535;
            ++n10;
        }
        n11 = 65536;
        n10 = 0;
        while (n10 < n11) {
            c = this.toUnicodeWithReplacement(n10);
            if (c != c2 && cArray4[n = cArray2[n4 = c >> n6 & n7] + (n3 = c & n8)] == '\uffff') {
                cArray4[n] = (char)n10;
            }
            ++n10;
        }
        if (cArray != null) {
            n11 = cArray.length;
            n10 = 0;
            while (n10 < n11) {
                c = cArray[n10][0];
                n4 = c >> n6 & n7;
                n3 = c & n8;
                n = cArray2[n4] + n3;
                if (cArray4[n] == '\uffff') {
                    cArray4[n] = cArray[n10][1];
                }
                ++n10;
            }
        }
        this.m_oraCharLevel1 = cArray2;
        this.m_oraCharLevel2 = cArray4;
    }

    char toOracleCharacter(char c) throws SQLException {
        int n = c >> this.m_oraL1KeyShift & this.m_oraL1KeyMask;
        int n2 = c & this.m_oraL2KeyMask;
        char c2 = this.m_oraCharLevel2[this.m_oraCharLevel1[n] + n2];
        if (c2 == '\uffff') {
            throw new SQLException("Cannot map Unicode to Oracle character.");
        }
        return c2;
    }

    char toOracleCharacterWithReplacement(char c) {
        int n = c >> this.m_oraL1KeyShift & this.m_oraL1KeyMask;
        int n2 = c & this.m_oraL2KeyMask;
        char c2 = this.m_oraCharLevel2[this.m_oraCharLevel1[n] + n2];
        if (c2 == '\uffff') {
            if (c > '\u2fff') {
                return this.m_2ByteOraCharReplacement;
            }
            return this.m_1ByteOraCharReplacement;
        }
        return c2;
    }

    public byte[] toOracleString(String string) throws SQLException {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n * 2];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = this.toOracleCharacter(cArray[n3]);
            int n4 = c & 0xFF00;
            if (n4 != 0) {
                byArray[n2++] = (byte)(n4 >> 8);
            }
            byArray[n2++] = (byte)c;
            ++n3;
        }
        if (n2 < byArray.length) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            return byArray2;
        }
        return byArray;
    }

    public byte[] toOracleStringWithReplacement(String string) {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n * 2];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = this.toOracleCharacterWithReplacement(cArray[n3]);
            int n4 = c & 0xFF00;
            if (n4 != 0) {
                byArray[n2++] = (byte)(n4 >> 8);
            }
            byArray[n2++] = (byte)c;
            ++n3;
        }
        if (n2 < byArray.length) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            return byArray2;
        }
        return byArray;
    }

    char toUnicode(int n) throws SQLException {
        int n2 = n >> this.m_ucsL1KeyShift & this.m_ucsL1KeyMask;
        int n3 = n & this.m_ucsL2KeyMask;
        char c = this.m_ucsCharLevel2[this.m_ucsCharLevel1[n2] + n3];
        if (c == this.m_ucsCharReplacement) {
            throw new SQLException("Cannot map Oracle character to Unicode.");
        }
        return c;
    }

    public String toUnicodeString(byte[] byArray, int n, int n2) throws SQLException {
        if (n2 < 1 || byArray.length < 1) {
            return new String();
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            int n5 = byArray[n + n3] & 0xFF;
            if (n5 > 127) {
                if (n3 < n2 - 1) {
                    n5 = byArray[n3] << 8 & 0xFF00 | byArray[n3 + 1] & 0xFF;
                    ++n3;
                } else {
                    throw new SQLException("Cannot map Oracle character to Unicode.");
                }
            }
            cArray[n4++] = this.toUnicode(n5);
            ++n3;
        }
        return new String(cArray, 0, n4);
    }

    public String toUnicodeStringWithReplacement(byte[] byArray, int n, int n2) {
        if (n2 < 1 || byArray.length < 1) {
            return new String();
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            int n5 = byArray[n + n3] & 0xFF;
            if (n5 > 127) {
                if (n2 - n3 < 2) break;
                n5 = byArray[n3] << 8 & 0xFF00 | byArray[n3 + 1] & 0xFF;
                ++n3;
            }
            cArray[n4++] = this.toUnicodeWithReplacement(n5);
            ++n3;
        }
        return new String(cArray, 0, n4);
    }

    char toUnicodeWithReplacement(int n) {
        int n2 = n >> this.m_ucsL1KeyShift & this.m_ucsL1KeyMask;
        int n3 = n & this.m_ucsL2KeyMask;
        return this.m_ucsCharLevel2[this.m_ucsCharLevel1[n2] + n3];
    }
}

