<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

   <xsl:import href="genIndividu.xsl" />

   <xsl:import href="Liens.xsl" />

   <xsl:output method="html" indent="no" />

   <xsl:param name="baseActionURL">baseActionURL_false</xsl:param>

   <xsl:param name="prefForm" />

   <xsl:param name="modeServant">none</xsl:param>
   <xsl:param name="mediaPath" />

   <xsl:template match="/">
      <xsl:call-template name="genIndividu">
         <xsl:with-param name="civilite" select="xml/individu/civilite" />

         <xsl:with-param name="dossier" select="xml/individu/dossier" />

         <xsl:with-param name="nom_patro" select="xml/individu/nom_patro" />

         <xsl:with-param name="nom_usuel" select="xml/individu/nom_usuel" />

         <xsl:with-param name="prenom" select="xml/individu/prenom" />

      </xsl:call-template>

      <xsl:call-template name="liensHorizontaux">
         <xsl:with-param name="annuaire" select="$modeServant" />
      </xsl:call-template>

      <div class="navigation-selected">
         <P ALIGN="CENTER" class="uportal-background-dark">
            <br />

            <b>E T A T - C I V I L</b>

            <br />

            <br />
         </P>
      </div>

      <xsl:apply-templates select="xml/generalites" />
      <xsl:apply-templates select="xml/infofamille" />
      <xsl:apply-templates select="xml/adresse" />
	  <xsl:apply-templates select="xml/enfants" />
      <xsl:apply-templates select="xml/coor_tel" />
      <xsl:apply-templates select="xml/banques" />
      <xsl:apply-templates select="xml/diplomes" />
	</xsl:template>

   <xsl:template match="generalites">

      <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
         <TR class="uportal-background-light">
            <TD HEIGHT="30"> 
               <P ALIGN="LEFT" class="uportal-channel-strong">Informations Administratives</P>
            </TD>
         </TR>
      </TABLE>

      <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
         <TR>
            <TD WIDTH="25%" class="uportal-channel-strong">Date de naissance</TD>

            <TD WIDTH="25%" class="uportal-text">
               <xsl:value-of select="date_nai" />
            </TD>

            <TD WIDTH="25%" class="uportal-channel-strong">Lieu de naissance</TD>

            <TD WIDTH="25%" class="uportal-text">
               <xsl:value-of select="lieu_nai" />
            </TD>
         </TR>
		</TABLE>
   </xsl:template>

   <xsl:template match="infofamille">
      <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
		<xsl:if test="sitfam_libelle != '' or sitfam_date != ''">
         <TR>
            <TD WIDTH="25%" class="uportal-channel-strong">Situation familiale</TD>
            <TD WIDTH="25%" class="uportal-text">
               <xsl:value-of select="sitfam_libelle" />
            </TD>
			<xsl:if test="sitfam_date != 'null'">
	            <TD WIDTH="25%" class="uportal-channel-strong">Le</TD>
	            <TD WIDTH="25%" class="uportal-text">
               <xsl:value-of select="sitfam_date" />
	            </TD>
			</xsl:if>
			<xsl:if test="sitfam_date = 'null'">
				<TD WIDTH="50%" colspan="2"></TD>
			</xsl:if>
         </TR>
		</xsl:if>
		<xsl:if test="sitmil_lib != '' and nb_enfants != ''">
         <TR>
			<xsl:if test="sitmil_lib != 'null'">
	            <TD WIDTH="25%" class="uportal-channel-strong">Situation militaire</TD>

	            <TD WIDTH="25%" class="uportal-text">
	               <xsl:value-of select="sitmil_lib" />
	            </TD>
			</xsl:if>
			<xsl:if test="sitmil_lib = 'null'">
				<TD WIDTH="50%" colspan="2" class="uportal-text"></TD>
			</xsl:if>
			<xsl:if test="nb_enfants != 'null'">
	            <TD WIDTH="25%" class="uportal-channel-strong">Nombre d'enfants</TD>

	            <TD WIDTH="25%" class="uportal-text">
	               <xsl:value-of select="nb_enfants" />
	            </TD>
			</xsl:if>
			<xsl:if test="nb_enfants = 'null'">
				<TD WIDTH="50%" colspan="2" class="uportal-text"></TD>
			</xsl:if>
         </TR>
		</xsl:if>
		</TABLE>
   </xsl:template>

   <xsl:template match="adresse">
      <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
         <TR>
            <TD WIDTH="25%" class="uportal-channel-strong" valign="TOP">Adresse personnelle</TD>
				<TD WIDTH="75%" class="uportal-text">
					<TABLE>
					<TR>
		            <TD WIDTH="25%" class="uportal-channel-strong">Voie</TD>
		            <TD WIDTH="50%" class="uportal-text">
						<xsl:if test="no_voie != 'null'">
							<xsl:value-of select="no_voie" />
	                  	</xsl:if>
						<xsl:if test="habitant_chez != 'null' and no_voie != 'null'">
							<BR />
						</xsl:if>
						<xsl:if test="habitant_chez != 'null'">
							<xsl:value-of select="habitant_chez" />
						</xsl:if>
		            </TD>
					</TR>
					<xsl:if test="localite != 'null'">
					<TR>
		            <TD WIDTH="25%" class="uportal-channel-strong">Localité</TD>
		            <TD WIDTH="50%" class="uportal-text">
							<xsl:value-of select="localite" />
		            </TD>
					</TR>
					</xsl:if>
					<TR>
		            <TD WIDTH="25%" class="uportal-channel-strong">Code Postal</TD>
		            <TD WIDTH="50%" class="uportal-text">
						<xsl:value-of select="code_postal_ville" />
		            </TD>
					</TR>
					<TR>
		            <TD WIDTH="25%" class="uportal-channel-strong">Pays</TD>
		            <TD WIDTH="50%" class="uportal-text">
						<xsl:value-of select="ll_pays" />
		            </TD>
					</TR>
 					</TABLE>
 				</TD>
         </TR>
		<xsl:if test="telephone_domicile != 'null'">
         <TR>
         	<TD WIDTH="25%" class="uportal-channel-strong">Téléphone personnel</TD>
         	<TD WIDTH="75%" class="uportal-text">
         		<xsl:value-of select="telephone_domicile" />
         	</TD>
         </TR>
			</xsl:if>
			<xsl:if test="email != 'null'">
         <TR>
         	<TD WIDTH="25%" class="uportal-channel-strong">Adresse électronique</TD>
         	<TD WIDTH="75%" class="uportal-text">
         		<xsl:value-of select="email" />
         	</TD>
         </TR>
			</xsl:if>
		</TABLE>
	</xsl:template>

   <xsl:template match="enfants">
	<xsl:if test="count(enfant) != 0">
      <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
         <TR class="uportal-background-light">
            <TD HEIGHT="30"> 
               <P ALIGN="LEFT" class="uportal-channel-strong">Enfant</P>
            </TD>
         </TR>
      </TABLE>

      <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
	 <TR>
	    <TD WIDTH="20%" class="uportal-channel-strong">Nom</TD>
	    <TD WIDTH="20%" class="uportal-channel-strong">Prénom</TD>
	    <TD WIDTH="15%" class="uportal-channel-strong">Sexe</TD>
	    <TD WIDTH="30%" class="uportal-channel-strong">Date et Lieu de naissance</TD>
	    <TD WIDTH="15%" class="uportal-channel-strong">Handicap</TD>
	 </TR>
	<xsl:apply-templates select="enfant" />
	</TABLE>
	</xsl:if>
   </xsl:template>

   <xsl:template match="enfant">
       <TR valign="top">
	    <TD WIDTH="20%" class="uportal-text"><xsl:value-of select="nom_enfant" /></TD>
	    <TD WIDTH="20%" class="uportal-text"><xsl:value-of select="prenom_enfant" /></TD>
	    <TD WIDTH="15%" class="uportal-text"><xsl:value-of select="sexe_enfant" /></TD>
	    <TD WIDTH="30%" class="uportal-text">
			<xsl:if test="date_nai_enfant != 'null'">
				Le <xsl:value-of select="date_nai_enfant" />
			</xsl:if>
			<xsl:if test="lieu_nai_enfant != 'null'">
				 &#224; <xsl:value-of select="lieu_nai_enfant" />
			</xsl:if>
		</TD>
	    <TD WIDTH="15%" class="uportal-text"><xsl:value-of select="pourcent_handicap_enfant" /> %</TD>
		 </TR>
   </xsl:template>

	<xsl:template match="coor_tel">
	<xsl:if test="count(telephone) != 0 or count(fax) != 0"> 
     <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
         <TR class="uportal-background-light">
            <TD HEIGHT="30"> 
               <P ALIGN="LEFT" class="uportal-channel-strong">Téléphones professionnels</P>
            </TD>
         </TR>
      </TABLE>
      <xsl:apply-templates select="telephone" />
      <xsl:apply-templates select="fax" />
	</xsl:if>
   </xsl:template>
	
   <xsl:template match="telephone">
	<xsl:if test="count(numerotel) != 0">
      <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
         <TR>
            <TD WIDTH="25%" class="uportal-channel-strong" valign="TOP">Téléphone</TD>
            <TD WIDTH="75%" class="uportal-text">
               <xsl:value-of select="numerotel" />
            </TD>
         </TR>
      </TABLE>
	</xsl:if>
   </xsl:template>

   <xsl:template match="fax">
	<xsl:if test="count(numerofax) != 0">
      <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
         <TR>
            <TD WIDTH="25%" class="uportal-channel-strong" valign="TOP">Fax</TD>
            <TD WIDTH="75%" class="uportal-text">
               <xsl:value-of select="numerofax" />
            </TD>
         </TR>
       </TABLE>
	</xsl:if>
   </xsl:template>

   <xsl:template match="banques">
	<xsl:if test="count(banque) != 0">
      <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
         <TR class="uportal-background-light">
            <TD HEIGHT="30"> 
               <P ALIGN="LEFT" class="uportal-channel-strong">Références bancaires</P>
            </TD>
         </TR>
      </TABLE>

      <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
	 <TR>
	    <TD WIDTH="20%" class="uportal-channel-strong">Banque</TD>
	    <TD WIDTH="20%" class="uportal-channel-strong">Guichet</TD>
	    <TD WIDTH="30%" class="uportal-channel-strong">Domiciliation</TD>
	    <TD WIDTH="15%" class="uportal-channel-strong">Compte</TD>
	    <TD WIDTH="15%" class="uportal-channel-strong">Clé Rib</TD>
	 </TR>
	<xsl:apply-templates select="banque" />
	</TABLE>
	</xsl:if>
   </xsl:template>

   <xsl:template match="banque">
	 <TR>
	    <TD WIDTH="20%" class="uportal-text"><xsl:value-of select="c_banque" /></TD>
	    <TD WIDTH="20%" class="uportal-text"><xsl:value-of select="c_guichet" /></TD>
	    <TD WIDTH="30%" class="uportal-text"><xsl:value-of select="domiciliation" /></TD>
	    <TD WIDTH="15%" class="uportal-text"><xsl:value-of select="no_compte" /></TD>
	    <TD WIDTH="15%" class="uportal-text"><xsl:value-of select="cle_rib" /></TD>
	 </TR>
   </xsl:template>

   <xsl:template match="diplomes">
	<xsl:if test="count(diplome) != 0">
      <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
         <TR class="uportal-background-light">
            <TD HEIGHT="30"> 
               <P ALIGN="LEFT" class="uportal-channel-strong">Diplômes</P>
            </TD>
         </TR>
      </TABLE>

      <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
	 <TR>
	    <TD WIDTH="10%" class="uportal-channel-strong">Code</TD>
	    <TD WIDTH="30%" class="uportal-channel-strong">Libellé / Spécialité</TD>
	    <TD WIDTH="20%" class="uportal-channel-strong">Niveau</TD>
	    <TD WIDTH="20%" class="uportal-channel-strong">Année</TD>
	    <TD WIDTH="20%" class="uportal-channel-strong">Titulaire</TD>
	 </TR>
	<xsl:apply-templates select="diplome" />
	</TABLE>
	</xsl:if>
   </xsl:template>

   <xsl:template match="diplome">
	 <TR valign="top">
	    <TD WIDTH="10%" class="uportal-text"><xsl:value-of select="c_diplome" /></TD>
	    <TD WIDTH="30%" class="uportal-text"><xsl:value-of select="ll_diplome" /><xsl:if test="specialite != '' and specialite != 'null'">&#160;/&#160;<xsl:value-of select="specialite" /></xsl:if></TD>
	    <TD WIDTH="20%" class="uportal-text"><xsl:value-of select="l_niveau_diplome" /></TD>
	    <TD WIDTH="20%" class="uportal-text"><xsl:value-of select="d_diplome" /></TD>
	    <TD WIDTH="20%" class="uportal-text"><xsl:value-of select="l_titulaire_diplome" /></TD>
	 </TR>
   </xsl:template>
</xsl:stylesheet>

